/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.exaid;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.exaid.ExAidSlashEffectEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ExAidRiderEffect {
    public static void spawnSlashEffect(Level level, LivingEntity owner, Vec3 direction) {
        ExAidSlashEffectEntity.spawnEffect(level, (Entity)owner, direction);
    }

    public static void spawnSlashEffectByRotation(Level level, LivingEntity owner, float yRot, float xRot) {
        Vec3 direction = ExAidRiderEffect.calculateDirectionFromRotations(yRot, xRot);
        ExAidRiderEffect.spawnSlashEffect(level, owner, direction);
    }

    public static void spawnSlashEffectByOwnerDirection(Level level, LivingEntity owner) {
        Vec3 lookVector = owner.m_20252_(1.0f);
        ExAidRiderEffect.spawnSlashEffect(level, owner, lookVector);
    }

    private static Vec3 calculateDirectionFromRotations(float yRot, float xRot) {
        float yRadians = (float)Math.toRadians(yRot);
        float xRadians = (float)Math.toRadians(xRot);
        float xComponent = -Mth.m_14031_((float)yRadians) * Mth.m_14089_((float)xRadians);
        float zComponent = Mth.m_14089_((float)yRadians) * Mth.m_14089_((float)xRadians);
        float yComponent = -Mth.m_14031_((float)xRadians);
        return new Vec3((double)xComponent, (double)yComponent, (double)zComponent).m_82541_();
    }

    public static void spawnMultiSlashEffect(Level level, LivingEntity owner, Vec3 baseDirection, int count, float spreadAngle) {
        if (count <= 1) {
            ExAidRiderEffect.spawnSlashEffect(level, owner, baseDirection);
            return;
        }
        float angleIncrement = spreadAngle / (float)(count - 1);
        float startAngle = -spreadAngle / 2.0f;
        for (int i = 0; i < count; ++i) {
            float currentAngle = startAngle + (float)i * angleIncrement;
            Vec3 direction = ExAidRiderEffect.rotateVectorAroundY(baseDirection, currentAngle);
            ExAidRiderEffect.spawnSlashEffect(level, owner, direction);
        }
    }

    private static Vec3 rotateVectorAroundY(Vec3 vector, float angle) {
        double radians = Math.toRadians(angle);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double x = vector.f_82479_ * cos - vector.f_82481_ * sin;
        double z = vector.f_82479_ * sin + vector.f_82481_ * cos;
        return new Vec3(x, vector.f_82480_, z).m_82541_();
    }
}

