/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.ghost;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import java.util.Comparator;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GhostHeroicSoulEntity
extends Projectile
implements GeoEntity {
    private static final RawAnimation MOVE_ANIMATION = RawAnimation.begin().thenPlay("move");
    private static final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().thenPlay("attack");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int lifetime = 0;
    private static final int MAX_LIFETIME = 100;
    private Vec3 attackDirection;
    private int soulColor;
    private float damage;
    private boolean isFireDamage;
    private int attackCooldown = 0;
    private static final int DEFAULT_ATTACK_COOLDOWN = 10;
    private int health = 20;
    private static final int MAX_HEALTH = 20;
    private int postAttackLifetime = -1;
    private static final int DEFAULT_POST_ATTACK_LIFETIME = 40;
    private UUID ownerUUID = null;
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(GhostHeroicSoulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ATTACKED = SynchedEntityData.m_135353_(GhostHeroicSoulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> SOUL_TYPE = SynchedEntityData.m_135353_(GhostHeroicSoulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private LivingEntity trackingTarget = null;
    private int trackingCooldown = 0;
    private double armor = 12.0;
    private double armorToughness = 6.0;
    private double knockbackResistance = 0.2;

    public GhostHeroicSoulEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
    }

    private GhostHeroicSoulEntity(Level level, LivingEntity owner, Vec3 direction, int color, float damage, boolean isFireDamage) {
        super((EntityType)ModEntityTypes.GHOST_HEROIC_SOUL.get(), level);
        this.m_5602_((Entity)owner);
        this.f_19794_ = true;
        this.m_146884_(owner.m_146892_().m_82549_(direction.m_82490_(1.0)));
        this.attackDirection = direction;
        this.soulColor = color;
        this.damage = damage * 0.75f;
        this.isFireDamage = isFireDamage;
        this.setOwnerUUID(owner.m_20148_());
        this.m_146922_(owner.m_146908_());
        this.m_146926_(owner.m_146909_());
        this.f_19804_.m_135381_(COLOR, (Object)color);
        this.f_19804_.m_135381_(ATTACKED, (Object)false);
        this.setSoulType("MUSASHI");
        this.health = 20;
    }

    public int getSoulColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public boolean hasAttacked() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKED);
    }

    public void setAttacked(boolean value) {
        this.f_19804_.m_135381_(ATTACKED, (Object)value);
    }

    public String getSoulType() {
        return (String)this.f_19804_.m_135370_(SOUL_TYPE);
    }

    public void setSoulType(String type) {
        this.f_19804_.m_135381_(SOUL_TYPE, (Object)type);
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }

    public static void trySpawnEffect(Level level, LivingEntity owner, Vec3 direction, int color, float damage, boolean isFireDamage, String soulType) {
        if (!level.f_46443_) {
            GhostHeroicSoulEntity soulEntity = new GhostHeroicSoulEntity(level, owner, direction, color, damage, isFireDamage);
            soulEntity.setSoulType(soulType);
            level.m_7967_((Entity)soulEntity);
        }
    }

    public static void trySpawnEffect(Level level, Player player, Vec3 direction, int color, float damage, boolean isFireDamage, String soulType) {
        GhostHeroicSoulEntity.trySpawnEffect(level, (LivingEntity)player, direction, color, damage, isFireDamage, soulType);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifetime;
        if (this.trackingCooldown > 0) {
            --this.trackingCooldown;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.hasAttacked() && this.postAttackLifetime == -1) {
            this.postAttackLifetime = 40;
        }
        if (this.postAttackLifetime > 0) {
            --this.postAttackLifetime;
        }
        this.updateTrackingTarget();
        if (this.health <= 0) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return;
        }
        if (this.postAttackLifetime == 0) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return;
        }
        if (!this.hasAttacked() && this.lifetime > 100) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return;
        }
        if (this.trackingTarget != null && this.trackingTarget.m_6084_()) {
            Vec3 targetPos = this.trackingTarget.m_20182_().m_82520_(0.0, (double)(this.trackingTarget.m_20206_() / 2.0f), 0.0);
            Vec3 entityPos = this.m_20182_();
            Vec3 direction = targetPos.m_82546_(entityPos).m_82541_();
            Vec3 moveVec = direction.m_82490_(0.2);
            this.m_20256_(moveVec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.lookAt(targetPos);
        } else if (this.attackDirection != null) {
            Vec3 moveVec = this.attackDirection.m_82490_(0.2);
            this.m_20256_(moveVec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else {
            this.m_20256_(new Vec3(0.0, 0.05, 0.0));
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        if (this.m_9236_().f_46443_) {
            if (this.lifetime % 2 == 0) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + offsetX, this.m_20186_() + 0.5 + offsetY, this.m_20189_() + offsetZ, (double)(this.soulColor >> 16 & 0xFF) / 255.0, (double)(this.soulColor >> 8 & 0xFF) / 255.0, (double)(this.soulColor & 0xFF) / 255.0);
            }
        } else {
            this.checkAndAttackEntities();
            if (this.lifetime % 20 == 0) {
                this.makeHostilesAttackThisEntity();
            }
        }
    }

    private void lookAt(Vec3 targetPos) {
        Vec3 entityPos = this.m_20182_();
        double dx = targetPos.f_82479_ - entityPos.f_82479_;
        double dz = targetPos.f_82481_ - entityPos.f_82481_;
        double yaw = Math.atan2(dz, dx) * 57.29577951308232 - 90.0;
        this.m_146922_((float)yaw);
        this.m_5618_((float)yaw);
        this.m_5616_((float)yaw);
    }

    private void updateTrackingTarget() {
        if (this.trackingCooldown > 0) {
            if (this.trackingTarget != null && (!this.trackingTarget.m_6084_() || this.trackingTarget.m_20280_((Entity)this) > 25.0)) {
                this.trackingTarget = null;
            }
            --this.trackingCooldown;
            return;
        }
        double searchRange = 10.0;
        Entity owner = this.m_19749_();
        LivingEntity nearestTarget = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(searchRange), e -> owner != null && e != owner && e.m_6084_() && this.isHostileTarget((LivingEntity)e, owner)).stream().min(Comparator.comparingDouble(arg_0 -> ((GhostHeroicSoulEntity)this).m_20280_(arg_0))).orElse(null);
        if (nearestTarget != null && nearestTarget != this.trackingTarget) {
            this.trackingTarget = nearestTarget;
            this.trackingCooldown = 20;
        }
    }

    private void checkAndAttackEntities() {
        if (this.attackCooldown > 0) {
            return;
        }
        double range = 2.0;
        Entity owner = this.m_19749_();
        if (owner != null && this.trackingTarget != null && this.trackingTarget.m_6084_() && this.m_20280_((Entity)this.trackingTarget) <= range * range) {
            DamageSource damageSource;
            if (owner instanceof Player) {
                Player player = (Player)owner;
                damageSource = this.m_9236_().m_269111_().m_269075_(player);
            } else if (owner instanceof Mob) {
                Mob mob = (Mob)owner;
                damageSource = this.m_9236_().m_269111_().m_269333_((LivingEntity)mob);
            } else {
                damageSource = this.m_9236_().m_269111_().m_269264_();
            }
            this.trackingTarget.m_6469_(damageSource, this.damage);
            if (this.isFireDamage) {
                this.trackingTarget.m_20254_(5);
            }
            this.attackCooldown = 10;
            this.setAttacked(true);
            return;
        }
        this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(range), e -> e != owner && e.m_6084_() && this.isHostileTarget((LivingEntity)e, owner)).stream().findFirst().ifPresent(entity -> {
            DamageSource damageSource;
            if (owner instanceof Player) {
                Player player = (Player)owner;
                damageSource = this.m_9236_().m_269111_().m_269075_(player);
            } else if (owner instanceof Mob) {
                Mob mob = (Mob)owner;
                damageSource = this.m_9236_().m_269111_().m_269333_((LivingEntity)mob);
            } else {
                damageSource = this.m_9236_().m_269111_().m_269264_();
            }
            entity.m_6469_(damageSource, this.damage);
            if (this.isFireDamage) {
                entity.m_20254_(5);
            }
            this.trackingTarget = entity;
            this.attackCooldown = 10;
            this.setAttacked(true);
        });
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() != null && source.m_7639_() instanceof LivingEntity) {
            float damageAfterArmor = this.calculateDamageAfterArmor(amount);
            this.health = (int)((float)this.health - damageAfterArmor);
            if (this.health <= 0) {
                this.m_142687_(Entity.RemovalReason.KILLED);
                return true;
            }
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 5; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_(), this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), 0.0, 0.0, 0.0);
                }
            }
            return true;
        }
        return super.m_6469_(source, amount);
    }

    private float calculateDamageAfterArmor(float damage) {
        float reduction = (float)Math.min((double)0.8f, this.armor * (double)0.04f);
        float effectiveDamage = damage * (1.0f - reduction);
        return effectiveDamage;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6097_() {
        return true;
    }

    public boolean m_6084_() {
        return super.m_6084_();
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_19390_();
    }

    public boolean m_6094_() {
        return true;
    }

    private void makeHostilesAttackThisEntity() {
        double range = 15.0;
        UUID thisUUID = this.m_20148_();
        Entity owner = this.m_19749_();
        this.m_9236_().m_6443_(Mob.class, this.m_20191_().m_82400_(range), e -> e.m_6084_()).stream().forEach(mob -> {
            if (thisUUID.equals(mob.m_20148_())) {
                return;
            }
            if (mob.m_21573_() != null) {
                mob.m_21573_().m_26519_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.8);
            }
            if (mob.m_20280_((Entity)this) < 4.0) {
                mob.m_21563_().m_24946_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                try {
                    mob.m_21573_().m_26573_();
                    mob.m_21310_(10);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.m_9236_().m_6443_(Monster.class, this.m_20191_().m_82400_(range), e -> e.m_6084_()).stream().forEach(monster -> {
            if (thisUUID.equals(monster.m_20148_())) {
                return;
            }
            if (monster.m_21573_() != null) {
                monster.m_21573_().m_5624_((Entity)this, 0.85);
            }
            monster.m_21563_().m_148051_((Entity)this);
        });
    }

    private boolean isHostileTarget(LivingEntity target, Entity owner) {
        if (owner == null) {
            return false;
        }
        if (owner instanceof Monster) {
            if (target instanceof Player || target instanceof Villager) {
                return true;
            }
        } else if (owner instanceof Player) {
            if (target.m_6095_().m_204039_(EntityTypeTags.f_13121_) || target instanceof Monster) {
                return true;
            }
            Player playerOwner = (Player)owner;
            if (target instanceof Player) {
                return !target.m_20148_().equals(playerOwner.m_20148_()) && playerOwner.m_5647_() != null && !playerOwner.m_5647_().m_83536_(target.m_5647_());
            }
        }
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 3, this::predicate)});
    }

    private PlayState predicate(AnimationState<GhostHeroicSoulEntity> state) {
        if (this.hasAttacked()) {
            state.setAnimation(ATTACK_ANIMATION);
        } else {
            state.setAnimation(MOVE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_5790_(EntityHitResult result) {
        LivingEntity livingEntity;
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity) != this.m_19749_()) {
            this.setAttacked(true);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(COLOR, (Object)0xFFFFFF);
        this.f_19804_.m_135372_(ATTACKED, (Object)false);
        this.f_19804_.m_135372_(SOUL_TYPE, (Object)"MUSASHI");
    }

    protected boolean m_5603_(Entity entity) {
        return super.m_5603_(entity) && entity != this.m_19749_();
    }
}

