/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.hibiki;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HibikiDrumEffectEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().then("animation.hibiki_drum.idle", Animation.LoopType.LOOP);
    private static final RawAnimation CHARGE_ANIMATION = RawAnimation.begin().then("animation.hibiki_drum.charge", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation EXPLOSION_ANIMATION = RawAnimation.begin().then("animation.hibiki_drum.explosion", Animation.LoopType.PLAY_ONCE);
    private Entity owner;
    private LivingEntity targetEntity;
    private int lifetime = 0;
    private static final int MAX_LIFETIME = 200;
    private boolean isCharging = false;
    private int chargeTicks = 0;
    private static final int CHARGE_DURATION = 60;
    private boolean hasExploded = false;
    private double damageAmount = 45.0;
    private static final EntityDataAccessor<Integer> TARGET_ENTITY_ID = SynchedEntityData.m_135353_(HibikiDrumEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_TARGET = SynchedEntityData.m_135353_(HibikiDrumEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_CHARGING = SynchedEntityData.m_135353_(HibikiDrumEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_EXPLODED = SynchedEntityData.m_135353_(HibikiDrumEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public HibikiDrumEffectEntity(EntityType<? extends HibikiDrumEffectEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.m_20331_(true);
    }

    public HibikiDrumEffectEntity(Level level, Entity owner, LivingEntity target) {
        super((EntityType)ModEntityTypes.HIBIKI_DRUM_EFFECT.get(), level);
        this.owner = owner;
        this.targetEntity = target;
        this.f_19794_ = true;
        this.m_20331_(true);
        if (!level.f_46443_) {
            this.syncTargetEntity(target);
        }
        this.updatePositionToTarget();
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifetime;
        if (this.m_9236_().f_46443_) {
            this.updateTargetEntityFromSyncedData();
        }
        this.f_19804_.m_135381_(IS_CHARGING, (Object)this.isCharging);
        this.f_19804_.m_135381_(HAS_EXPLODED, (Object)this.hasExploded);
        if (this.hasExploded) {
            if (this.lifetime > 180) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            return;
        }
        if (this.targetEntity != null && !this.targetEntity.m_213877_() && !this.targetEntity.m_21224_()) {
            this.applyControlEffect(this.targetEntity);
            this.updatePositionToTarget();
            if (!this.isCharging && this.lifetime > 20) {
                this.isCharging = true;
                this.chargeTicks = 0;
            }
            if (this.isCharging) {
                ++this.chargeTicks;
                if (this.chargeTicks >= 60) {
                    this.triggerExplosion();
                }
            }
        } else {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.lifetime > 200) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
    }

    private void updatePositionToTarget() {
        if (this.targetEntity != null && !this.targetEntity.m_213877_()) {
            Vec3 lookVector = this.targetEntity.m_20252_(1.0f).m_82541_();
            double offsetDistance = 1.5;
            double heightOffset = (double)this.targetEntity.m_20206_() * 0.4;
            Vec3 offsetPos = this.targetEntity.m_20182_().m_82520_(0.0, heightOffset, 0.0).m_82549_(lookVector.m_82490_(offsetDistance));
            this.m_6034_(offsetPos.f_82479_, offsetPos.f_82480_, offsetPos.f_82481_);
            this.m_146922_(this.targetEntity.m_146908_() + 180.0f);
            this.m_146926_(0.0f);
        }
    }

    private void applyControlEffect(LivingEntity target) {
        if (!this.m_9236_().f_46443_) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 4, false, false));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 20, 3, false, false));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 20, 0, false, false));
            target.m_20334_(target.m_20184_().f_82479_, Math.min(target.m_20184_().f_82480_, 0.0), target.m_20184_().f_82481_);
        }
    }

    private void triggerExplosion() {
        if (this.hasExploded || this.m_9236_().f_46443_) {
            return;
        }
        this.hasExploded = true;
        if (this.targetEntity != null && !this.targetEntity.m_213877_()) {
            DamageSource damageSource;
            Entity entity = this.owner;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                damageSource = this.m_9236_().m_269111_().m_269075_(player);
            } else {
                entity = this.owner;
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    damageSource = this.m_9236_().m_269111_().m_269333_((LivingEntity)mob);
                } else {
                    damageSource = this.m_9236_().m_269111_().m_269425_();
                }
            }
            this.targetEntity.m_6469_(damageSource, (float)this.damageAmount);
            Vec3 lookVector = this.targetEntity.m_20252_(1.0f).m_82541_();
            this.targetEntity.m_20256_(lookVector.m_82490_(-2.0));
            this.targetEntity.m_20254_(5);
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 0.8f);
    }

    public void setTargetEntity(LivingEntity targetEntity) {
        this.targetEntity = targetEntity;
        if (!this.m_9236_().f_46443_) {
            this.syncTargetEntity(targetEntity);
        }
    }

    private void syncTargetEntity(LivingEntity entity) {
        if (entity != null) {
            this.f_19804_.m_135381_(TARGET_ENTITY_ID, (Object)entity.m_19879_());
            this.f_19804_.m_135381_(HAS_TARGET, (Object)true);
        } else {
            this.f_19804_.m_135381_(TARGET_ENTITY_ID, (Object)0);
            this.f_19804_.m_135381_(HAS_TARGET, (Object)false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateTargetEntityFromSyncedData() {
        if ((Boolean)this.f_19804_.m_135370_(HAS_TARGET) == false) return;
        int entityId = (Integer)this.f_19804_.m_135370_(TARGET_ENTITY_ID);
        if (entityId <= 0) return;
        Entity entity = this.m_9236_().m_6815_(entityId);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!entity.m_213877_()) {
                this.targetEntity = livingEntity;
                return;
            }
        }
        this.f_19804_.m_135381_(HAS_TARGET, (Object)false);
        this.f_19804_.m_135381_(TARGET_ENTITY_ID, (Object)0);
        this.targetEntity = null;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        this.targetEntity = null;
        this.owner = null;
    }

    private PlayState animationPredicate(AnimationState<HibikiDrumEffectEntity> event) {
        if (((Boolean)this.f_19804_.m_135370_(HAS_EXPLODED)).booleanValue()) {
            event.getController().setAnimation(EXPLOSION_ANIMATION);
        } else if (((Boolean)this.f_19804_.m_135370_(IS_CHARGING)).booleanValue()) {
            event.getController().setAnimation(CHARGE_ANIMATION);
        } else {
            event.getController().setAnimation(IDLE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::animationPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TARGET_ENTITY_ID, (Object)0);
        this.f_19804_.m_135372_(HAS_TARGET, (Object)false);
        this.f_19804_.m_135372_(IS_CHARGING, (Object)false);
        this.f_19804_.m_135372_(HAS_EXPLODED, (Object)false);
    }

    protected void m_7378_(CompoundTag nbt) {
        this.lifetime = nbt.m_128451_("Lifetime");
        this.isCharging = nbt.m_128471_("IsCharging");
        this.chargeTicks = nbt.m_128451_("ChargeTicks");
        this.hasExploded = nbt.m_128471_("HasExploded");
        this.damageAmount = nbt.m_128459_("DamageAmount");
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128405_("Lifetime", this.lifetime);
        nbt.m_128379_("IsCharging", this.isCharging);
        nbt.m_128405_("ChargeTicks", this.chargeTicks);
        nbt.m_128379_("HasExploded", this.hasExploded);
        nbt.m_128347_("DamageAmount", this.damageAmount);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static void spawnEffect(Level level, Entity owner, LivingEntity target) {
        if (!level.f_46443_ && target != null && !target.m_213877_()) {
            HibikiDrumEffectEntity effect = new HibikiDrumEffectEntity(level, owner, target);
            level.m_7967_((Entity)effect);
        }
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING);
    }

    public boolean hasExploded() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EXPLODED);
    }

    public LivingEntity getTargetEntity() {
        return this.targetEntity;
    }
}

