/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.kiva;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.kiva.KivaBatEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class KivaBatEffect {
    private static final double GOLDEN_RATIO = (1.0 + Math.sqrt(5.0)) / 2.0;

    public static void spawnBatSwarm(Level level, LivingEntity owner, Vec3 direction, float attackDamage, int count) {
        if (!level.f_46443_) {
            Vec3 playerPos = owner.m_20299_(1.0f);
            KivaBatEffect.spawnTrackingBatPattern(level, owner, direction, attackDamage, count, playerPos);
        }
    }

    private static void spawnTrackingBatPattern(Level level, LivingEntity owner, Vec3 baseDirection, float attackDamage, int count, Vec3 playerPos) {
        for (int i = 0; i < count; ++i) {
            double xOffset = (level.f_46441_.m_188500_() - 0.5) * 0.6;
            double yOffset = (level.f_46441_.m_188500_() - 0.5) * 0.6;
            double zOffset = (level.f_46441_.m_188500_() - 0.5) * 0.6;
            Vec3 localOffset = new Vec3(xOffset, yOffset, zOffset).m_82541_();
            Vec3 direction = KivaBatEffect.calculateDirectionWithOffset(baseDirection, localOffset);
            direction = new Vec3(direction.f_82479_ + (level.f_46441_.m_188500_() - 0.5) * 0.1, direction.f_82480_ + (level.f_46441_.m_188500_() - 0.5) * 0.1, direction.f_82481_ + (level.f_46441_.m_188500_() - 0.5) * 0.1).m_82541_();
            KivaBatEntity.trySpawnEffect(level, owner, direction, attackDamage);
        }
    }

    private static Vec3 calculateDirectionWithOffset(Vec3 baseDirection, Vec3 localOffset) {
        Vec3 forward = baseDirection.m_82541_();
        Vec3 right = new Vec3(-forward.f_82481_, 0.0, forward.f_82479_).m_82541_();
        Vec3 up = forward.m_82537_(right).m_82541_();
        double globalX = localOffset.f_82479_ * right.f_82479_ + localOffset.f_82480_ * forward.f_82479_ + localOffset.f_82481_ * up.f_82479_;
        double globalY = localOffset.f_82479_ * right.f_82480_ + localOffset.f_82480_ * forward.f_82480_ + localOffset.f_82481_ * up.f_82480_;
        double globalZ = localOffset.f_82479_ * right.f_82481_ + localOffset.f_82480_ * forward.f_82481_ + localOffset.f_82481_ * up.f_82481_;
        return new Vec3(globalX, globalY, globalZ).m_82541_();
    }

    public static void spawnBatSwarmByOwnerDirection(Level level, LivingEntity owner, float attackDamage) {
        Vec3 lookVector = owner.m_20252_(1.0f);
        KivaBatEffect.spawnBatSwarm(level, owner, lookVector, attackDamage, 24);
    }

    public static void spawnBatSwarmByRotation(Level level, LivingEntity owner, float yRot, float xRot, float attackDamage, int count) {
        Vec3 direction = KivaBatEffect.calculateDirectionFromRotations(yRot, xRot);
        KivaBatEffect.spawnBatSwarm(level, owner, direction, attackDamage, count);
    }

    private static Vec3 calculateDirectionFromRotations(float yRot, float xRot) {
        float yRadians = (float)Math.toRadians(yRot);
        float xRadians = (float)Math.toRadians(xRot);
        float xComponent = -Mth.m_14031_((float)yRadians) * Mth.m_14089_((float)xRadians);
        float zComponent = Mth.m_14089_((float)yRadians) * Mth.m_14089_((float)xRadians);
        float yComponent = -Mth.m_14031_((float)xRadians);
        return new Vec3((double)xComponent, (double)yComponent, (double)zComponent).m_82541_();
    }
}

