/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.kiva;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KivaBatEntity
extends AbstractHurtingProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation FLY_ANIMATION = RawAnimation.begin().thenPlay("bats");
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(KivaBatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int lifetime = 0;
    private static final int MAX_LIFETIME = 100;
    private UUID ownerUUID = null;
    private UUID targetUUID = null;
    private LivingEntity targetEntity = null;
    private boolean isTracking = false;
    private double trackingSpeed = 0.8;
    private double wanderSpeed = 0.3;
    private double currentSpeed = 0.8;

    public KivaBatEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = false;
    }

    private KivaBatEntity(Level level, LivingEntity owner, Vec3 direction, float attackDamage) {
        super((EntityType)ModEntityTypes.KIVA_BAT_EFFECT.get(), level);
        this.m_5602_((Entity)owner);
        this.f_19794_ = false;
        this.m_146884_(owner.m_146892_().m_82549_(direction.m_82490_(1.0)));
        this.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.2f, 5.0f);
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(attackDamage));
        this.setOwnerUUID(owner.m_20148_());
        this.m_146922_(owner.m_146908_());
        this.m_146926_(owner.m_146909_());
        this.setVisualFire(false);
        this.m_20254_(0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    private float getDamageValue() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::animationPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private PlayState animationPredicate(AnimationState<KivaBatEntity> event) {
        event.getController().setAnimation(FLY_ANIMATION);
        return PlayState.CONTINUE;
    }

    public void m_8119_() {
        this.m_20095_();
        this.setVisualFire(false);
        ++this.lifetime;
        this.handleTrackingBehavior();
        if (this.lifetime >= 100) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.lifetime < 20) {
            this.currentSpeed = Math.min(this.trackingSpeed, this.currentSpeed + 0.05);
        } else if (this.lifetime > 70) {
            this.currentSpeed = Math.max(this.wanderSpeed, this.currentSpeed - 0.02);
        }
        super.m_8119_();
        this.m_20095_();
        this.setVisualFire(false);
    }

    private void handleTrackingBehavior() {
        LivingEntity owner = this.getOwner();
        if (!this.isTracking && this.targetEntity == null && owner != null) {
            this.findAndTrackTarget(owner);
        }
        if (this.isTracking && this.targetEntity != null && this.targetEntity.m_6084_()) {
            this.trackTarget();
        } else {
            if (owner != null) {
                this.findAndTrackTarget(owner);
            }
            if (this.targetEntity == null) {
                this.isTracking = false;
            }
        }
    }

    private void findAndTrackTarget(LivingEntity owner) {
        double searchRange = this.lifetime < 30 ? 15.0 : 8.0;
        Vec3 pos = this.m_20182_();
        List nearbyEntities = this.m_9236_().m_6443_(LivingEntity.class, new AABB(pos.f_82479_ - searchRange, pos.f_82480_ - searchRange, pos.f_82481_ - searchRange, pos.f_82479_ + searchRange, pos.f_82480_ + searchRange, pos.f_82481_ + searchRange), entity -> entity != owner && entity.m_6084_() && owner.m_6779_(entity));
        if (!nearbyEntities.isEmpty()) {
            LivingEntity nearestTarget = null;
            double nearestDistance = Double.MAX_VALUE;
            for (LivingEntity entity2 : nearbyEntities) {
                double distance = entity2.m_20280_((Entity)this);
                if (!(distance < nearestDistance)) continue;
                nearestDistance = distance;
                nearestTarget = entity2;
            }
            if (nearestTarget != null) {
                this.targetEntity = nearestTarget;
                this.targetUUID = nearestTarget.m_20148_();
                this.isTracking = true;
                this.currentSpeed = this.trackingSpeed;
            }
        }
    }

    private void trackTarget() {
        if (this.targetEntity == null) {
            return;
        }
        Vec3 targetPos = this.targetEntity.m_20182_().m_82520_(0.0, (double)this.targetEntity.m_20206_() * 0.5, 0.0);
        Vec3 toTarget = targetPos.m_82546_(this.m_20182_()).m_82541_();
        double randomX = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.1;
        double randomY = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.1;
        double randomZ = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.1;
        Vec3 adjustedDirection = new Vec3(toTarget.f_82479_ + randomX, toTarget.f_82480_ + randomY, toTarget.f_82481_ + randomZ).m_82541_();
        this.m_20256_(adjustedDirection.m_82490_(this.currentSpeed));
        this.updateRotationToTarget(toTarget);
    }

    private void updateRotationToTarget(Vec3 direction) {
        double horizontalDistance = Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
        float yaw = (float)Math.toDegrees(Math.atan2(direction.f_82481_, direction.f_82479_)) - 90.0f;
        float pitch = (float)Math.toDegrees(Math.atan2(direction.f_82480_, horizontalDistance));
        this.m_146922_(yaw);
        this.m_146926_(pitch);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.ownerUUID != null) {
            compound.m_128362_("OwnerUUID", this.ownerUUID);
        }
        if (this.targetUUID != null) {
            compound.m_128362_("TargetUUID", this.targetUUID);
        }
        compound.m_128405_("Lifetime", this.lifetime);
        compound.m_128350_("Damage", this.getDamageValue());
        compound.m_128379_("IsTracking", this.isTracking);
        compound.m_128347_("CurrentSpeed", this.currentSpeed);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("OwnerUUID")) {
            this.ownerUUID = compound.m_128342_("OwnerUUID");
        }
        if (compound.m_128403_("TargetUUID")) {
            this.targetUUID = compound.m_128342_("TargetUUID");
        }
        this.lifetime = compound.m_128451_("Lifetime");
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(compound.m_128457_("Damage")));
        this.isTracking = compound.m_128471_("IsTracking");
        this.currentSpeed = compound.m_128459_("CurrentSpeed");
    }

    protected DamageSource getDamageSource() {
        LivingEntity owner = this.getOwner();
        if (owner != null) {
            return this.m_269291_().m_269299_((Entity)this, owner);
        }
        return this.m_269291_().m_269425_();
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            float damage = this.getDamageValue() * 0.3f;
            target.m_6469_(this.getDamageSource(), damage);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected float m_6884_() {
        return 0.95f;
    }

    public boolean isVisualFire() {
        return false;
    }

    public void setVisualFire(boolean visualFire) {
    }

    public void m_20254_(int seconds) {
    }

    public boolean m_20068_() {
        return true;
    }

    public LivingEntity getOwner() {
        UUID uuid = this.getOwnerUUID();
        if (uuid == null || this.m_9236_() == null) {
            return null;
        }
        Player owner = this.m_9236_().m_46003_(uuid);
        if (owner instanceof LivingEntity) {
            return (LivingEntity)owner;
        }
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(20.0))) {
            if (!entity.m_20148_().equals(uuid) || !entity.m_6084_()) continue;
            return entity;
        }
        return null;
    }

    public static void trySpawnEffect(Level level, LivingEntity owner, Vec3 direction, float attackDamage) {
        if (!level.f_46443_ && ModEntityTypes.KIVA_BAT_EFFECT.get() != null) {
            KivaBatEntity effect = new KivaBatEntity(level, owner, direction, attackDamage);
            level.m_7967_((Entity)effect);
        }
    }
}

