/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.kuuga;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KuugaRiderEntity
extends Fireball
implements GeoEntity {
    private float attackDamage = 45.0f;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation FLY_ANIMATION = RawAnimation.begin().thenLoop("idle");

    public KuugaRiderEntity(EntityType<? extends Fireball> type, Level level) {
        super(type, level);
    }

    public KuugaRiderEntity(Level level, double x, double y, double z, double dx, double dy, double dz) {
        super((EntityType)ModEntityTypes.KUUGA_RIDER.get(), x, y, z, dx, dy, dz, level);
    }

    public void setAttackDamage(float damage) {
        this.attackDamage = damage;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            Vec3 position = this.m_20182_();
            for (int i = 0; i < 3; ++i) {
                double dx = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double dy = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double dz = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, position.f_82479_, position.f_82480_, position.f_82481_, dx, dy, dz);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123808_, position.f_82479_, position.f_82480_, position.f_82481_, dx, dy, dz);
            }
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            this.executeMightyBlast();
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void executeMightyBlast() {
        Vec3 position = this.m_20182_();
        this.m_9236_().m_254877_((Entity)this, this.m_269291_().m_269453_((Fireball)this, this.m_19749_()), null, position.f_82479_, position.f_82480_, position.f_82481_, 3.0f, false, Level.ExplosionInteraction.NONE);
        this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(6.0), entity -> {
            boolean basicCondition;
            boolean bl = basicCondition = entity != this.m_19749_() && entity.m_6084_();
            if (this.m_19749_() instanceof LivingEntity && !(this.m_19749_() instanceof Player)) {
                return basicCondition && !(entity instanceof Player);
            }
            return basicCondition;
        }).forEach(entity -> {
            double distance = entity.m_20280_((Entity)this);
            float damageFactor = 1.0f - (float)Math.min(distance, 16.0) / 16.0f;
            entity.m_6469_(this.m_269291_().m_269453_((Fireball)this, this.m_19749_()), this.attackDamage * damageFactor * 1.5f);
            Vec3 knockback = entity.m_20182_().m_82546_(position).m_82541_().m_82490_(2.0);
            entity.m_20256_(entity.m_20184_().m_82549_(knockback));
        });
        this.m_9236_().m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
        for (int i = 0; i < 100; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 3.0;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 3.0;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 3.0;
            if (this.f_19796_.m_188499_()) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, position.f_82479_, position.f_82480_ + 1.0, position.f_82481_, dx * 0.5, dy * 0.5, dz * 0.5);
                continue;
            }
            if (this.f_19796_.m_188499_()) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123808_, position.f_82479_, position.f_82480_ + 1.0, position.f_82481_, dx * 0.5, dy * 0.5, dz * 0.5);
                continue;
            }
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, position.f_82479_, position.f_82480_ + 1.0, position.f_82481_, dx * 0.5, dy * 0.5, dz * 0.5);
        }
    }

    public static void trySpawnEffect(Level level, LivingEntity shooter, Vec3 direction, float damage) {
        if (!level.f_46443_) {
            KuugaRiderEntity kuugaEntity = new KuugaRiderEntity(level, shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_(), shooter.m_20189_(), direction.f_82479_ * 2.0, direction.f_82480_ * 2.0, direction.f_82481_ * 2.0);
            kuugaEntity.m_5602_((Entity)shooter);
            kuugaEntity.setAttackDamage(damage);
            level.m_7967_((Entity)kuugaEntity);
            level.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_12008_, SoundSource.HOSTILE, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        }
    }

    protected boolean m_5931_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "fly_controller", 0, state -> state.setAndContinue(FLY_ANIMATION))});
    }
}

