/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.ooo;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OOOGeoEntity
extends AbstractHurtingProjectile
implements GeoEntity {
    private String coinType = "tatoba";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation SPIN_ANIMATION = RawAnimation.begin().thenPlay("spin");
    private static final EntityDataAccessor<String> COIN_TYPE = SynchedEntityData.m_135353_(OOOGeoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(OOOGeoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int lifetime = 0;
    private static final int MAX_LIFETIME = 80;
    private UUID ownerUUID = null;
    private UUID targetUUID = null;
    private LivingEntity targetEntity = null;
    private boolean isTracking = false;
    private double orbitRadius = 1.0;
    private double orbitAngle = 0.0;
    private double orbitSpeed = 0.1;

    public OOOGeoEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
    }

    private OOOGeoEntity(Level level, LivingEntity owner, Vec3 direction, float attackDamage, String coinType) {
        super((EntityType)ModEntityTypes.OOO_GEO_EFFECT.get(), level);
        this.m_5602_((Entity)owner);
        this.f_19794_ = true;
        this.m_146884_(owner.m_146892_().m_82549_(direction.m_82490_(1.0)));
        this.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.5f, 0.0f);
        this.setCoinType(coinType);
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(attackDamage));
        this.setOwnerUUID(owner.m_20148_());
        this.m_146922_(owner.m_146908_());
        this.m_146926_(owner.m_146909_());
        this.orbitAngle = level.f_46441_.m_188500_() * Math.PI * 2.0;
        this.setVisualFire(false);
        this.m_20254_(0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COIN_TYPE, (Object)"tatoba");
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    private float getDamageValue() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }

    public void setCoinType(String coinType) {
        this.coinType = coinType;
        this.f_19804_.m_135381_(COIN_TYPE, (Object)coinType);
    }

    public String getCoinType() {
        return (String)this.f_19804_.m_135370_(COIN_TYPE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::animationPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private PlayState animationPredicate(AnimationState<OOOGeoEntity> event) {
        event.getController().setAnimation(SPIN_ANIMATION);
        return PlayState.CONTINUE;
    }

    public void m_8119_() {
        this.m_20095_();
        this.setVisualFire(false);
        ++this.lifetime;
        if ("putotyra".equals(this.getCoinType())) {
            this.handleTrackingBehavior();
        }
        if (this.lifetime >= 80) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (!this.isTracking) {
            super.m_8119_();
            this.m_20095_();
            this.setVisualFire(false);
        }
    }

    private void handleTrackingBehavior() {
        LivingEntity owner = this.getOwner();
        if (!this.isTracking && this.targetEntity == null && owner != null) {
            this.findAndTrackTarget(owner);
        }
        if (this.isTracking && this.targetEntity != null && this.targetEntity.m_6084_()) {
            this.orbitAroundTarget();
        } else {
            if (owner != null) {
                this.findAndTrackTarget(owner);
            }
            if (this.targetEntity == null) {
                this.isTracking = false;
            }
        }
    }

    private void findAndTrackTarget(LivingEntity owner) {
        double searchRange = this.lifetime < 20 ? 15.0 : 8.0;
        Vec3 pos = this.m_20182_();
        List nearbyEntities = this.m_9236_().m_6443_(LivingEntity.class, new AABB(pos.f_82479_ - searchRange, pos.f_82480_ - searchRange, pos.f_82481_ - searchRange, pos.f_82479_ + searchRange, pos.f_82480_ + searchRange, pos.f_82481_ + searchRange), entity -> entity != owner && entity.m_6084_() && owner.m_6779_(entity));
        if (!nearbyEntities.isEmpty()) {
            LivingEntity nearestTarget = null;
            double nearestDistance = Double.MAX_VALUE;
            for (LivingEntity entity2 : nearbyEntities) {
                double distance = entity2.m_20280_((Entity)this);
                if (!(distance < nearestDistance)) continue;
                nearestDistance = distance;
                nearestTarget = entity2;
            }
            if (nearestTarget != null) {
                this.targetEntity = nearestTarget;
                this.targetUUID = nearestTarget.m_20148_();
                this.isTracking = true;
                this.orbitRadius = 0.8 + (double)nearestTarget.m_20205_() * 0.5;
                this.orbitSpeed = 0.1 + (double)Math.min(this.lifetime, 60) / 60.0 * 0.1;
            }
        }
    }

    private void orbitAroundTarget() {
        if (this.targetEntity == null) {
            return;
        }
        this.orbitAngle += this.orbitSpeed;
        if (this.orbitAngle > Math.PI * 2) {
            this.orbitAngle -= Math.PI * 2;
        }
        double offsetX = Math.cos(this.orbitAngle) * this.orbitRadius;
        double offsetY = Math.sin(this.orbitAngle * 0.5) * 0.3;
        double offsetZ = Math.sin(this.orbitAngle) * this.orbitRadius;
        Vec3 targetCenter = this.targetEntity.m_20182_().m_82520_(0.0, (double)this.targetEntity.m_20206_() * 0.5, 0.0);
        Vec3 newPos = targetCenter.m_82520_(offsetX, offsetY, offsetZ);
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        this.orbitSpeed += (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.01;
        this.orbitSpeed = Math.max(0.05, Math.min(this.orbitSpeed, 0.2));
        if (this.lifetime > 40) {
            this.orbitRadius *= 0.99;
            this.orbitRadius = Math.max(this.orbitRadius, 0.3);
        }
        if (this.lifetime % 10 == 0 && this.targetEntity.m_6084_()) {
            this.targetEntity.m_6469_(this.getDamageSource(), this.getDamageValue() * 0.2f);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.ownerUUID != null) {
            compound.m_128362_("OwnerUUID", this.ownerUUID);
        }
        if (this.targetUUID != null) {
            compound.m_128362_("TargetUUID", this.targetUUID);
        }
        compound.m_128359_("CoinType", this.getCoinType());
        compound.m_128405_("Lifetime", this.lifetime);
        compound.m_128350_("Damage", this.getDamageValue());
        compound.m_128379_("IsTracking", this.isTracking);
        compound.m_128347_("OrbitRadius", this.orbitRadius);
        compound.m_128347_("OrbitAngle", this.orbitAngle);
        compound.m_128347_("OrbitSpeed", this.orbitSpeed);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("OwnerUUID")) {
            this.ownerUUID = compound.m_128342_("OwnerUUID");
        }
        if (compound.m_128403_("TargetUUID")) {
            this.targetUUID = compound.m_128342_("TargetUUID");
        }
        this.setCoinType(compound.m_128461_("CoinType"));
        this.lifetime = compound.m_128451_("Lifetime");
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(compound.m_128457_("Damage")));
        this.isTracking = compound.m_128471_("IsTracking");
        this.orbitRadius = compound.m_128459_("OrbitRadius");
        this.orbitAngle = compound.m_128459_("OrbitAngle");
        this.orbitSpeed = compound.m_128459_("OrbitSpeed");
    }

    protected DamageSource getDamageSource() {
        LivingEntity owner = this.getOwner();
        if (owner != null) {
            return this.m_269291_().m_269299_((Entity)this, owner);
        }
        return this.m_269291_().m_269425_();
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            float damage = this.getDamageValue();
            damage = "latorartar".equals(this.getCoinType()) ? (damage *= 1.3f) : ("shauta".equals(this.getCoinType()) ? (damage *= 1.1f) : ("sagohzo".equals(this.getCoinType()) ? (damage *= 1.0f) : ("putotyra".equals(this.getCoinType()) ? (damage *= 1.5f) : (damage *= 1.2f))));
            target.m_6469_(this.getDamageSource(), damage);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected float m_6884_() {
        switch (this.getCoinType()) {
            case "latorartar": {
                return 0.95f;
            }
            case "shauta": {
                return 0.98f;
            }
            case "sagohzo": {
                return 0.92f;
            }
            case "putotyra": {
                return 0.9f;
            }
        }
        return 0.96f;
    }

    public boolean isVisualFire() {
        return false;
    }

    public void setVisualFire(boolean visualFire) {
    }

    public void m_20254_(int seconds) {
    }

    public boolean m_20068_() {
        return "shauta".equals(this.getCoinType()) || "tatoba".equals(this.getCoinType());
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() instanceof Player) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return true;
        }
        return false;
    }

    public LivingEntity getOwner() {
        UUID uuid = this.getOwnerUUID();
        if (uuid == null || this.m_9236_() == null) {
            return null;
        }
        Player owner = this.m_9236_().m_46003_(uuid);
        if (owner instanceof LivingEntity) {
            return (LivingEntity)owner;
        }
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(20.0))) {
            if (!entity.m_20148_().equals(uuid) || !entity.m_6084_()) continue;
            return entity;
        }
        return null;
    }

    public LivingEntity getTarget() {
        if (this.targetEntity != null && this.targetEntity.m_6084_()) {
            return this.targetEntity;
        }
        if (this.targetUUID != null && this.m_9236_() != null) {
            for (Entity entity : this.m_9236_().m_45976_(Entity.class, this.m_20191_().m_82400_(20.0))) {
                if (!entity.m_20148_().equals(this.targetUUID) || !(entity instanceof LivingEntity) || !entity.m_6084_()) continue;
                this.targetEntity = (LivingEntity)entity;
                return this.targetEntity;
            }
        }
        this.targetEntity = null;
        this.targetUUID = null;
        this.isTracking = false;
        return null;
    }

    public static void trySpawnEffect(Level level, LivingEntity owner, Vec3 direction, float attackDamage, String coinType) {
        if (!level.f_46443_ && ModEntityTypes.OOO_GEO_EFFECT.get() != null) {
            OOOGeoEntity effect = new OOOGeoEntity(level, owner, direction, attackDamage, coinType);
            level.m_7967_((Entity)effect);
        }
    }
}

