/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.world.dimension;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DimensionSafeSpawnHandler {
    private static final ResourceLocation DESERT_OF_TIME = new ResourceLocation("kamen_rider_weapon_craft:the_desertof_time");

    @SubscribeEvent
    public static void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        Level level;
        BlockPos spawnPos;
        Entity entity = event.getEntity();
        ResourceLocation dimension = event.getDimension().m_135782_();
        if (dimension.equals((Object)DESERT_OF_TIME) && entity.m_9236_().f_46443_ && !(spawnPos = DimensionSafeSpawnHandler.findSafeSpawnPosition(level = entity.m_9236_(), entity.m_20183_())).equals((Object)entity.m_20183_())) {
            entity.m_6034_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 1.0, (double)spawnPos.m_123343_() + 0.5);
        }
    }

    private static BlockPos findSafeSpawnPosition(Level level, BlockPos startPos) {
        int surfaceY = 70;
        BlockPos surfacePos = new BlockPos(startPos.m_123341_(), surfaceY, startPos.m_123343_());
        if (DimensionSafeSpawnHandler.isSafeSpawnPosition(level, surfacePos)) {
            return surfacePos;
        }
        for (int radius = 1; radius <= 10; ++radius) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos checkPos;
                    if (Math.abs(x) != radius && Math.abs(z) != radius || !DimensionSafeSpawnHandler.isSafeSpawnPosition(level, checkPos = surfacePos.m_7918_(x, 0, z))) continue;
                    return checkPos;
                }
            }
        }
        return new BlockPos(startPos.m_123341_(), surfaceY + 1, startPos.m_123343_());
    }

    private static boolean isSafeSpawnPosition(Level level, BlockPos pos) {
        BlockState feetBlock = level.m_8055_(pos);
        BlockState headBlock = level.m_8055_(pos.m_7494_());
        BlockState groundBlock = level.m_8055_(pos.m_7495_());
        return groundBlock.m_280296_() && headBlock.m_60795_() && feetBlock.m_60795_();
    }
}

