/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.worldgen.portal;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.ITeleporter;

public class ModTeleporter
implements ITeleporter {
    private final BlockPos targetPos;
    private final boolean toHelheim;

    public ModTeleporter(BlockPos pos, boolean toHelheim) {
        this.targetPos = pos;
        this.toHelheim = toHelheim;
    }

    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destinationWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        entity = repositionEntity.apply(false);
        BlockPos destinationPos = this.findSafePosition(destinationWorld, this.targetPos);
        entity.m_6021_((double)destinationPos.m_123341_() + 0.5, (double)destinationPos.m_123342_(), (double)destinationPos.m_123343_() + 0.5);
        return entity;
    }

    private BlockPos findSafePosition(ServerLevel world, BlockPos startPos) {
        if (this.toHelheim) {
            return this.findSafePositionFromY(world, startPos, 60);
        }
        return this.findSafePositionFromY(world, startPos, startPos.m_123342_());
    }

    private BlockPos findSafePositionFromY(ServerLevel world, BlockPos pos, int startY) {
        BlockPos checkPos;
        int y;
        for (y = startY = Math.min(Math.max(startY, world.m_141937_() + 1), world.m_151558_() - 2); y < world.m_151558_() - 2; ++y) {
            checkPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
            if (!this.isSafePosition(world, checkPos)) continue;
            return checkPos;
        }
        for (y = startY; y > world.m_141937_() + 1; --y) {
            checkPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
            if (!this.isSafePosition(world, checkPos)) continue;
            return checkPos;
        }
        return new BlockPos(pos.m_123341_(), startY, pos.m_123343_());
    }

    private boolean isSafePosition(ServerLevel world, BlockPos pos) {
        BlockState floor = world.m_8055_(pos.m_7495_());
        BlockState feet = world.m_8055_(pos);
        BlockState head = world.m_8055_(pos.m_7494_());
        return !(floor.m_60795_() || !feet.m_60795_() && !feet.m_247087_() || !head.m_60795_() && !head.m_247087_());
    }
}

