/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.worldgen.tree.custom;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.xiaoshi2022.kamen_rider_weapon_craft.blocks.portals.plant.HelheimVine;
import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModBlocks;
import com.xiaoshi2022.kamen_rider_weapon_craft.worldgen.tree.ModFoliagePlacers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class PineFoliagePlacer
extends FoliagePlacer {
    public static final Codec<PineFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> PineFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, PineFoliagePlacer::new));

    public PineFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)ModFoliagePlacers.PINE_FOLIAGE_PLACER.get();
    }

    protected void m_213633_(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, int freeTreeHeight, FoliagePlacer.FoliageAttachment foliageAttachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos pos = foliageAttachment.m_161451_();
        this.generateSwampLeaves(level, setter, random, config, pos, foliageHeight, foliageRadius);
        this.generateNaturalVines(level, setter, random, pos, foliageHeight, foliageRadius);
    }

    private void generateSwampLeaves(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos pos, int foliageHeight, int foliageRadius) {
        for (int yOffset = 0; yOffset < foliageHeight; ++yOffset) {
            float density = 0.8f - (float)yOffset * 0.05f;
            int currentRadius = (int)((float)foliageRadius * (1.1f - (float)yOffset / (float)foliageHeight));
            for (int x = -currentRadius; x <= currentRadius; ++x) {
                for (int z = -currentRadius; z <= currentRadius; ++z) {
                    BlockPos leafPos;
                    if (x * x + z * z > currentRadius * currentRadius || !(random.m_188501_() < density) || !this.canPlaceLeaf(level, leafPos = pos.m_7918_(x, yOffset, z))) continue;
                    BlockState leafState = (BlockState)config.f_161213_.m_213972_(random, leafPos).m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(random.m_188501_() < 0.3f));
                    setter.m_271838_(leafPos, leafState);
                }
            }
        }
    }

    private void generateNaturalVines(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, BlockPos treeTop, int foliageHeight, int foliageRadius) {
        ArrayList<BlockPos> vineStarts = new ArrayList<BlockPos>();
        int minY = treeTop.m_123342_() - foliageHeight + 2;
        for (int y = treeTop.m_123342_(); y >= minY; --y) {
            for (int x = -foliageRadius; x <= foliageRadius; ++x) {
                for (int z = -foliageRadius; z <= foliageRadius; ++z) {
                    BlockPos pos = new BlockPos(treeTop.m_123341_() + x, y, treeTop.m_123343_() + z);
                    BlockPos below = pos.m_7495_();
                    if (!this.isLeaf(level, pos) || !level.m_7433_(below, state -> state.m_60795_())) continue;
                    vineStarts.add(pos);
                }
            }
        }
        Collections.shuffle(vineStarts, new Random(random.m_188505_()));
        int vineCount = Math.min(3 + random.m_188503_(3), vineStarts.size());
        for (int i = 0; i < vineCount; ++i) {
            this.growVineDownward(level, setter, random, ((BlockPos)vineStarts.get(i)).m_7495_());
        }
    }

    private void growVineDownward(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, BlockPos startPos) {
        BlockPos currentPos = startPos;
        int maxLength = 5 + random.m_188503_(6);
        for (int i = 0; i < maxLength && this.canPlaceVine(level, currentPos); ++i) {
            setter.m_271838_(currentPos, ((HelheimVine)((Object)ModBlocks.HELHEIMVINE.get())).m_49966_());
            if (random.m_188501_() < 0.25f && i > 1) {
                this.growSideVine(level, setter, random, currentPos);
            }
            if (random.m_188501_() < 0.1f) break;
            currentPos = currentPos.m_7495_();
        }
    }

    private void growSideVine(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, BlockPos pos) {
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
        int length = 1 + random.m_188503_(2);
        BlockPos currentPos = pos;
        for (int i = 0; i < length && this.canPlaceVine(level, currentPos = currentPos.m_121945_(direction)) && this.hasSolidNeighbor(level, currentPos); ++i) {
            setter.m_271838_(currentPos, ((HelheimVine)((Object)ModBlocks.HELHEIMVINE.get())).m_49966_());
        }
    }

    private boolean canPlaceLeaf(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, state -> state.m_60795_());
    }

    private boolean canPlaceVine(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, state -> state.m_60795_() || state.m_60734_() == ModBlocks.HELHEIMVINE.get());
    }

    private boolean hasSolidNeighbor(LevelSimulatedReader level, BlockPos pos) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            if (!level.m_7433_(pos.m_121945_(dir), state -> !state.m_60795_())) continue;
            return true;
        }
        return false;
    }

    private boolean isLeaf(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, state -> state.m_60734_() instanceof LeavesBlock);
    }

    public int m_214116_(RandomSource random, int freeTreeHeight, TreeConfiguration config) {
        return 4 + random.m_188503_(3);
    }

    protected boolean m_214203_(RandomSource random, int x, int y, int z, int range, boolean large) {
        return false;
    }
}

