package art.ginzburg.uikeybinds;

import art.ginzburg.uikeybinds.client.keybinds.*;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1109;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UIKeybinds implements ModInitializer {

  public static final List<Keybind> keybindList = List.of(
      new SingleplayerJump(), // Main Menu -> Jumps into the singleplayer menu with "S"
      new MultiplayerJump(), // Main Menu -> Jumps into the multiplayer menu with "M"
      new MultiplayerListJump(), // Server List -> Joins server with "1-9" or "M" for 1
      new MultiplayerDisconnectScreenBack(), // Disconnected Screen -> Escapes to Server List with "ESC"
      new MultiplayerAddServer(), // Server List -> Jumps to Add new server screen with "A"
      new SelectWorldScreenEnterWorld(), // World Select -> Joins the selected world with "Enter" even when the
                                         // selection is on SearchBox
      new GameMenuScreenEscape(), // Pause Menu -> Selects the disconnect button with "E" (as Exit)
      new CreativeInventorySearch(), // Creative Inventory Menu -> Selects the search tab with "TAB". If search tab
                                     // is already selected, clears the search box value
      new MultiplayerRefreshList() // Server List -> Refreshes the server list with "R"
  );

  private final Set<Integer> pressedKeys = new HashSet<>();

  @Override
  public void onInitialize() {
    ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
  }

  private void onClientTick(class_310 client) {
    long windowHandle = class_310.method_1551().method_22683().method_4490();

    for (Keybind keybind : keybindList) {
      for (Integer key : keybind.getKeybinds()) {
        if (class_3675.method_15987(windowHandle, key)) {
          if (!pressedKeys.contains(key)) {
            pressedKeys.add(key);
            onKeyPress(client, key);
          }
        } else {
          pressedKeys.remove(key);
        }
      }
    }
  }

  private void onKeyPress(class_310 client, int key) {
    if (client.field_1755 == null)
      return;

    for (Keybind keybind : keybindList) {
      if (keybind.getKeybinds().contains(key)) {
        assert client.field_1755 != null;
        if (keybind.getScreen() == client.field_1755.getClass()) {
          keybind.handle(key);
          assert class_310.method_1551().field_1755 != null;
          class_310.method_1551().method_1483().method_4873(class_1109.method_47978(class_3417.field_15204, 1.3f));
          return;
        }
      }
    }
  }
}
