package art.ginzburg.uikeybinds.client.keybinds;

import org.lwjgl.glfw.GLFW;

import java.util.List;
import java.util.Map;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4267;
import net.minecraft.class_500;

public class MultiplayerListJump implements Keybind {

  private final Map<Integer, Integer> keyMap = Map.ofEntries(
      Map.entry(GLFW.GLFW_KEY_1, 1),
      Map.entry(GLFW.GLFW_KEY_2, 2),
      Map.entry(GLFW.GLFW_KEY_3, 3),
      Map.entry(GLFW.GLFW_KEY_4, 4),
      Map.entry(GLFW.GLFW_KEY_5, 5),
      Map.entry(GLFW.GLFW_KEY_6, 6),
      Map.entry(GLFW.GLFW_KEY_7, 7),
      Map.entry(GLFW.GLFW_KEY_8, 8),
      Map.entry(GLFW.GLFW_KEY_9, 9),
      Map.entry(GLFW.GLFW_KEY_0, 10),
      Map.entry(GLFW.GLFW_KEY_M, 1));

  @Override
  public String getActionName() {
    return "Jump to Server in Server List";
  }

  @Override
  public List<Integer> getKeybinds() {
    return keyMap.keySet().stream().toList();
  }

  @Override
  public Class<?> getScreen() {
    return class_500.class;
  }

  @Override
  public int getRequiredPresses() {
    return 0;
  }

  @Override
  public void handle(Integer key) {
    var screen = (class_500) class_310.method_1551().field_1755;
    assert screen != null;
    try {
      var server = screen.method_2529().method_2982(keyMap.get(key) - 1);
      for (class_364 child : screen.method_25396()) {
        if (child.getClass() == class_4267.class) {
          var entry = ((class_4267) child).method_25396().get(keyMap.get(key) - 1);
          screen.method_2531(entry);
          screen.method_2536();
          return;
        }
      }
      System.out.println(server.field_3761);
    } catch (Exception ex) {
      // ignore
    }
  }
}
