/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.nomobfarm;

import io.github.orlouge.nomobfarm.MobDeathScoreAlgorithm;
import io.github.orlouge.nomobfarm.NoMobFarmMod;
import java.util.Date;
import java.util.function.Function;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class BasicMobDeathScoreAlgorithm
extends MobDeathScoreAlgorithm {
    private final Function<class_1309, Integer> slowdownFunction;
    private final int maxWait;
    private final float recoveryRate;
    private final float minDeaths;
    private final float maxDeaths;
    private final long offlinePersistence;
    private final BasicMobDeathScoreAlgorithmNotify notified;
    private float mobDeathCount = 0.0f;
    private int ticksUntilNextSpawn = 0;
    private int lastTicksUntilNextSpawn = 0;
    private boolean running = false;

    public BasicMobDeathScoreAlgorithm(Function<class_1309, Integer> slowdownFunction, int maxWait, float recoveryRate, int minDeaths, int maxDeaths, long offlinePersistence, BasicMobDeathScoreAlgorithmNotify notified) {
        this.slowdownFunction = slowdownFunction;
        this.maxWait = maxWait;
        this.recoveryRate = recoveryRate;
        this.minDeaths = minDeaths;
        this.maxDeaths = maxDeaths;
        this.notified = notified;
        this.offlinePersistence = offlinePersistence;
    }

    public BasicMobDeathScoreAlgorithm(int slowdownRate, int maxWait, float recoveryRate, int minDeaths, int maxDeaths, long offlinePersistence, BasicMobDeathScoreAlgorithmNotify notified) {
        this(e -> slowdownRate, maxWait, recoveryRate, minDeaths, maxDeaths, offlinePersistence, notified);
    }

    public BasicMobDeathScoreAlgorithm(int slowdownRate, int maxWait, float recoveryRate, int minDeaths, int maxDeaths, long offlinePersistence) {
        this(slowdownRate, maxWait, recoveryRate, minDeaths, maxDeaths, offlinePersistence, null);
    }

    @Override
    public void signalDeath(class_1309 entity) {
        this.mobDeathCount = Float.min(1000000.0f, this.mobDeathCount + 1.0f);
        if (!this.running && this.mobDeathCount >= this.minDeaths) {
            this.running = true;
            this.notified.notifyLargeScoreChange();
        }
        if (this.running) {
            this.ticksUntilNextSpawn += this.slowdownFunction.apply(entity) * (int)Float.min(100.0f, this.mobDeathCount);
            this.ticksUntilNextSpawn = Integer.min(this.maxWait, this.ticksUntilNextSpawn);
        }
        if (NoMobFarmMod.LOGGING) {
            NoMobFarmMod.LOGGER.info(this.mobDeathCount + "," + this.ticksUntilNextSpawn);
        }
    }

    @Override
    public void tick() {
        if (!this.running || this.maxDeaths > 0.0f && this.mobDeathCount >= this.maxDeaths) {
            return;
        }
        this.ticksUntilNextSpawn = Integer.max(0, this.ticksUntilNextSpawn - 1);
        this.mobDeathCount = Float.max(0.0f, this.mobDeathCount - this.recoveryRate);
        if (this.notified != null && Math.abs(this.ticksUntilNextSpawn - this.lastTicksUntilNextSpawn) > 1000) {
            this.notified.notifyLargeScoreChange();
            this.lastTicksUntilNextSpawn = this.ticksUntilNextSpawn;
        }
    }

    @Override
    public boolean acceptableScore() {
        return this.ticksUntilNextSpawn < 10;
    }

    @Override
    public void readNbt(class_2487 nbtCompound) {
        if (nbtCompound.method_10545("NoMobFarmsData")) {
            class_2487 data = nbtCompound.method_10562("NoMobFarmsData");
            if (data.method_10545("whenWritten") && new Date(data.method_10537("whenWritten") + this.offlinePersistence * 1000L).before(new Date())) {
                if (this.ticksUntilNextSpawn >= 1000 || this.mobDeathCount >= 1.0f) {
                    this.notified.notifyLargeScoreChange();
                }
                return;
            }
            if (data.method_10545("ticksUntilNextSpawn")) {
                this.lastTicksUntilNextSpawn = this.ticksUntilNextSpawn = data.method_10550("ticksUntilNextSpawn");
            }
            if (data.method_10545("mobDeathCount")) {
                this.mobDeathCount = data.method_10583("mobDeathCount");
                if (this.mobDeathCount > 0.0f || this.lastTicksUntilNextSpawn > 0) {
                    this.running = true;
                }
            }
        }
    }

    @Override
    public void writeNbt(class_2487 nbtCompound) {
        class_2487 data = nbtCompound.method_10562("NoMobFarmsData");
        data.method_10569("ticksUntilNextSpawn", this.ticksUntilNextSpawn);
        data.method_10548("mobDeathCount", this.mobDeathCount);
        data.method_10544("whenWritten", new Date().getTime());
        if (!nbtCompound.method_10545("NoMobFarmsData")) {
            nbtCompound.method_10566("NoMobFarmsData", (class_2520)data);
        }
    }

    public static interface BasicMobDeathScoreAlgorithmNotify {
        public void notifyLargeScoreChange();
    }
}

