/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.nomobfarm.mixin;

import io.github.orlouge.nomobfarm.TrackedMobOrigin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkSerializer.class})
public class ChunkSerializerMixin {
    @Inject(method={"deserialize(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/world/poi/PointOfInterestStorage;Lnet/minecraft/util/math/ChunkPos;Lnet/minecraft/nbt/NbtCompound;)Lnet/minecraft/world/chunk/ProtoChunk;"}, at={@At(value="RETURN")})
    private static void onDeserialize(ServerLevel world, PoiManager poiStorage, ChunkPos chunkPos, CompoundTag nbt, CallbackInfoReturnable<ProtoChunk> cir) {
        ProtoChunk chunk = (ProtoChunk)cir.getReturnValue();
        if (chunk instanceof TrackedMobOrigin) {
            ((TrackedMobOrigin)chunk).getMobDeathScoreAlgorithm().readNbt(nbt);
        }
    }

    @ModifyVariable(method={"serialize(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/world/chunk/Chunk;)Lnet/minecraft/nbt/NbtCompound;"}, at=@At(value="STORE"), ordinal=0)
    private static CompoundTag onSerialize(CompoundTag nbt, ServerLevel world, ChunkAccess chunk) {
        if (chunk instanceof TrackedMobOrigin) {
            ((TrackedMobOrigin)chunk).getMobDeathScoreAlgorithm().writeNbt(nbt);
        }
        return nbt;
    }
}

