/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.nomobfarm.mixin;

import io.github.orlouge.nomobfarm.BasicMobDeathScoreAlgorithm;
import io.github.orlouge.nomobfarm.HasTrackedOrigin;
import io.github.orlouge.nomobfarm.MobDeathScoreAlgorithm;
import io.github.orlouge.nomobfarm.NoMobFarmMod;
import io.github.orlouge.nomobfarm.TrackedMobOrigin;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BaseSpawner.class})
public class MobSpawnerLogicMixin
implements TrackedMobOrigin,
BasicMobDeathScoreAlgorithm.BasicMobDeathScoreAlgorithmNotify {
    private AABB detectionBox = null;
    protected MobDeathScoreAlgorithm deathScore = new BasicMobDeathScoreAlgorithm(this.slowdownFunction(NoMobFarmMod.SPAWNER_SLOWDOWN_NEAR_RATE, NoMobFarmMod.SPAWNER_SLOWDOWN_FAR_RATE), NoMobFarmMod.SPAWNER_MAX_WAIT, NoMobFarmMod.SPAWNER_RECOVERY_RATE, NoMobFarmMod.SPAWNER_MIN_DEATHS, NoMobFarmMod.SPAWNER_MAX_DEATHS, (long)NoMobFarmMod.SPAWNER_OFFLINE_PERSISTENCE, (BasicMobDeathScoreAlgorithm.BasicMobDeathScoreAlgorithmNotify)this);
    @Shadow
    private int f_45453_;
    private boolean setDirty = false;

    @Override
    public MobDeathScoreAlgorithm getMobDeathScoreAlgorithm() {
        return this.deathScore;
    }

    @Inject(method={"serverTick(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onTick(ServerLevel world, BlockPos pos, CallbackInfo ci) {
        this.deathScore.tick();
        if (!this.deathScore.acceptableScore()) {
            ci.cancel();
        }
        if (this.setDirty) {
            world.m_7702_(pos).m_6596_();
            this.setDirty = false;
        }
    }

    @ModifyVariable(method={"serverTick(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;)V"}, at=@At(value="STORE"), ordinal=0)
    public Entity onMobsAboutToSpawn(Entity entity, ServerLevel world, BlockPos pos) {
        this.detectionBox = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)).m_82400_((double)this.f_45453_);
        if (entity != null && entity instanceof HasTrackedOrigin) {
            ((HasTrackedOrigin)entity).setOrigin(this);
        }
        return entity;
    }

    @Inject(method={"readNbt(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/nbt/NbtCompound;)V"}, at={@At(value="HEAD")})
    public void onReadNbt(Level world, BlockPos pos, CompoundTag nbt, CallbackInfo ci) {
        this.deathScore.readNbt(nbt);
    }

    @Inject(method={"writeNbt(Lnet/minecraft/nbt/NbtCompound;)Lnet/minecraft/nbt/NbtCompound;"}, at={@At(value="HEAD")})
    public void onWriteNbt(CompoundTag nbt, CallbackInfoReturnable<CompoundTag> cir) {
        this.deathScore.writeNbt(nbt);
    }

    @Override
    public void notifyLargeScoreChange() {
        this.setDirty = true;
    }

    private Function<LivingEntity, Integer> slowdownFunction(int nearRate, int farRate) {
        return entity -> {
            if (this.detectionBox == null || entity.m_20191_().m_82381_(this.detectionBox)) {
                return nearRate;
            }
            return farRate;
        };
    }
}

