/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.nomobfarm.mixin;

import io.github.orlouge.nomobfarm.NoMobFarmMod;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raids;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Raids.class})
public class RaidManagerMixin {
    @Inject(method={"startRaid(Lnet/minecraft/server/network/ServerPlayerEntity;)Lnet/minecraft/village/raid/Raid;"}, at={@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    public void checkPOIExtent(ServerPlayer player, CallbackInfoReturnable<Raid> cir, DimensionType dt, BlockPos blockPos, List<PoiRecord> poiList, int i, Vec3 vec3d) {
        Iterator<PoiRecord> iter = poiList.iterator();
        if (iter.hasNext()) {
            BlockPos firstPoi = iter.next().m_27257_();
            int ax = firstPoi.m_123341_();
            int az = firstPoi.m_123343_();
            int bx = ax;
            int bz = az;
            while (iter.hasNext()) {
                BlockPos poi = iter.next().m_27257_();
                ax = Integer.min(ax, poi.m_123341_());
                az = Integer.min(az, poi.m_123343_());
                bx = Integer.max(bx, poi.m_123341_());
                bz = Integer.max(bz, poi.m_123343_());
            }
            if ((bx - ax) * (bz - az) >= NoMobFarmMod.RAID_MIN_SIZE) {
                return;
            }
        }
        cir.setReturnValue(null);
        cir.cancel();
    }

    @ModifyArg(method={"startRaid(Lnet/minecraft/server/network/ServerPlayerEntity;)Lnet/minecraft/village/raid/Raid;"}, at=@At(value="INVOKE", target="Lnet/minecraft/village/raid/RaidManager;getOrCreateRaid(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/village/raid/Raid;"), index=1)
    public BlockPos modifyRaidCenter(ServerLevel world, BlockPos pos) {
        return pos.m_7918_(this.randomizeCenterCoord(world), this.randomizeCenterCoord(world), this.randomizeCenterCoord(world));
    }

    private int randomizeCenterCoord(ServerLevel world) {
        int extent = NoMobFarmMod.RAID_CENTER_MAX_RANDOMIZATION - NoMobFarmMod.RAID_CENTER_MIN_RANDOMIZATION;
        if (extent < 1) {
            return 0;
        }
        int offset2 = world.f_46441_.m_188503_(2 * extent);
        int offset = offset2 - extent;
        return offset + Integer.signum(offset) * NoMobFarmMod.RAID_CENTER_MIN_RANDOMIZATION;
    }
}

