/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.randomitems;

import net.minecraft.ChatFormatting;
import net.minecraft.world.BossEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.IntValue MAX_TIME = BUILDER.comment("The interval in ticks in which random items are given.").defineInRange("maxTime", 600, 100, Integer.MAX_VALUE);
    private static final ModConfigSpec.IntValue SPECIAL_ITEM_CHANCE = BUILDER.comment("The chance of a special item being given to applicable players. 0 stops these items from being given. Calculated as 1/X.").defineInRange("specialItemChance", 100, 0, Integer.MAX_VALUE);
    private static final ModConfigSpec.EnumValue<BossEvent.BossBarColor> BAR_COLOR = BUILDER.comment("The color of the timer bar.").defineEnum("barColor", (Enum)BossEvent.BossBarColor.RED);
    private static final ModConfigSpec.EnumValue<ChatFormatting> NAME_COLOR_ENUM = BUILDER.comment("The color of the timer bar title. Will be used if nameColorRGB is -1.").defineEnum("nameColorEnum", (Enum)ChatFormatting.YELLOW, (Enum[])new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.DARK_BLUE, ChatFormatting.DARK_GREEN, ChatFormatting.DARK_AQUA, ChatFormatting.DARK_RED, ChatFormatting.DARK_PURPLE, ChatFormatting.GOLD, ChatFormatting.GRAY, ChatFormatting.DARK_GRAY, ChatFormatting.BLUE, ChatFormatting.GREEN, ChatFormatting.AQUA, ChatFormatting.RED, ChatFormatting.LIGHT_PURPLE, ChatFormatting.YELLOW, ChatFormatting.WHITE});
    private static final ModConfigSpec.IntValue NAME_COLOR_RBG = BUILDER.comment("The color of the timer bar title. If -1, will use nameColorEnum instead.").defineInRange("nameColorRGB", -1, Integer.MIN_VALUE, Integer.MAX_VALUE);
    static final ModConfigSpec SPEC = BUILDER.build();

    public static int getMaxTime() {
        return (Integer)MAX_TIME.get();
    }

    public static void setMaxTime(int maxTime) {
        MAX_TIME.set((Object)maxTime);
    }

    public static int getSpecialItemChance() {
        return (Integer)SPECIAL_ITEM_CHANCE.get();
    }

    public static void setSpecialItemChance(int specialItemChance) {
        SPECIAL_ITEM_CHANCE.set((Object)specialItemChance);
    }

    public static BossEvent.BossBarColor getBarColor() {
        return (BossEvent.BossBarColor)BAR_COLOR.get();
    }

    public static void setBarColor(BossEvent.BossBarColor barColor) {
        BAR_COLOR.set((Object)barColor);
    }

    public static int getNameColor() {
        return (Integer)NAME_COLOR_RBG.get() == -1 ? ((ChatFormatting)NAME_COLOR_ENUM.get()).getColor() : (Integer)NAME_COLOR_RBG.get();
    }

    public static void setNameColor(int nameColor) {
        NAME_COLOR_RBG.set((Object)nameColor);
    }

    public static void setNameColor(ChatFormatting nameColor) {
        NAME_COLOR_ENUM.set((Object)(nameColor.isColor() ? nameColor : ChatFormatting.YELLOW));
        NAME_COLOR_RBG.set((Object)-1);
    }
}

