/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.randomitems.mixin;

import java.util.function.BooleanSupplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.tintankgames.randomitems.Config;
import net.tintankgames.randomitems.RandomItemMod;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Unique
    private final MinecraftServer server = (MinecraftServer)this;

    @Inject(at={@At(value="HEAD")}, method={"tickServer"})
    private void onStartTick(BooleanSupplier shouldKeepTicking, CallbackInfo info) {
        RandomItemMod.PROGRESS_BAR.setColor(Config.getBarColor());
        RandomItemMod.PROGRESS_BAR.setName((Component)Component.literal((String)"Random Item Timer").withStyle(Style.EMPTY.withColor(Config.getNameColor())));
    }

    @Inject(at={@At(value="TAIL")}, method={"tickServer"})
    private void onEndTick(BooleanSupplier shouldKeepTicking, CallbackInfo info) {
        this.server.getPlayerList().getPlayers().forEach(player -> {
            if (!RandomItemMod.PROGRESS_BAR.getPlayers().contains(player)) {
                RandomItemMod.PROGRESS_BAR.addPlayer(player);
            }
        });
        if (RandomItemMod.timer >= Config.getMaxTime()) {
            this.server.getPlayerList().getPlayers().forEach(player -> {
                ItemStack item = RandomItemMod.items(this.server.getWorldData().enabledFeatures(), (RegistryAccess)this.server.registryAccess(), player, true, item1 -> false);
                RandomItemMod.handleSpecialItems((Player)player, (RegistryAccess)this.server.registryAccess());
                if (!item.isEmpty() && !player.addItem(item)) {
                    player.drop(item, true);
                }
            });
            RandomItemMod.givingSpecialItemsTo.clear();
            RandomItemMod.timer = -1;
        }
        RandomItemMod.PROGRESS_BAR.setProgress((float)(++RandomItemMod.timer) / (float)Config.getMaxTime());
    }
}

