/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.randomitems;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.Bees;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.component.InstrumentComponent;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.OminousBottleAmplifier;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.tintankgames.randomitems.Config;

@Mod(value="random_item")
public class RandomItemMod {
    public static final String MOD_ID = "random_item";
    public static final ServerBossEvent PROGRESS_BAR = new ServerBossEvent((Component)Component.literal((String)"Random Item Timer").withStyle(ChatFormatting.YELLOW), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    public static int timer = 0;
    public static List<String> givingSpecialItemsTo = new ArrayList<String>();
    public static List<String> hasSpecialItem = List.of("0da494af-d922-40aa-9174-2b795512051f", "d7e048f1-8f13-49d9-ab7d-2e901be183b1", "1a9d589d-db4c-4763-85c8-789b524708ad", "bc31fa8f-dbbe-4ee0-b4e7-8648d292c8b9");

    public RandomItemMod(ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static ItemStack items(FeatureFlagSet enabledFeatures, RegistryAccess registryAccess, ServerPlayer player, boolean allowSpecialItems, Predicate<Item> excludedItems) {
        if (Config.getSpecialItemChance() > 0 && allowSpecialItems && player.getRandom().nextInt(Config.getSpecialItemChance()) == 0 && hasSpecialItem.contains(player.getStringUUID().toLowerCase())) {
            givingSpecialItemsTo.add(player.getStringUUID());
            return ItemStack.EMPTY;
        }
        ItemStack stack = RandomItemMod.item((Item)Util.getRandom(BuiltInRegistries.ITEM.stream().filter(excludedItems.negate()).toList(), (RandomSource)player.getRandom()), enabledFeatures, registryAccess, player, excludedItems);
        return stack.isEmpty() ? RandomItemMod.items(enabledFeatures, registryAccess, player, allowSpecialItems, excludedItems) : stack;
    }

    /*
     * WARNING - void declaration
     */
    public static ItemStack item(Item item, FeatureFlagSet enabledFeatures, RegistryAccess registryAccess, ServerPlayer player, Predicate<Item> excludedItems) {
        ItemStack stack = new ItemStack((ItemLike)item);
        if (!(stack.is(Items.AIR) || stack.is(Items.DEBUG_STICK) || stack.is(Items.COMMAND_BLOCK_MINECART) || stack.is(Items.STRUCTURE_VOID) || stack.is(Items.TEST_BLOCK) || stack.is(Items.TEST_INSTANCE_BLOCK) || !stack.isItemEnabled(enabledFeatures) || excludedItems.test(item))) {
            CompoundTag tag;
            Item chestData;
            RandomizableContainer randomizableContainer;
            Item entityBlock;
            BlockEntity blockEntity;
            BlockItem blockItem;
            Block block;
            Item item2;
            ArrayList<ResourceLocation> chestLootTables;
            if (item instanceof PotionItem || item instanceof TippedArrowItem) {
                Optional potion = BuiltInRegistries.POTION.getRandom(player.getRandom());
                if (potion.isPresent()) {
                    stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents((Holder)potion.get()));
                } else {
                    stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WATER));
                }
            }
            if (stack.is(Items.ENCHANTED_BOOK)) {
                stack = EnchantmentHelper.enchantItem((RandomSource)player.getRandom(), (ItemStack)stack.transmuteCopy((ItemLike)Items.BOOK), (int)player.getRandom().nextInt(1, 30), (RegistryAccess)registryAccess, Optional.empty());
            }
            if (!stack.is(Items.BOOK) && player.getRandom().nextInt(10) == 0) {
                EnchantmentHelper.enchantItem((RandomSource)player.getRandom(), (ItemStack)stack, (int)player.getRandom().nextInt(1, 30), (RegistryAccess)registryAccess, Optional.empty());
            }
            if (stack.is(ItemTags.TRIMMABLE_ARMOR) && player.getRandom().nextInt(32) == 0) {
                Optional material = registryAccess.lookupOrThrow(Registries.TRIM_MATERIAL).getRandom(player.getRandom());
                Optional pattern = registryAccess.lookupOrThrow(Registries.TRIM_PATTERN).getRandom(player.getRandom());
                if (material.isPresent() && pattern.isPresent()) {
                    stack.set(DataComponents.TRIM, (Object)new ArmorTrim((Holder)material.get(), (Holder)pattern.get()));
                }
            }
            if (item instanceof BundleItem) {
                chestLootTables = new ArrayList<ResourceLocation>();
                for (ResourceLocation resourceLocation : List.copyOf(player.getServer().reloadableRegistries().lookup().lookupOrThrow(Registries.LOOT_TABLE).listElementIds().map(ResourceKey::location).toList())) {
                    if (!resourceLocation.getPath().startsWith("chests/")) continue;
                    chestLootTables.add(resourceLocation);
                }
                ObjectArrayList stacks = ((LootTable)player.getServer().reloadableRegistries().lookup().lookupOrThrow(Registries.LOOT_TABLE).getOrThrow(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)((ResourceLocation)chestLootTables.get(player.getRandom().nextInt(chestLootTables.size()))))).value()).getRandomItems(new LootParams.Builder(player.level()).withParameter(LootContextParams.ORIGIN, (Object)player.position()).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player).create(LootContextParamSets.CHEST));
                stack.set(DataComponents.BUNDLE_CONTENTS, (Object)new BundleContents((List)stacks));
            }
            if ((item2 = stack.getItem()) instanceof BlockItem && (block = (blockItem = (BlockItem)item2).getBlock()) instanceof EntityBlock && (blockEntity = (entityBlock = (EntityBlock)block).newBlockEntity(BlockPos.ZERO, blockItem.getBlock().defaultBlockState())) instanceof RandomizableContainer && !((randomizableContainer = (RandomizableContainer)blockEntity) instanceof DecoratedPotBlockEntity)) {
                ArrayList<ResourceLocation> chestLootTables2 = new ArrayList<ResourceLocation>();
                for (ResourceLocation table3 : List.copyOf(player.getServer().reloadableRegistries().lookup().lookupOrThrow(Registries.LOOT_TABLE).listElementIds().map(ResourceKey::location).toList())) {
                    if (!table3.getPath().startsWith("chests/")) continue;
                    chestLootTables2.add(table3);
                }
                stack.set(DataComponents.CONTAINER_LOOT, (Object)new SeededContainerLoot(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)((ResourceLocation)chestLootTables2.get(player.getRandom().nextInt(chestLootTables2.size())))), player.getRandom().nextLong()));
            }
            if ((entityBlock = stack.getItem()) instanceof BlockItem && (blockItem = (BlockItem)entityBlock).getBlock() instanceof DecoratedPotBlock) {
                ArrayList sherds = new ArrayList();
                HolderSet.Named named = BuiltInRegistries.ITEM.getOrThrow(ItemTags.DECORATED_POT_SHERDS);
                for (int i = 0; i < 4; ++i) {
                    named.getRandomElement(player.getRandom()).ifPresent(sherd -> sherds.add((Item)sherd.value()));
                }
                stack.set(DataComponents.POT_DECORATIONS, (Object)new PotDecorations((Item)sherds.get(0), (Item)sherds.get(1), (Item)sherds.get(2), (Item)sherds.get(3)));
                ArrayList<ResourceLocation> potLootTables = new ArrayList<ResourceLocation>();
                for (ResourceLocation table : List.copyOf(player.getServer().reloadableRegistries().lookup().lookupOrThrow(Registries.LOOT_TABLE).listElementIds().map(ResourceKey::location).toList())) {
                    if (!table.getPath().startsWith("archaeology/") && !table.getPath().startsWith("pots/")) continue;
                    potLootTables.add(table);
                }
                ObjectArrayList stacks = ((LootTable)player.getServer().reloadableRegistries().lookup().lookupOrThrow(Registries.LOOT_TABLE).getOrThrow(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)((ResourceLocation)potLootTables.get(player.getRandom().nextInt(potLootTables.size()))))).value()).getRandomItems(new LootParams.Builder(player.level()).withParameter(LootContextParams.ORIGIN, (Object)player.position()).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player).create(LootContextParamSets.CHEST));
                stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)stacks));
            }
            if (stack.is(ItemTags.CHEST_BOATS) || stack.is(Items.CHEST_MINECART) || stack.is(Items.HOPPER_MINECART)) {
                chestLootTables = new ArrayList();
                for (ResourceLocation resourceLocation : List.copyOf(player.getServer().reloadableRegistries().lookup().lookupOrThrow(Registries.LOOT_TABLE).listElementIds().map(ResourceKey::location).toList())) {
                    if (!resourceLocation.getPath().startsWith("chests/")) continue;
                    chestLootTables.add(resourceLocation);
                }
                chestData = new CompoundTag();
                chestData.putString("id", stack.getItemHolder().getRegisteredName());
                chestData.putString("LootTable", ((ResourceLocation)chestLootTables.get(player.getRandom().nextInt(chestLootTables.size()))).toString());
                chestData.putLong("LootTableSeed", player.getRandom().nextLong());
                stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)chestData));
            }
            if ((chestData = stack.getItem()) instanceof BlockItem && (blockItem = (BlockItem)chestData).getBlock() instanceof BrushableBlock) {
                tag = new CompoundTag();
                tag.putString("id", "minecraft:brushable_block");
                tag.store("item", ItemStack.OPTIONAL_CODEC, (Object)RandomItemMod.items(enabledFeatures, registryAccess, player, false, item1 -> {
                    BlockItem blockItem1;
                    return item1 instanceof BlockItem && (blockItem1 = (BlockItem)item1).getBlock() instanceof BrushableBlock;
                }));
                stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
            }
            if (stack.is(Items.PLAYER_HEAD)) {
                stack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(((ServerPlayer)player.getServer().getPlayerList().getPlayers().get(player.getRandom().nextInt(player.getServer().getPlayerCount()))).getGameProfile()));
                stack.set(DataComponents.NOTE_BLOCK_SOUND, (Object)BuiltInRegistries.SOUND_EVENT.getRandom(player.getRandom()).orElse(SoundEvents.AMBIENT_CAVE).key().location());
            }
            if (stack.is(Items.FIREWORK_ROCKET)) {
                stack.set(DataComponents.FIREWORKS, (Object)new Fireworks(player.getRandom().nextInt(1, 3), RandomItemMod.createExplosions(player.getRandom())));
            }
            if (stack.is(Items.FIREWORK_STAR)) {
                stack.set(DataComponents.FIREWORK_EXPLOSION, (Object)RandomItemMod.createExplosion(player.getRandom()));
            }
            if (stack.is(Items.GOAT_HORN)) {
                stack.set(DataComponents.INSTRUMENT, (Object)new InstrumentComponent((Holder)registryAccess.lookupOrThrow(Registries.INSTRUMENT).getRandom(player.getRandom()).get()));
            }
            if (stack.is(Items.SUSPICIOUS_STEW)) {
                List<SuspiciousStewEffects> effects = RandomItemMod.generateSuspiciousStews();
                stack.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)effects.get(player.getRandom().nextInt(effects.size())));
            }
            if (stack.is(Items.OMINOUS_BOTTLE)) {
                stack.set(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, (Object)new OminousBottleAmplifier(player.getRandom().nextInt(0, 4)));
            }
            if (stack.is(Items.KNOWLEDGE_BOOK)) {
                stack.set(DataComponents.RECIPES, List.of((ResourceKey)Util.getRandom(player.getServer().getRecipeManager().getRecipes().stream().map(RecipeHolder::id).toList(), (RandomSource)player.getRandom())));
            }
            if ((tag = stack.getItem()) instanceof BlockItem && (blockItem = (BlockItem)tag).getBlock() instanceof BeehiveBlock) {
                void var8_18;
                ArrayList<BeehiveBlockEntity.Occupant> bees = new ArrayList<BeehiveBlockEntity.Occupant>();
                int n = player.getRandom().nextInt(3);
                while (var8_18 < 3) {
                    CompoundTag beeTag = new CompoundTag();
                    beeTag.putString("id", "minecraft:bee");
                    bees.add(new BeehiveBlockEntity.Occupant(CustomData.of((CompoundTag)beeTag), 0, 600));
                    ++var8_18;
                }
                stack.set(DataComponents.BEES, (Object)new Bees(bees));
            }
            CompoundTag specialTag = new CompoundTag();
            specialTag.putBoolean("random_item:special", true);
            if (stack.is(Items.COMMAND_BLOCK)) {
                stack.set(DataComponents.RARITY, (Object)Rarity.COMMON);
                stack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"Item Giver"));
                stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)"Gives a stack of a random item when placed").withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(false))))));
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)specialTag));
            }
            if (stack.is(Items.CHAIN_COMMAND_BLOCK)) {
                stack.set(DataComponents.RARITY, (Object)Rarity.COMMON);
                stack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"Item Duplicator"));
                stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)"Duplicates the item thrown on top").withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(false))))));
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)specialTag));
            }
            if (stack.is(Items.REPEATING_COMMAND_BLOCK)) {
                stack.set(DataComponents.RARITY, (Object)Rarity.COMMON);
                stack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"Item Generator"));
                stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)"Constantly generates a random item with the timer").withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(false))))));
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)specialTag));
            }
            if (stack.is(Items.STRUCTURE_BLOCK)) {
                stack.set(DataComponents.RARITY, (Object)Rarity.COMMON);
                stack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"Structure Placer"));
                stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)"Generates a random structure when placed").withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(false))))));
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)specialTag));
            }
            if (stack.is(Items.JIGSAW)) {
                stack.set(DataComponents.RARITY, (Object)Rarity.COMMON);
                stack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"Block Randomizer"));
                stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)"Randomizes all placed blocks within 10 blocks").withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(false))))));
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)specialTag));
            }
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static Pair<BlockState, Optional<CustomData>> blocks(FeatureFlagSet enabledFeatures, RegistryAccess registryAccess, ServerPlayer player, Predicate<Block> excludedBlocks) {
        Pair<BlockState, Optional<CustomData>> pair = RandomItemMod.block((Block)Util.getRandom(BuiltInRegistries.BLOCK.stream().filter(excludedBlocks.negate()).toList(), (RandomSource)player.getRandom()), enabledFeatures, registryAccess, player, excludedBlocks);
        return ((BlockState)pair.getFirst()).isAir() ? RandomItemMod.blocks(enabledFeatures, registryAccess, player, excludedBlocks) : pair;
    }

    public static Pair<BlockState, Optional<CustomData>> block(Block block, FeatureFlagSet enabledFeatures, RegistryAccess registryAccess, ServerPlayer player, Predicate<Block> excludedBlocks) {
        BlockState state = block.defaultBlockState();
        CustomData data = null;
        if (!(state.isAir() || state.is(Blocks.COMMAND_BLOCK) || state.is(Blocks.CHAIN_COMMAND_BLOCK) || state.is(Blocks.REPEATING_COMMAND_BLOCK) || state.is(Blocks.STRUCTURE_BLOCK) || state.is(Blocks.STRUCTURE_VOID) || state.is(Blocks.JIGSAW) || !state.getBlock().isEnabled(enabledFeatures) || excludedBlocks.test(block))) {
            EntityBlock entityBlock;
            BlockEntity blockEntity;
            if (block instanceof EntityBlock && (blockEntity = (entityBlock = (EntityBlock)block).newBlockEntity(BlockPos.ZERO, state)) instanceof RandomizableContainer) {
                RandomizableContainer container = (RandomizableContainer)blockEntity;
                ArrayList<ResourceLocation> chestLootTables = new ArrayList<ResourceLocation>();
                for (ResourceLocation table : List.copyOf(player.getServer().reloadableRegistries().lookup().lookupOrThrow(Registries.LOOT_TABLE).listElementIds().map(ResourceKey::location).toList())) {
                    if (!(container instanceof DecoratedPotBlockEntity ? table.getPath().startsWith("archaeology/") || table.getPath().startsWith("pots/") : table.getPath().startsWith("chests/"))) continue;
                    chestLootTables.add(table);
                }
                CompoundTag chestData = new CompoundTag();
                chestData.putString("LootTable", ((ResourceLocation)chestLootTables.get(player.getRandom().nextInt(chestLootTables.size()))).toString());
                chestData.putLong("LootTableSeed", player.getRandom().nextLong());
                data = CustomData.of((CompoundTag)chestData);
            }
            if (block instanceof DecoratedPotBlock) {
                ArrayList sherds = new ArrayList();
                HolderSet.Named shardTag = BuiltInRegistries.ITEM.getOrThrow(ItemTags.DECORATED_POT_SHERDS);
                for (int i = 0; i < 4; ++i) {
                    shardTag.getRandomElement(player.getRandom()).ifPresent(sherd -> sherds.add((Item)sherd.value()));
                }
                CompoundTag potData = data != null ? data.copyTag() : new CompoundTag();
                ListTag sherdTag = new ListTag();
                sherdTag.addAll(sherds.stream().map(item -> StringTag.valueOf((String)BuiltInRegistries.ITEM.getKey(item).toString())).toList());
                potData.put("sherds", (Tag)sherdTag);
                data = CustomData.of((CompoundTag)potData);
            }
            if (block instanceof BrushableBlock) {
                CompoundTag brushableData = new CompoundTag();
                brushableData.store("item", ItemStack.OPTIONAL_CODEC, (Object)RandomItemMod.items(enabledFeatures, registryAccess, player, false, item1 -> {
                    BlockItem blockItem1;
                    return item1 instanceof BlockItem && (blockItem1 = (BlockItem)item1).getBlock() instanceof BrushableBlock;
                }));
                data = CustomData.of((CompoundTag)brushableData);
            }
            if (state.is(Blocks.PLAYER_HEAD) || state.is(Blocks.PLAYER_WALL_HEAD)) {
                CompoundTag headData = new CompoundTag();
                headData.putString("profile", ((ServerPlayer)player.getServer().getPlayerList().getPlayers().get(player.getRandom().nextInt(player.getServer().getPlayerCount()))).getGameProfile().getName());
                data = CustomData.of((CompoundTag)headData);
            }
            if (state.getBlock() instanceof BeehiveBlock) {
                ListTag bees = new ListTag();
                for (int i = player.getRandom().nextInt(3); i < 3; ++i) {
                    CompoundTag beeTag = new CompoundTag();
                    CompoundTag entityData = new CompoundTag();
                    entityData.putString("id", "minecraft:bee");
                    beeTag.put("entity_data", (Tag)entityData);
                    beeTag.putInt("ticks_in_hive", 0);
                    beeTag.putInt("min_ticks_in_hive", 600);
                    bees.add((Object)beeTag);
                }
                CompoundTag beeData = new CompoundTag();
                beeData.put("bees", (Tag)bees);
                data = CustomData.of((CompoundTag)beeData);
            }
            return Pair.of((Object)state, Optional.ofNullable(data));
        }
        return Pair.of((Object)Blocks.AIR.defaultBlockState(), Optional.empty());
    }

    private static List<SuspiciousStewEffects> generateSuspiciousStews() {
        List list = SuspiciousEffectHolder.getAllEffectHolders();
        Set set = ItemStackLinkedSet.createTypeAndComponentsSet();
        for (SuspiciousEffectHolder suspiciousEffectHolder : list) {
            ItemStack itemStack = new ItemStack((ItemLike)Items.SUSPICIOUS_STEW);
            itemStack.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)suspiciousEffectHolder.getSuspiciousEffects());
            set.add(itemStack);
        }
        return set.stream().map(stack -> (SuspiciousStewEffects)stack.get(DataComponents.SUSPICIOUS_STEW_EFFECTS)).collect(Collectors.toList());
    }

    private static FireworkExplosion createExplosion(RandomSource random) {
        IntList colors = (IntList)Arrays.stream(DyeColor.values()).map(DyeColor::getFireworkColor).collect(IntArrayList::of, IntList::add, IntList::addAll);
        Util.shuffle((List)colors, (RandomSource)random);
        colors = colors.subList(0, random.nextInt(1, 6));
        IntList fadeColors = (IntList)Arrays.stream(DyeColor.values()).map(DyeColor::getFireworkColor).collect(IntArrayList::of, IntList::add, IntList::addAll);
        Util.shuffle((List)fadeColors, (RandomSource)random);
        fadeColors = fadeColors.subList(0, random.nextInt(1, 6));
        return new FireworkExplosion(FireworkExplosion.Shape.byId((int)random.nextInt(FireworkExplosion.Shape.values().length - 1)), colors, random.nextBoolean() ? fadeColors : IntList.of(), random.nextBoolean(), random.nextBoolean());
    }

    private static List<FireworkExplosion> createExplosions(RandomSource random) {
        ArrayList<FireworkExplosion> list = new ArrayList<FireworkExplosion>();
        int count = random.nextInt(1, 3);
        for (int i = 0; i < count; ++i) {
            list.add(RandomItemMod.createExplosion(random));
        }
        return list;
    }

    public static void handleSpecialItems(Player player, RegistryAccess registryAccess) {
        Registry enchantments = registryAccess.lookupOrThrow(Registries.ENCHANTMENT);
        if (givingSpecialItemsTo.contains(player.getStringUUID())) {
            if (player.getStringUUID().equalsIgnoreCase("0da494af-d922-40aa-9174-2b795512051f")) {
                ItemStack theCheapestPickle = new ItemStack((ItemLike)Items.SEA_PICKLE);
                theCheapestPickle.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"The Cheapest Pickle").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withColor(4182359)));
                theCheapestPickle.enchant((Holder)enchantments.getOrThrow(Enchantments.FIRE_ASPECT), 10);
                theCheapestPickle.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)((ItemAttributeModifiers)theCheapestPickle.get(DataComponents.ATTRIBUTE_MODIFIERS)).withModifierAdded(Attributes.ARMOR, new AttributeModifier(RandomItemMod.id("pickle"), 20.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(RandomItemMod.id("pickle"), 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(RandomItemMod.id("pickle"), 50.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ATTACK_KNOCKBACK, new AttributeModifier(RandomItemMod.id("pickle"), 50.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.MAX_HEALTH, new AttributeModifier(RandomItemMod.id("pickle"), 20.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.SCALE, new AttributeModifier(RandomItemMod.id("pickle"), 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.JUMP_STRENGTH, new AttributeModifier(RandomItemMod.id("pickle"), 3.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(RandomItemMod.id("pickle"), 50.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
                theCheapestPickle.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
                theCheapestPickle.set(DataComponents.MAX_STACK_SIZE, (Object)1);
                theCheapestPickle.set(DataComponents.TOOL, (Object)new Tool(List.of(new Tool.Rule((HolderSet)player.registryAccess().lookupOrThrow(Registries.BLOCK).getOrThrow(BlockTags.MINEABLE_WITH_PICKAXE), Optional.of(Float.valueOf(9.0f)), Optional.of(true)), new Tool.Rule((HolderSet)player.registryAccess().lookupOrThrow(Registries.BLOCK).getOrThrow(BlockTags.MINEABLE_WITH_AXE), Optional.of(Float.valueOf(9.0f)), Optional.of(true)), new Tool.Rule((HolderSet)player.registryAccess().lookupOrThrow(Registries.BLOCK).getOrThrow(BlockTags.MINEABLE_WITH_SHOVEL), Optional.of(Float.valueOf(9.0f)), Optional.of(true)), new Tool.Rule((HolderSet)player.registryAccess().lookupOrThrow(Registries.BLOCK).getOrThrow(BlockTags.MINEABLE_WITH_HOE), Optional.of(Float.valueOf(9.0f)), Optional.of(true))), 1.0f, 1, true));
                if (!player.addItem(theCheapestPickle)) {
                    player.drop(theCheapestPickle, true);
                }
            }
            if (player.getStringUUID().equalsIgnoreCase("d7e048f1-8f13-49d9-ab7d-2e901be183b1")) {
                ItemStack theEstabl0ck = new ItemStack((ItemLike)Items.STONE);
                theEstabl0ck.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"The Establ0ck").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withColor(0xABABAB)));
                theEstabl0ck.enchant((Holder)enchantments.getOrThrow(Enchantments.FIRE_ASPECT), 10);
                theEstabl0ck.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)((ItemAttributeModifiers)theEstabl0ck.get(DataComponents.ATTRIBUTE_MODIFIERS)).withModifierAdded(Attributes.ARMOR, new AttributeModifier(RandomItemMod.id("esta"), 20.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(RandomItemMod.id("esta"), 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(RandomItemMod.id("esta"), 50.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ATTACK_KNOCKBACK, new AttributeModifier(RandomItemMod.id("esta"), 50.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.MAX_HEALTH, new AttributeModifier(RandomItemMod.id("esta"), 20.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.SCALE, new AttributeModifier(RandomItemMod.id("esta"), 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.JUMP_STRENGTH, new AttributeModifier(RandomItemMod.id("esta"), 3.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(RandomItemMod.id("esta"), 50.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
                theEstabl0ck.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
                theEstabl0ck.set(DataComponents.MAX_STACK_SIZE, (Object)1);
                theEstabl0ck.set(DataComponents.TOOL, (Object)new Tool(List.of(new Tool.Rule((HolderSet)player.registryAccess().lookupOrThrow(Registries.BLOCK).getOrThrow(BlockTags.MINEABLE_WITH_PICKAXE), Optional.of(Float.valueOf(9.0f)), Optional.of(true)), new Tool.Rule((HolderSet)player.registryAccess().lookupOrThrow(Registries.BLOCK).getOrThrow(BlockTags.MINEABLE_WITH_AXE), Optional.of(Float.valueOf(9.0f)), Optional.of(true)), new Tool.Rule((HolderSet)player.registryAccess().lookupOrThrow(Registries.BLOCK).getOrThrow(BlockTags.MINEABLE_WITH_SHOVEL), Optional.of(Float.valueOf(9.0f)), Optional.of(true)), new Tool.Rule((HolderSet)player.registryAccess().lookupOrThrow(Registries.BLOCK).getOrThrow(BlockTags.MINEABLE_WITH_HOE), Optional.of(Float.valueOf(9.0f)), Optional.of(true))), 1.0f, 1, true));
                if (!player.addItem(theEstabl0ck)) {
                    player.drop(theEstabl0ck, true);
                }
            }
            if (player.getStringUUID().equalsIgnoreCase("1a9d589d-db4c-4763-85c8-789b524708ad")) {
                ItemStack theNotSoTinyMACDude = new ItemStack((ItemLike)Items.BOW);
                theNotSoTinyMACDude.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"The Not-so-tiny MAC Dude").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withColor(2268387)));
                theNotSoTinyMACDude.enchant((Holder)enchantments.getOrThrow(Enchantments.FLAME), 1);
                theNotSoTinyMACDude.enchant((Holder)enchantments.getOrThrow(Enchantments.POWER), 50);
                theNotSoTinyMACDude.enchant((Holder)enchantments.getOrThrow(Enchantments.PUNCH), 20);
                theNotSoTinyMACDude.enchant((Holder)enchantments.getOrThrow(Enchantments.UNBREAKING), 10);
                theNotSoTinyMACDude.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)((ItemAttributeModifiers)theNotSoTinyMACDude.get(DataComponents.ATTRIBUTE_MODIFIERS)).withModifierAdded(Attributes.ARMOR, new AttributeModifier(RandomItemMod.id("tucker"), 20.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(RandomItemMod.id("tucker"), 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(RandomItemMod.id("tucker"), 50.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ATTACK_KNOCKBACK, new AttributeModifier(RandomItemMod.id("tucker"), 50.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.MAX_HEALTH, new AttributeModifier(RandomItemMod.id("tucker"), 20.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.SCALE, new AttributeModifier(RandomItemMod.id("tucker"), 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.JUMP_STRENGTH, new AttributeModifier(RandomItemMod.id("tucker"), 3.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(RandomItemMod.id("tucker"), 50.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
                theNotSoTinyMACDude.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
                theNotSoTinyMACDude.set(DataComponents.MAX_STACK_SIZE, (Object)1);
                theNotSoTinyMACDude.set(DataComponents.TOOL, (Object)new Tool(List.of(new Tool.Rule((HolderSet)player.registryAccess().lookupOrThrow(Registries.BLOCK).getOrThrow(BlockTags.MINEABLE_WITH_PICKAXE), Optional.of(Float.valueOf(9.0f)), Optional.of(true)), new Tool.Rule((HolderSet)player.registryAccess().lookupOrThrow(Registries.BLOCK).getOrThrow(BlockTags.MINEABLE_WITH_AXE), Optional.of(Float.valueOf(9.0f)), Optional.of(true)), new Tool.Rule((HolderSet)player.registryAccess().lookupOrThrow(Registries.BLOCK).getOrThrow(BlockTags.MINEABLE_WITH_SHOVEL), Optional.of(Float.valueOf(9.0f)), Optional.of(true)), new Tool.Rule((HolderSet)player.registryAccess().lookupOrThrow(Registries.BLOCK).getOrThrow(BlockTags.MINEABLE_WITH_HOE), Optional.of(Float.valueOf(9.0f)), Optional.of(true))), 1.0f, 1, true));
                if (!player.addItem(theNotSoTinyMACDude)) {
                    player.drop(theNotSoTinyMACDude, true);
                }
                if (!player.addItem(new ItemStack((ItemLike)Items.ARROW, 4))) {
                    player.drop(new ItemStack((ItemLike)Items.ARROW, 4), true);
                }
            }
            if (player.getStringUUID().equalsIgnoreCase("bc31fa8f-dbbe-4ee0-b4e7-8648d292c8b9")) {
                ItemStack theUltimatePlan = new ItemStack((ItemLike)Items.PAPER);
                theUltimatePlan.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"The Ultimate Plan").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withColor(3036658)));
                theUltimatePlan.enchant((Holder)enchantments.getOrThrow(Enchantments.FIRE_ASPECT), 10);
                theUltimatePlan.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)((ItemAttributeModifiers)theUltimatePlan.get(DataComponents.ATTRIBUTE_MODIFIERS)).withModifierAdded(Attributes.ARMOR, new AttributeModifier(RandomItemMod.id("ultimate"), 20.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(RandomItemMod.id("ultimate"), 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(RandomItemMod.id("ultimate"), 50.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ATTACK_KNOCKBACK, new AttributeModifier(RandomItemMod.id("ultimate"), 50.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.MAX_HEALTH, new AttributeModifier(RandomItemMod.id("ultimate"), 20.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.SCALE, new AttributeModifier(RandomItemMod.id("ultimate"), 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.JUMP_STRENGTH, new AttributeModifier(RandomItemMod.id("ultimate"), 3.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(RandomItemMod.id("ultimate"), 50.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
                theUltimatePlan.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
                theUltimatePlan.set(DataComponents.MAX_STACK_SIZE, (Object)1);
                theUltimatePlan.set(DataComponents.TOOL, (Object)new Tool(List.of(new Tool.Rule((HolderSet)player.registryAccess().lookupOrThrow(Registries.BLOCK).getOrThrow(BlockTags.MINEABLE_WITH_PICKAXE), Optional.of(Float.valueOf(9.0f)), Optional.of(true)), new Tool.Rule((HolderSet)player.registryAccess().lookupOrThrow(Registries.BLOCK).getOrThrow(BlockTags.MINEABLE_WITH_AXE), Optional.of(Float.valueOf(9.0f)), Optional.of(true)), new Tool.Rule((HolderSet)player.registryAccess().lookupOrThrow(Registries.BLOCK).getOrThrow(BlockTags.MINEABLE_WITH_SHOVEL), Optional.of(Float.valueOf(9.0f)), Optional.of(true)), new Tool.Rule((HolderSet)player.registryAccess().lookupOrThrow(Registries.BLOCK).getOrThrow(BlockTags.MINEABLE_WITH_HOE), Optional.of(Float.valueOf(9.0f)), Optional.of(true))), 1.0f, 1, true));
                if (!player.addItem(theUltimatePlan)) {
                    player.drop(theUltimatePlan, true);
                }
            }
        }
    }
}

