/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.randomitems.mixin;

import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StructureBlock.class})
public abstract class StructureBlockMixin {
    @Inject(at={@At(value="RETURN")}, method={"setPlacedBy"})
    private void specialty(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack, CallbackInfo ci) {
        StructureBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(blockPos);
        if (blockEntity2 instanceof StructureBlockEntity && ((CustomData)(blockEntity = (StructureBlockEntity)blockEntity2).components().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getBooleanOr("random_item:special", false) && livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            Structure structure = (Structure)Util.getRandom(player.registryAccess().lookupOrThrow(Registries.STRUCTURE).stream().toList(), (RandomSource)player.getRandom());
            ChunkGenerator chunkGenerator = player.level().getChunkSource().getGenerator();
            StructureStart structureStart = structure.generate(player.registryAccess().lookupOrThrow(Registries.STRUCTURE).wrapAsHolder((Object)structure), player.level().dimension(), player.registryAccess(), chunkGenerator, chunkGenerator.getBiomeSource(), player.level().getChunkSource().randomState(), player.level().getStructureManager(), player.level().getSeed(), new ChunkPos(blockPos), 0, (LevelHeightAccessor)player.level(), holder -> true);
            if (structureStart.isValid()) {
                BoundingBox boundingBox = structureStart.getBoundingBox();
                ChunkPos chunkPos = new ChunkPos(SectionPos.blockToSectionCoord((int)boundingBox.minX()), SectionPos.blockToSectionCoord((int)boundingBox.minZ()));
                ChunkPos chunkPos2 = new ChunkPos(SectionPos.blockToSectionCoord((int)boundingBox.maxX()), SectionPos.blockToSectionCoord((int)boundingBox.maxZ()));
                ChunkPos.rangeClosed((ChunkPos)chunkPos, (ChunkPos)chunkPos2).forEach(chunkPosx -> structureStart.placeInChunk((WorldGenLevel)player.level(), player.level().structureManager(), chunkGenerator, player.level().getRandom(), new BoundingBox(chunkPosx.getMinBlockX(), player.level().getMinY(), chunkPosx.getMinBlockZ(), chunkPosx.getMaxBlockX(), player.level().getMaxY() + 1, chunkPosx.getMaxBlockZ()), chunkPosx));
            }
            level.destroyBlock(blockPos, false, (Entity)livingEntity);
        }
    }
}

