/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.randomitems;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.PlayerHeadBlock;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.tintankgames.randomitems.Config;

@Mod(value="random_item")
public class RandomItemMod {
    public static final String MOD_ID = "random_item";
    public static final ServerBossEvent PROGRESS_BAR = new ServerBossEvent((Component)Component.m_237113_((String)"Random Item Timer").m_130940_(ChatFormatting.YELLOW), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    public static int timer = 0;
    public static List<String> givingSpecialItemsTo = new ArrayList<String>();
    public static List<String> hasSpecialItem = List.of("0da494af-d922-40aa-9174-2b795512051f", "d7e048f1-8f13-49d9-ab7d-2e901be183b1", "1a9d589d-db4c-4763-85c8-789b524708ad", "bc31fa8f-dbbe-4ee0-b4e7-8648d292c8b9");

    public RandomItemMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    public static ItemStack items(FeatureFlagSet enabledFeatures, RegistryAccess registryAccess, ServerPlayer player, boolean allowSpecialItems, Predicate<Item> excludedItems) {
        if (Config.getSpecialItemChance() > 0 && allowSpecialItems && player.m_217043_().m_188503_(Config.getSpecialItemChance()) == 0 && hasSpecialItem.contains(player.m_20149_().toLowerCase())) {
            givingSpecialItemsTo.add(player.m_20149_());
            return ItemStack.f_41583_;
        }
        ItemStack stack = RandomItemMod.item((Item)Util.m_214621_(BuiltInRegistries.f_257033_.m_123024_().filter(excludedItems.negate()).toList(), (RandomSource)player.m_217043_()), enabledFeatures, registryAccess, player, excludedItems);
        return stack.m_41619_() ? RandomItemMod.items(enabledFeatures, registryAccess, player, allowSpecialItems, excludedItems) : stack;
    }

    public static ItemStack item(Item item, FeatureFlagSet enabledFeatures, RegistryAccess registryAccess, ServerPlayer player, Predicate<Item> excludedItems) {
        ItemStack stack = new ItemStack((ItemLike)item);
        if (!(stack.m_150930_(Items.f_41852_) || stack.m_150930_(Items.f_42751_) || stack.m_150930_(Items.f_42657_) || stack.m_150930_(Items.f_42263_) || !stack.m_246617_(enabledFeatures) || excludedItems.test(item))) {
            ListTag lore;
            Item playerCount22;
            Object shards;
            Item entityBlock;
            BlockItem blockItem;
            Object table22;
            ArrayList<Object> chestLootTables;
            if (item instanceof PotionItem || item instanceof TippedArrowItem) {
                Optional potion = BuiltInRegistries.f_256980_.m_213642_(player.m_217043_());
                if (potion.isPresent()) {
                    PotionUtils.m_43549_((ItemStack)stack, (Potion)((Potion)((Holder.Reference)potion.get()).m_203334_()));
                } else {
                    PotionUtils.m_43549_((ItemStack)stack, (Potion)Potions.f_43599_);
                }
            }
            if (stack.m_150930_(Items.f_42690_)) {
                EnchantmentHelper.m_220292_((RandomSource)player.m_217043_(), (ItemStack)stack, (int)5, (boolean)true);
            }
            if (stack.m_150930_(Items.f_42517_) && player.m_217043_().m_188503_(10) == 0) {
                EnchantmentHelper.m_220292_((RandomSource)player.m_217043_(), (ItemStack)stack, (int)5, (boolean)true);
            }
            if (stack.m_204117_(ItemTags.f_265942_) && player.m_217043_().m_188503_(32) == 0) {
                HolderSet.Named materials = BuiltInRegistries.f_257033_.m_203561_(ItemTags.f_265843_);
                HolderSet.Named templates = BuiltInRegistries.f_257033_.m_203561_(ItemTags.f_265940_);
                Optional optional = TrimMaterials.m_266539_((RegistryAccess)registryAccess, (ItemStack)((Item)((Holder)materials.m_213653_(player.m_217043_()).get()).m_203334_()).m_7968_());
                Optional optional2 = TrimPatterns.m_266468_((RegistryAccess)registryAccess, (ItemStack)((Item)((Holder)templates.m_213653_(player.m_217043_()).get()).m_203334_()).m_7968_());
                if (optional.isPresent() && optional2.isPresent()) {
                    ArmorTrim armorTrim = new ArmorTrim((Holder)optional.get(), (Holder)optional2.get());
                    ArmorTrim.m_266570_((RegistryAccess)registryAccess, (ItemStack)stack, (ArmorTrim)armorTrim);
                }
            }
            if (item instanceof BundleItem) {
                chestLootTables = new ArrayList<Object>();
                for (Object table22 : List.copyOf(player.f_8924_.m_278653_().m_278706_(LootDataType.f_278413_))) {
                    if (!table22.m_135815_().startsWith("chests/")) continue;
                    chestLootTables.add(table22);
                }
                ObjectArrayList stacks = player.f_8924_.m_278653_().m_278676_((ResourceLocation)chestLootTables.get(player.m_217043_().m_188503_(chestLootTables.size()))).m_287195_(new LootParams.Builder(player.m_284548_()).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287289_(LootContextParams.f_81455_, (Object)player).m_287235_(LootContextParamSets.f_81411_));
                table22 = stacks.iterator();
                while (table22.hasNext()) {
                    ItemStack tableStack = (ItemStack)table22.next();
                    RandomItemMod.add(stack, tableStack);
                }
            }
            if ((table22 = stack.m_41720_()) instanceof BlockItem && (table22 = (blockItem = (BlockItem)table22).m_40614_()) instanceof EntityBlock && (entityBlock = (EntityBlock)table22).m_142194_(BlockPos.f_121853_, blockItem.m_40614_().m_49966_()) instanceof RandomizableContainerBlockEntity) {
                ArrayList<ResourceLocation> chestLootTables2 = new ArrayList<ResourceLocation>();
                for (ResourceLocation table3 : List.copyOf(player.f_8924_.m_278653_().m_278706_(LootDataType.f_278413_))) {
                    if (!table3.m_135815_().startsWith("chests/")) continue;
                    chestLootTables2.add(table3);
                }
                stack.m_41698_("BlockEntityTag").m_128359_("LootTable", ((ResourceLocation)chestLootTables2.get(player.m_217043_().m_188503_(chestLootTables2.size()))).toString());
            }
            if ((entityBlock = stack.m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)entityBlock).m_40614_() instanceof DecoratedPotBlock) {
                shards = new ListTag();
                HolderSet.Named shardTag = BuiltInRegistries.f_257033_.m_203561_(ItemTags.f_271220_);
                for (int i = 0; i < 4; ++i) {
                    shards.add((Object)StringTag.m_129297_((String)((ResourceKey)((Holder)shardTag.m_213653_(player.m_217043_()).get()).m_203543_().get()).m_135782_().toString()));
                }
                stack.m_41698_("BlockEntityTag").m_128365_("sherds", (Tag)shards);
            }
            if (stack.m_204117_(ItemTags.f_215864_) || stack.m_150930_(Items.f_42519_) || stack.m_150930_(Items.f_42694_)) {
                chestLootTables = new ArrayList();
                shards = List.copyOf(player.f_8924_.m_278653_().m_278706_(LootDataType.f_278413_)).iterator();
                while (shards.hasNext()) {
                    ResourceLocation table = (ResourceLocation)shards.next();
                    if (!table.m_135815_().startsWith("chests/")) continue;
                    chestLootTables.add(table);
                }
                stack.m_41698_("EntityTag").m_128359_("LootTable", ((ResourceLocation)chestLootTables.get(player.m_217043_().m_188503_(chestLootTables.size()))).toString());
            }
            if ((shards = stack.m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)shards).m_40614_() instanceof BrushableBlock) {
                stack.m_41698_("BlockEntityTag").m_128365_("item", (Tag)RandomItemMod.items(enabledFeatures, registryAccess, player, false, item1 -> {
                    BlockItem blockItem1;
                    return item1 instanceof BlockItem && (blockItem1 = (BlockItem)item1).m_40614_() instanceof BrushableBlock;
                }).m_41739_(new CompoundTag()));
            }
            if ((shards = stack.m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)shards).m_40614_() instanceof PlayerHeadBlock) {
                int playerCount22 = player.m_217043_().m_188503_(player.f_8924_.m_7641_().length);
                stack.m_41784_().m_128359_("SkullOwner", player.f_8924_.m_7641_()[playerCount22]);
                stack.m_41784_().m_128359_("note_block_sound", BuiltInRegistries.f_256894_.m_213642_(player.m_217043_()).orElse(SoundEvents.f_11689_).m_205785_().m_135782_().toString());
            }
            if (stack.m_150930_(Items.f_42688_)) {
                CompoundTag fireworkTag = new CompoundTag();
                fireworkTag.m_128365_("Explosions", (Tag)RandomItemMod.createExplosions(player.m_217043_()));
                fireworkTag.m_128405_("Flight", player.m_217043_().m_216339_(1, 3));
                stack.m_41784_().m_128365_("Fireworks", (Tag)fireworkTag);
            }
            if (stack.m_150930_(Items.f_42689_)) {
                stack.m_41784_().m_128365_("Explosion", (Tag)RandomItemMod.createExplosion(player.m_217043_()));
            }
            if (stack.m_150930_(Items.f_220219_)) {
                stack.m_41784_().m_128359_("instrument", ((Holder.Reference)BuiltInRegistries.f_256896_.m_213642_(player.m_217043_()).get()).m_205785_().m_135782_().toString());
            }
            if (stack.m_150930_(Items.f_42718_)) {
                List<ListTag> effects = RandomItemMod.generateSuspiciousStews();
                stack.m_41784_().m_128365_("effects", (Tag)effects.get(player.m_217043_().m_188503_(effects.size())));
            }
            if (stack.m_150930_(Items.f_42750_)) {
                ListTag list = new ListTag();
                list.add((Object)StringTag.m_129297_((String)((ResourceLocation)Util.m_214621_(player.f_8924_.m_129894_().m_44051_().stream().map(Recipe::m_6423_).toList(), (RandomSource)player.m_217043_())).toString()));
                stack.m_41784_().m_128365_("Recipes", (Tag)list);
            }
            if ((playerCount22 = stack.m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)playerCount22).m_40614_() instanceof BeehiveBlock) {
                ListTag bees = new ListTag();
                for (int i = player.m_217043_().m_188503_(3); i < 3; ++i) {
                    CompoundTag beeTag = new CompoundTag();
                    CompoundTag entityData = new CompoundTag();
                    entityData.m_128359_("id", "minecraft:bee");
                    beeTag.m_128365_("EntityData", (Tag)entityData);
                    beeTag.m_128405_("TicksInHive", 0);
                    beeTag.m_128405_("MinOccupationTicks", 600);
                    bees.add((Object)beeTag);
                }
                stack.m_41698_("BlockEntityTag").m_128365_("Bees", (Tag)bees);
            }
            if (stack.m_150930_(Items.f_42116_)) {
                stack.m_41698_("display").m_128359_("Name", Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Item Giver").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE).m_131155_(Boolean.valueOf(false)))));
                lore = new ListTag();
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Gives a stack of a random item when placed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(false))))));
                stack.m_41698_("display").m_128365_("Lore", (Tag)lore);
                stack.m_41784_().m_128379_("special", true);
            }
            if (stack.m_150930_(Items.f_42257_)) {
                stack.m_41698_("display").m_128359_("Name", Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Item Duplicator").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE).m_131155_(Boolean.valueOf(false)))));
                lore = new ListTag();
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Duplicates the item thrown on top").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(false))))));
                stack.m_41698_("display").m_128365_("Lore", (Tag)lore);
                stack.m_41784_().m_128379_("special", true);
            }
            if (stack.m_150930_(Items.f_42256_)) {
                stack.m_41698_("display").m_128359_("Name", Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Item Generator").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE).m_131155_(Boolean.valueOf(false)))));
                lore = new ListTag();
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Constantly generates a random item with the timer").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(false))))));
                stack.m_41698_("display").m_128365_("Lore", (Tag)lore);
                stack.m_41784_().m_128379_("special", true);
            }
            if (stack.m_150930_(Items.f_42352_)) {
                stack.m_41698_("display").m_128359_("Name", Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Structure Placer").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE).m_131155_(Boolean.valueOf(false)))));
                lore = new ListTag();
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Generates a random structure when placed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(false))))));
                stack.m_41698_("display").m_128365_("Lore", (Tag)lore);
                stack.m_41784_().m_128379_("special", true);
            }
            if (stack.m_150930_(Items.f_42353_)) {
                stack.m_41698_("display").m_128359_("Name", Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Block Randomizer").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE).m_131155_(Boolean.valueOf(false)))));
                lore = new ListTag();
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Randomizes all placed blocks within 10 blocks").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(false))))));
                stack.m_41698_("display").m_128365_("Lore", (Tag)lore);
                stack.m_41784_().m_128379_("special", true);
            }
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static Pair<BlockState, Optional<CompoundTag>> blocks(FeatureFlagSet enabledFeatures, RegistryAccess registryAccess, ServerPlayer player, Predicate<Block> excludedBlocks) {
        Pair<BlockState, Optional<CompoundTag>> pair = RandomItemMod.block((Block)Util.m_214621_(BuiltInRegistries.f_256975_.m_123024_().filter(excludedBlocks.negate()).toList(), (RandomSource)player.m_217043_()), enabledFeatures, registryAccess, player, excludedBlocks);
        return ((BlockState)pair.getFirst()).m_60795_() ? RandomItemMod.blocks(enabledFeatures, registryAccess, player, excludedBlocks) : pair;
    }

    public static Pair<BlockState, Optional<CompoundTag>> block(Block block, FeatureFlagSet enabledFeatures, RegistryAccess registryAccess, ServerPlayer player, Predicate<Block> excludedBlocks) {
        BlockState state = block.m_49966_();
        CompoundTag data = null;
        if (!(state.m_60795_() || state.m_60713_(Blocks.f_50272_) || state.m_60713_(Blocks.f_50448_) || state.m_60713_(Blocks.f_50447_) || state.m_60713_(Blocks.f_50677_) || state.m_60713_(Blocks.f_50454_) || state.m_60713_(Blocks.f_50678_) || !state.m_60734_().m_245993_(enabledFeatures) || excludedBlocks.test(block))) {
            EntityBlock entityBlock;
            if (block instanceof EntityBlock && (entityBlock = (EntityBlock)block).m_142194_(BlockPos.f_121853_, state) instanceof RandomizableContainerBlockEntity) {
                ArrayList<ResourceLocation> chestLootTables = new ArrayList<ResourceLocation>();
                for (ResourceLocation table : List.copyOf(player.f_8924_.m_278653_().m_278706_(LootDataType.f_278413_))) {
                    if (!table.m_135815_().startsWith("chests/")) continue;
                    chestLootTables.add(table);
                }
                CompoundTag chestData = new CompoundTag();
                chestData.m_128359_("LootTable", ((ResourceLocation)chestLootTables.get(player.m_217043_().m_188503_(chestLootTables.size()))).toString());
                chestData.m_128356_("LootTableSeed", player.m_217043_().m_188505_());
                data = chestData;
            }
            if (block instanceof DecoratedPotBlock) {
                ArrayList sherds = new ArrayList();
                HolderSet.Named shardTag = BuiltInRegistries.f_257033_.m_203561_(ItemTags.f_271220_);
                for (int i = 0; i < 4; ++i) {
                    shardTag.m_213653_(player.m_217043_()).ifPresent(sherd -> sherds.add((Item)sherd.m_203334_()));
                }
                CompoundTag potData = data != null ? data.m_6426_() : new CompoundTag();
                ListTag sherdTag = new ListTag();
                sherdTag.addAll(sherds.stream().map(item -> StringTag.m_129297_((String)BuiltInRegistries.f_257033_.m_7981_(item).toString())).toList());
                potData.m_128365_("sherds", (Tag)sherdTag);
                data = potData;
            }
            if (block instanceof BrushableBlock) {
                CompoundTag brushableData = new CompoundTag();
                brushableData.m_128365_("item", (Tag)RandomItemMod.items(enabledFeatures, registryAccess, player, false, item1 -> {
                    BlockItem blockItem1;
                    return item1 instanceof BlockItem && (blockItem1 = (BlockItem)item1).m_40614_() instanceof BrushableBlock;
                }).m_41739_(new CompoundTag()));
                data = brushableData;
            }
            if (state.m_60713_(Blocks.f_50316_) || state.m_60713_(Blocks.f_50317_)) {
                CompoundTag headData = new CompoundTag();
                int playerCount = player.m_217043_().m_188503_(player.f_8924_.m_7641_().length);
                headData.m_128359_("SkullOwner", player.f_8924_.m_7641_()[playerCount]);
                data = headData;
            }
            if (state.m_60734_() instanceof BeehiveBlock) {
                ListTag bees = new ListTag();
                for (int i = player.m_217043_().m_188503_(3); i < 3; ++i) {
                    CompoundTag beeTag = new CompoundTag();
                    CompoundTag entityData = new CompoundTag();
                    entityData.m_128359_("id", "minecraft:bee");
                    beeTag.m_128365_("EntityData", (Tag)entityData);
                    beeTag.m_128405_("TicksInHive", 0);
                    beeTag.m_128405_("MinOccupationTicks", 600);
                    bees.add((Object)beeTag);
                }
                CompoundTag beeData = new CompoundTag();
                beeData.m_128365_("Bees", (Tag)bees);
                data = beeData;
            }
            return Pair.of((Object)state, Optional.ofNullable(data));
        }
        return Pair.of((Object)Blocks.f_50016_.m_49966_(), Optional.empty());
    }

    private static List<ListTag> generateSuspiciousStews() {
        List list = SuspiciousEffectHolder.m_257904_();
        ArrayList<ListTag> effects = new ArrayList<ListTag>();
        for (SuspiciousEffectHolder suspiciousEffectHolder : list) {
            ListTag listTag = new ListTag();
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("EffectId", BuiltInRegistries.f_256974_.m_7981_((Object)suspiciousEffectHolder.m_53521_()).toString());
            tag.m_128405_("EffectDuration", suspiciousEffectHolder.m_53522_());
            listTag.add((Object)tag);
            effects.add(listTag);
        }
        return effects;
    }

    private static CompoundTag createExplosion(RandomSource random) {
        CompoundTag explosion = new CompoundTag();
        IntList colors = (IntList)Arrays.stream(DyeColor.values()).map(DyeColor::m_41070_).collect(IntArrayList::of, IntList::add, IntList::addAll);
        RandomItemMod.shuffle(colors, random);
        colors = colors.subList(0, random.m_216339_(1, 6));
        IntList fadeColors = (IntList)Arrays.stream(DyeColor.values()).map(DyeColor::m_41070_).collect(IntArrayList::of, IntList::add, IntList::addAll);
        RandomItemMod.shuffle(fadeColors, random);
        fadeColors = fadeColors.subList(0, random.m_216339_(1, 6));
        explosion.m_128385_("Colors", colors.toIntArray());
        if (random.m_188499_()) {
            explosion.m_128385_("FadeColors", fadeColors.toIntArray());
        }
        explosion.m_128379_("Flicker", random.m_188499_());
        explosion.m_128379_("Trail", random.m_188499_());
        explosion.m_128344_("Type", (byte)random.m_188503_(5));
        return explosion;
    }

    public static <T> void shuffle(List<T> list, RandomSource randomSource) {
        int i;
        for (int j = i = list.size(); j > 1; --j) {
            int k = randomSource.m_188503_(j);
            list.set(j - 1, list.set(k, list.get(j - 1)));
        }
    }

    private static ListTag createExplosions(RandomSource random) {
        ListTag list = new ListTag();
        int count = random.m_216339_(1, 3);
        for (int i = 0; i < count; ++i) {
            list.add((Object)RandomItemMod.createExplosion(random));
        }
        return list;
    }

    public static void handleSpecialItems(Player player) {
        if (givingSpecialItemsTo.contains(player.m_20149_())) {
            if (player.m_20149_().equalsIgnoreCase("0da494af-d922-40aa-9174-2b795512051f")) {
                ItemStack theCheapestPickle = new ItemStack((ItemLike)Items.f_41868_);
                theCheapestPickle.m_41714_((Component)Component.m_237113_((String)"The Cheapest Pickle").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(false)).m_178520_(4182359)));
                theCheapestPickle.m_41663_(Enchantments.f_44981_, 10);
                theCheapestPickle.m_41643_(Attributes.f_22284_, new AttributeModifier(UUID.fromString("10d6d451-3031-4083-be6c-92f4a5cfdc5e"), "Pickle Armor Up", 20.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                theCheapestPickle.m_41643_(Attributes.f_22285_, new AttributeModifier(UUID.fromString("77b158a0-a1c9-4aab-83af-ddeb97683066"), "Pickle Armor Toughness Up", 3.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                theCheapestPickle.m_41643_(Attributes.f_22281_, new AttributeModifier(UUID.fromString("ab39522f-4d2f-462b-a9cf-7db3d8341803"), "Pickle Attack Up", 50.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                theCheapestPickle.m_41643_(Attributes.f_22282_, new AttributeModifier(UUID.fromString("02fdc33f-c51d-4243-98e1-1c8ad56fabdb"), "Pickle Knockback Up", 50.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                theCheapestPickle.m_41643_(Attributes.f_22276_, new AttributeModifier(UUID.fromString("531e529f-1794-4a95-9d8e-9d0fd6db3baa"), "Pickle HP Up", 20.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                if (!player.m_36356_(theCheapestPickle)) {
                    player.m_36176_(theCheapestPickle, true);
                }
            }
            if (player.m_20149_().equalsIgnoreCase("d7e048f1-8f13-49d9-ab7d-2e901be183b1")) {
                ItemStack theEstabl0ck = new ItemStack((ItemLike)Items.f_41905_);
                theEstabl0ck.m_41714_((Component)Component.m_237113_((String)"The Establ0ck").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(false)).m_178520_(0xABABAB)));
                theEstabl0ck.m_41663_(Enchantments.f_44981_, 10);
                theEstabl0ck.m_41643_(Attributes.f_22284_, new AttributeModifier(UUID.fromString("10d6d451-3031-4083-be6c-92f4a5cfdc5e"), "Esta Armor Up", 20.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                theEstabl0ck.m_41643_(Attributes.f_22285_, new AttributeModifier(UUID.fromString("77b158a0-a1c9-4aab-83af-ddeb97683066"), "Esta Armor Toughness Up", 3.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                theEstabl0ck.m_41643_(Attributes.f_22281_, new AttributeModifier(UUID.fromString("ab39522f-4d2f-462b-a9cf-7db3d8341803"), "Esta Attack Up", 50.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                theEstabl0ck.m_41643_(Attributes.f_22282_, new AttributeModifier(UUID.fromString("02fdc33f-c51d-4243-98e1-1c8ad56fabdb"), "Esta Knockback Up", 50.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                theEstabl0ck.m_41643_(Attributes.f_22276_, new AttributeModifier(UUID.fromString("531e529f-1794-4a95-9d8e-9d0fd6db3baa"), "Esta HP Up", 20.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                if (!player.m_36356_(theEstabl0ck)) {
                    player.m_36176_(theEstabl0ck, true);
                }
            }
            if (player.m_20149_().equalsIgnoreCase("1a9d589d-db4c-4763-85c8-789b524708ad")) {
                ItemStack theNotSoTinyMACDude = new ItemStack((ItemLike)Items.f_42411_);
                theNotSoTinyMACDude.m_41714_((Component)Component.m_237113_((String)"The Not-so-tiny MAC Dude").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(false)).m_178520_(2268387)));
                theNotSoTinyMACDude.m_41663_(Enchantments.f_44990_, 1);
                theNotSoTinyMACDude.m_41663_(Enchantments.f_44988_, 50);
                theNotSoTinyMACDude.m_41663_(Enchantments.f_44989_, 20);
                theNotSoTinyMACDude.m_41663_(Enchantments.f_44986_, 10);
                theNotSoTinyMACDude.m_41643_(Attributes.f_22284_, new AttributeModifier(UUID.fromString("10d6d451-3031-4083-be6c-92f4a5cfdc5e"), "Tucker Armor Up", 20.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                theNotSoTinyMACDude.m_41643_(Attributes.f_22285_, new AttributeModifier(UUID.fromString("77b158a0-a1c9-4aab-83af-ddeb97683066"), "Tucker Armor Toughness Up", 3.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                theNotSoTinyMACDude.m_41643_(Attributes.f_22281_, new AttributeModifier(UUID.fromString("ab39522f-4d2f-462b-a9cf-7db3d8341803"), "Tucker Attack Up", 50.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                theNotSoTinyMACDude.m_41643_(Attributes.f_22282_, new AttributeModifier(UUID.fromString("02fdc33f-c51d-4243-98e1-1c8ad56fabdb"), "Tucker Knockback Up", 50.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                theNotSoTinyMACDude.m_41643_(Attributes.f_22276_, new AttributeModifier(UUID.fromString("531e529f-1794-4a95-9d8e-9d0fd6db3baa"), "Tucker HP Up", 20.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                if (!player.m_36356_(theNotSoTinyMACDude)) {
                    player.m_36176_(theNotSoTinyMACDude, true);
                }
                if (!player.m_36356_(new ItemStack((ItemLike)Items.f_42412_, 4))) {
                    player.m_36176_(new ItemStack((ItemLike)Items.f_42412_, 4), true);
                }
            }
            if (player.m_20149_().equalsIgnoreCase("bc31fa8f-dbbe-4ee0-b4e7-8648d292c8b9")) {
                ItemStack theUltimatePlan = new ItemStack((ItemLike)Items.f_42516_);
                theUltimatePlan.m_41714_((Component)Component.m_237113_((String)"The Ultimate Plan").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(false)).m_178520_(3036658)));
                theUltimatePlan.m_41663_(Enchantments.f_44981_, 10);
                theUltimatePlan.m_41643_(Attributes.f_22284_, new AttributeModifier(UUID.fromString("10d6d451-3031-4083-be6c-92f4a5cfdc5e"), "Ultimate Armor Up", 20.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                theUltimatePlan.m_41643_(Attributes.f_22285_, new AttributeModifier(UUID.fromString("77b158a0-a1c9-4aab-83af-ddeb97683066"), "Ultimate Armor Toughness Up", 3.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                theUltimatePlan.m_41643_(Attributes.f_22281_, new AttributeModifier(UUID.fromString("ab39522f-4d2f-462b-a9cf-7db3d8341803"), "Ultimate Attack Up", 50.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                theUltimatePlan.m_41643_(Attributes.f_22282_, new AttributeModifier(UUID.fromString("02fdc33f-c51d-4243-98e1-1c8ad56fabdb"), "Ultimate Knockback Up", 50.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                theUltimatePlan.m_41643_(Attributes.f_22276_, new AttributeModifier(UUID.fromString("531e529f-1794-4a95-9d8e-9d0fd6db3baa"), "Ultimate HP Up", 20.0, AttributeModifier.Operation.ADDITION), EquipmentSlot.MAINHAND);
                if (!player.m_36356_(theUltimatePlan)) {
                    player.m_36176_(theUltimatePlan, true);
                }
            }
        }
    }

    private static int add(ItemStack itemStack, ItemStack itemStack2) {
        if (!itemStack2.m_41619_() && itemStack2.m_41720_().m_142095_()) {
            CompoundTag compoundTag = itemStack.m_41784_();
            if (!compoundTag.m_128441_("Items")) {
                compoundTag.m_128365_("Items", (Tag)new ListTag());
            }
            int i = RandomItemMod.getContentWeight(itemStack);
            int j = RandomItemMod.getWeight(itemStack2);
            int k = Math.min(itemStack2.m_41613_(), (64 - i) / j);
            if (k == 0) {
                return 0;
            }
            ListTag listTag = compoundTag.m_128437_("Items", 10);
            Optional<CompoundTag> optional = RandomItemMod.getMatchingItem(itemStack2, listTag);
            if (optional.isPresent()) {
                CompoundTag compoundTag2 = optional.get();
                ItemStack itemStack3 = ItemStack.m_41712_((CompoundTag)compoundTag2);
                itemStack3.m_41769_(k);
                itemStack3.m_41739_(compoundTag2);
                listTag.remove((Object)compoundTag2);
                listTag.add(0, (Tag)compoundTag2);
            } else {
                ItemStack itemStack4 = itemStack2.m_255036_(k);
                CompoundTag compoundTag3 = new CompoundTag();
                itemStack4.m_41739_(compoundTag3);
                listTag.add(0, (Tag)compoundTag3);
            }
            return k;
        }
        return 0;
    }

    private static Optional<CompoundTag> getMatchingItem(ItemStack itemStack, ListTag listTag) {
        if (itemStack.m_150930_(Items.f_151058_)) {
            return Optional.empty();
        }
        Stream<Tag> var10000 = listTag.stream();
        Objects.requireNonNull(CompoundTag.class);
        var10000 = var10000.filter(CompoundTag.class::isInstance);
        Objects.requireNonNull(CompoundTag.class);
        return var10000.map(CompoundTag.class::cast).filter(compoundTag -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)compoundTag), (ItemStack)itemStack)).findFirst();
    }

    private static int getWeight(ItemStack itemStack) {
        CompoundTag compoundTag;
        if (itemStack.m_150930_(Items.f_151058_)) {
            return 4 + RandomItemMod.getContentWeight(itemStack);
        }
        if ((itemStack.m_150930_(Items.f_42786_) || itemStack.m_150930_(Items.f_42785_)) && itemStack.m_41782_() && (compoundTag = BlockItem.m_186336_((ItemStack)itemStack)) != null && !compoundTag.m_128437_("Bees", 10).isEmpty()) {
            return 64;
        }
        return 64 / itemStack.m_41741_();
    }

    private static int getContentWeight(ItemStack itemStack) {
        return RandomItemMod.getContents(itemStack).mapToInt(itemStackx -> RandomItemMod.getWeight(itemStackx) * itemStackx.m_41613_()).sum();
    }

    private static Stream<ItemStack> getContents(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag == null) {
            return Stream.empty();
        }
        ListTag listTag = compoundTag.m_128437_("Items", 10);
        Stream var10000 = listTag.stream();
        Objects.requireNonNull(CompoundTag.class);
        return var10000.map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }
}

