/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.randomitems.mixin;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.tintankgames.randomitems.RandomItemMod;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Block.class})
public abstract class BlockMixin {
    @Inject(at={@At(value="RETURN")}, method={"setPlacedBy"})
    private void jigsawSpecialty(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack, CallbackInfo ci) {
        JigsawBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(blockPos);
        if (blockEntity2 instanceof JigsawBlockEntity && ((CustomData)(blockEntity = (JigsawBlockEntity)blockEntity2).components().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getBoolean("random_item:special") && livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            for (int x = -10; x < 11; ++x) {
                for (int y = -10; y < 11; ++y) {
                    for (int z = -10; z < 11; ++z) {
                        BlockEntity blockEntity3;
                        BlockPos pos = blockPos.relative(Direction.Axis.X, x).relative(Direction.Axis.Y, y).relative(Direction.Axis.Z, z);
                        BlockState state = level.getBlockState(pos);
                        if (state.isAir() || state.is(Blocks.COMMAND_BLOCK) || state.is(Blocks.CHAIN_COMMAND_BLOCK) || state.is(Blocks.REPEATING_COMMAND_BLOCK) || state.is(Blocks.STRUCTURE_BLOCK) || state.is(Blocks.JIGSAW)) continue;
                        Pair<BlockState, Optional<CustomData>> pair = RandomItemMod.blocks(level.enabledFeatures(), level.registryAccess(), player, block -> false);
                        level.setBlock(pos, (BlockState)pair.getFirst(), 2);
                        if (!((Optional)pair.getSecond()).isPresent() || !((blockEntity3 = level.getBlockEntity(pos)) instanceof BlockEntity)) continue;
                        BlockEntity entity = blockEntity3;
                        entity.loadCustomOnly(((CustomData)((Optional)pair.getSecond()).get()).copyTag(), (HolderLookup.Provider)level.registryAccess());
                    }
                }
            }
            level.destroyBlock(blockPos, false, (Entity)livingEntity);
        }
    }
}

