/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.randomitems.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tintankgames.randomitems.RandomItemMod;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CommandBlock.class})
public abstract class CommandBlockMixin {
    @Inject(at={@At(value="RETURN")}, method={"setPlacedBy"})
    private void specialty(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack, CallbackInfo ci) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof CommandBlockEntity) {
            CommandBlockEntity blockEntity2 = (CommandBlockEntity)blockEntity;
            if (blockState.is(Blocks.COMMAND_BLOCK) && ((CustomData)blockEntity2.components().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getBoolean("random_item:special") && livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                ItemStack stack = RandomItemMod.items(level.enabledFeatures(), level.registryAccess(), player, false, item -> item == Items.COMMAND_BLOCK || item == Items.CHAIN_COMMAND_BLOCK || item == Items.REPEATING_COMMAND_BLOCK || item == Items.STRUCTURE_BLOCK || item == Items.JIGSAW);
                stack.setCount(stack.getMaxStackSize());
                Vec3 center = blockPos.getCenter().subtract(0.0, 0.5, 0.0);
                ItemEntity newItem = new ItemEntity(level, center.x(), center.y(), center.z(), stack);
                level.addFreshEntity((Entity)newItem);
                level.destroyBlock(blockPos, false, (Entity)livingEntity);
            }
        }
    }
}

