/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.randomitems.mixin;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.tintankgames.randomitems.Config;
import net.tintankgames.randomitems.RandomItemMod;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Commands.class})
public abstract class CommandManagerMixin {
    @Shadow
    @Final
    private CommandDispatcher<CommandSourceStack> dispatcher;

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/brigadier/CommandDispatcher;setConsumer(Lcom/mojang/brigadier/ResultConsumer;)V")}, method={"<init>"})
    private void randomItems_addCommands(Commands.CommandSelection commandSelection, CommandBuildContext commandBuildContext, CallbackInfo ci) {
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"timer").then(Commands.literal((String)"time").then(Commands.argument((String)"time", (ArgumentType)TimeArgument.time((int)100)).executes(context -> {
            Config.setMaxTime(IntegerArgumentType.getInteger((CommandContext)context, (String)"time"));
            return Config.getMaxTime();
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"barcolor").then(Commands.literal((String)"pink").executes(context -> CommandManagerMixin.barColor(BossEvent.BossBarColor.PINK)))).then(Commands.literal((String)"blue").executes(context -> CommandManagerMixin.barColor(BossEvent.BossBarColor.BLUE)))).then(Commands.literal((String)"red").executes(context -> CommandManagerMixin.barColor(BossEvent.BossBarColor.RED)))).then(Commands.literal((String)"green").executes(context -> CommandManagerMixin.barColor(BossEvent.BossBarColor.GREEN)))).then(Commands.literal((String)"yellow").executes(context -> CommandManagerMixin.barColor(BossEvent.BossBarColor.YELLOW)))).then(Commands.literal((String)"purple").executes(context -> CommandManagerMixin.barColor(BossEvent.BossBarColor.PURPLE)))).then(Commands.literal((String)"white").executes(context -> CommandManagerMixin.barColor(BossEvent.BossBarColor.WHITE))))).then(((LiteralArgumentBuilder)Commands.literal((String)"namecolor").then(Commands.literal((String)"name").then(Commands.argument((String)"value", (ArgumentType)ColorArgument.color()).executes(context -> CommandManagerMixin.nameColor(ColorArgument.getColor((CommandContext)context, (String)"value")))))).then(Commands.literal((String)"rgb").then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.word()).executes(context -> CommandManagerMixin.nameColor(Integer.parseInt(StringArgumentType.getString((CommandContext)context, (String)"value"), 16)))))));
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"randomitem").requires(source -> source.hasPermission(2) || source.isPlayer() && RandomItemMod.hasSpecialItem.contains(source.getPlayer().getStringUUID()))).executes(context -> {
            ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers().forEach(player -> {
                ItemStack item = RandomItemMod.items(((CommandSourceStack)context.getSource()).enabledFeatures(), ((CommandSourceStack)context.getSource()).registryAccess(), player, true, item1 -> false);
                RandomItemMod.handleSpecialItems((Player)player, (RegistryAccess)((CommandSourceStack)context.getSource()).getServer().registryAccess());
                if (!RandomItemMod.givingSpecialItemsTo.contains(player.getStringUUID()) && !player.addItem(item)) {
                    player.drop(item, true);
                }
            });
            return 1;
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).requires(source -> source.hasPermission(2))).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
            players.forEach(player -> {
                ItemStack item = RandomItemMod.items(((CommandSourceStack)context.getSource()).enabledFeatures(), ((CommandSourceStack)context.getSource()).registryAccess(), player, true, item1 -> false);
                RandomItemMod.handleSpecialItems((Player)player, (RegistryAccess)((CommandSourceStack)context.getSource()).getServer().registryAccess());
                if (!RandomItemMod.givingSpecialItemsTo.contains(player.getStringUUID()) && !player.addItem(item)) {
                    player.drop(item, true);
                }
            });
            return 1;
        })).then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)commandBuildContext)).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
            players.forEach(player -> {
                player.addItem(RandomItemMod.item(ItemArgument.getItem((CommandContext)context, (String)"item").getItem(), ((CommandSourceStack)context.getSource()).enabledFeatures(), ((CommandSourceStack)context.getSource()).registryAccess(), player, item -> false));
                RandomItemMod.handleSpecialItems((Player)player, (RegistryAccess)((CommandSourceStack)context.getSource()).getServer().registryAccess());
            });
            RandomItemMod.givingSpecialItemsTo.clear();
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"special").requires(source -> source.isPlayer() && RandomItemMod.hasSpecialItem.contains(source.getPlayer().getStringUUID()))).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
            players.forEach(player -> {
                if (RandomItemMod.hasSpecialItem.contains(player.getStringUUID())) {
                    RandomItemMod.givingSpecialItemsTo.add(player.getStringUUID());
                    RandomItemMod.handleSpecialItems((Player)player, (RegistryAccess)((CommandSourceStack)context.getSource()).getServer().registryAccess());
                    RandomItemMod.givingSpecialItemsTo.remove(player.getStringUUID());
                }
            });
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"special_item_chance").requires(source -> source.isPlayer() && RandomItemMod.hasSpecialItem.contains(source.getPlayer().getStringUUID()))).then(Commands.argument((String)"chance", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Config.setSpecialItemChance(IntegerArgumentType.getInteger((CommandContext)context, (String)"chance"));
            return Config.getSpecialItemChance();
        }))));
    }

    @Unique
    private static int barColor(BossEvent.BossBarColor color) {
        Config.setBarColor(color);
        return Config.getBarColor().ordinal();
    }

    @Unique
    private static int nameColor(ChatFormatting color) {
        Config.setNameColor(color);
        return Config.getNameColor();
    }

    @Unique
    private static int nameColor(int color) {
        Config.setNameColor(color);
        return Config.getNameColor();
    }
}

