/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.randomitems.mixin;

import java.util.Iterator;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tintankgames.randomitems.Config;
import net.tintankgames.randomitems.RandomItemMod;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityBlock.class})
public interface EntityBlockMixin {
    @Inject(at={@At(value="RETURN")}, method={"getTicker"}, cancellable=true)
    private <T extends BlockEntity> void specialHandler(Level level, BlockState blockState, BlockEntityType<T> blockEntityType, CallbackInfoReturnable<BlockEntityTicker<T>> cir) {
        if (blockState.is(Blocks.CHAIN_COMMAND_BLOCK)) {
            cir.setReturnValue(EntityBlockMixin.createTickerHelper(blockEntityType, BlockEntityType.COMMAND_BLOCK, (level1, blockPos, blockState1, blockEntity) -> {
                Iterator iterator;
                if (((CustomData)blockEntity.components().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getBoolean("random_item:special") && (iterator = level1.getEntitiesOfClass(ItemEntity.class, new AABB(blockPos.above())).iterator()).hasNext()) {
                    ItemEntity item = (ItemEntity)iterator.next();
                    for (int count = item.getItem().getCount() * 16; count > 0; count -= Math.min(item.getItem().getMaxStackSize(), count)) {
                        ItemStack stack = item.getItem().copyWithCount(Math.min(item.getItem().getMaxStackSize(), count));
                        ItemEntity newItem = new ItemEntity(level1, item.getX(), item.getY(), item.getZ(), stack);
                        level.addFreshEntity((Entity)newItem);
                    }
                    item.discard();
                    level1.destroyBlock(blockPos, false, item.getOwner());
                    return;
                }
            }));
        } else if (blockState.is(Blocks.REPEATING_COMMAND_BLOCK)) {
            cir.setReturnValue(EntityBlockMixin.createTickerHelper(blockEntityType, BlockEntityType.COMMAND_BLOCK, (level1, blockPos, blockState1, blockEntity) -> {
                if (level1 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level1;
                    if (((CustomData)blockEntity.components().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getBoolean("random_item:special") && RandomItemMod.timer >= Config.getMaxTime()) {
                        ItemStack stack = RandomItemMod.items(level1.enabledFeatures(), level1.registryAccess(), (ServerPlayer)serverLevel.getNearestPlayer((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), -1.0, false), false, item1 -> false);
                        Vec3 center = blockPos.above().getCenter().subtract(0.0, 0.5, 0.0);
                        ItemEntity newItem = new ItemEntity(level1, center.x(), center.y(), center.z(), stack);
                        level.addFreshEntity((Entity)newItem);
                    }
                }
            }));
        }
    }

    @Unique
    @Nullable
    private static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> blockEntityType, BlockEntityType<E> blockEntityType2, BlockEntityTicker<? super E> blockEntityTicker) {
        return blockEntityType2 == blockEntityType ? blockEntityTicker : null;
    }
}

