/*
 * Decompiled with CFR 0.152.
 */
package flanox.fr.oreStats;

import flanox.fr.oreStats.OreStats;
import flanox.fr.oreStats.PlayerStats;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class BlockBreakListener
implements Listener {
    private final Map<UUID, PlayerStats> stats = new HashMap<UUID, PlayerStats>();
    private final Map<UUID, Set<Location>> placedBlocks = new HashMap<UUID, Set<Location>>();
    private final File statsFile = new File(OreStats.getInstance().getDataFolder(), "stats.dat");

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Material type = event.getBlockPlaced().getType();
        if (this.isTrackedOre(type)) {
            this.placedBlocks.computeIfAbsent(event.getPlayer().getUniqueId(), k -> new HashSet()).add(event.getBlockPlaced().getLocation());
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        Set playerPlaced = this.placedBlocks.getOrDefault(playerId, Collections.emptySet());
        if (playerPlaced.contains(event.getBlock().getLocation())) {
            playerPlaced.remove(event.getBlock().getLocation());
            return;
        }
        PlayerStats playerStats = this.stats.computeIfAbsent(playerId, k -> new PlayerStats());
        playerStats.addBlock(event.getBlock().getType());
    }

    private boolean isTrackedOre(Material type) {
        return type == Material.DIAMOND_ORE || type == Material.GOLD_ORE || type == Material.IRON_ORE || type == Material.ANCIENT_DEBRIS || type == Material.NETHER_QUARTZ_ORE;
    }

    public PlayerStats getStats(UUID uuid) {
        return this.stats.getOrDefault(uuid, new PlayerStats());
    }

    public Map<UUID, PlayerStats> getAllStats() {
        return this.stats;
    }

    public void saveStats() {
        try {
            if (!OreStats.getInstance().getDataFolder().exists()) {
                OreStats.getInstance().getDataFolder().mkdirs();
            }
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.statsFile));){
                oos.writeObject(this.stats);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadStats() {
        if (!this.statsFile.exists()) {
            return;
        }
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.statsFile));){
            Object obj = ois.readObject();
            if (obj instanceof Map) {
                Map loaded = (Map)obj;
                for (Map.Entry entry : loaded.entrySet()) {
                    Object object = entry.getKey();
                    if (!(object instanceof UUID)) continue;
                    UUID uuid = (UUID)object;
                    object = entry.getValue();
                    if (!(object instanceof PlayerStats)) continue;
                    PlayerStats ps = (PlayerStats)object;
                    this.stats.put(uuid, ps);
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

