/*
 * Decompiled with CFR 0.152.
 */
package flanox.fr.oreStats;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;

public class PlayerStats
implements Serializable {
    private final Map<Material, Integer> minedBlocks = new HashMap<Material, Integer>();

    public void addBlock(Material m) {
        this.minedBlocks.put(m, this.minedBlocks.getOrDefault(m, 0) + 1);
    }

    public int getMined(Material m) {
        return this.minedBlocks.getOrDefault(m, 0);
    }

    public int getTotalBlocks(Iterable<Material> materials) {
        int total = 0;
        for (Material m : materials) {
            total += this.getMined(m);
        }
        return total;
    }

    public double getRatio(Material ore, Iterable<Material> totalMaterials) {
        int minedOre = this.getMined(ore);
        int total = this.getTotalBlocks(totalMaterials);
        return total == 0 ? 0.0 : (double)minedOre / (double)total * 100.0;
    }

    public Map<Material, Integer> getAllMined() {
        return this.minedBlocks;
    }
}

