/*
 * Decompiled with CFR 0.152.
 */
package flanox.fr.oreStats;

import flanox.fr.oreStats.BlockBreakListener;
import flanox.fr.oreStats.PlayerStats;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class RatioCommand
implements CommandExecutor,
TabCompleter {
    private final BlockBreakListener listener;
    private static final Map<String, Material> ORE_MAP = Map.of("diamond", Material.DIAMOND_ORE, "gold", Material.GOLD_ORE, "iron", Material.IRON_ORE, "netherite", Material.ANCIENT_DEBRIS, "quartz", Material.NETHER_QUARTZ_ORE);
    private static final Map<String, List<Material>> BASE_BLOCKS = Map.of("diamond", List.of(Material.STONE, Material.DEEPSLATE, Material.TUFF, Material.ANDESITE, Material.CALCITE), "gold", List.of(Material.STONE, Material.DEEPSLATE), "iron", List.of(Material.STONE, Material.DEEPSLATE), "netherite", List.of(Material.NETHERRACK), "quartz", List.of(Material.NETHERRACK));

    public RatioCommand(BlockBreakListener listener) {
        this.listener = listener;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String oreName;
        if (!sender.hasPermission("orestats.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage("\u00a7cUsage: /Orestats <player|top> [ore]");
            return true;
        }
        String firstArg = args[0].toLowerCase();
        String string = oreName = args.length >= 2 ? args[1].toLowerCase() : "diamond";
        if (!ORE_MAP.containsKey(oreName)) {
            sender.sendMessage("\u00a7cUnknown ore: " + oreName);
            return true;
        }
        Material ore = ORE_MAP.get(oreName);
        List<Material> baseBlocks = BASE_BLOCKS.get(oreName);
        if (firstArg.equals("top")) {
            ArrayList<Map.Entry<UUID, PlayerStats>> entries = new ArrayList<Map.Entry<UUID, PlayerStats>>(this.listener.getAllStats().entrySet());
            entries.sort((a, b) -> Double.compare(((PlayerStats)b.getValue()).getRatio(ore, baseBlocks), ((PlayerStats)a.getValue()).getRatio(ore, baseBlocks)));
            sender.sendMessage("\u00a76Top 5 players for " + oreName + ":");
            for (int i = 0; i < Math.min(5, entries.size()); ++i) {
                PlayerStats stats = (PlayerStats)((Map.Entry)entries.get(i)).getValue();
                UUID uuid = (UUID)((Map.Entry)entries.get(i)).getKey();
                String name = sender.getServer().getOfflinePlayer(uuid).getName();
                sender.sendMessage("\u00a7b" + (i + 1) + ". " + name + ": \u00a7f" + String.format("%.2f", stats.getRatio(ore, baseBlocks)) + "%");
            }
        } else {
            Player target = sender.getServer().getPlayer(firstArg);
            if (target == null) {
                sender.sendMessage("\u00a7cPlayer not found.");
                return true;
            }
            PlayerStats stats = this.listener.getStats(target.getUniqueId());
            sender.sendMessage("\u00a76OreStats for " + target.getName() + " (" + oreName + "):");
            sender.sendMessage("\u00a7bMined " + oreName + ": \u00a7f" + stats.getMined(ore));
            sender.sendMessage("\u00a7bBase blocks mined: \u00a7f" + stats.getTotalBlocks(baseBlocks));
            sender.sendMessage("\u00a7bRatio: \u00a7f" + String.format("%.2f", stats.getRatio(ore, baseBlocks)) + "%");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("top");
            for (Player p : sender.getServer().getOnlinePlayers()) {
                completions.add(p.getName());
            }
        } else if (args.length == 2) {
            completions.addAll(ORE_MAP.keySet());
        }
        return completions;
    }
}

