/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.petiteinventory.init;

import com.sighs.petiteinventory.init.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import net.minecraft.world.inventory.Slot;

public class ContainerGrid {
    private Set<Cell> cells = new HashSet<Cell>();

    public static ContainerGrid of(Set<Cell> cells) {
        ContainerGrid grid = new ContainerGrid();
        grid.cells.addAll(cells);
        return grid;
    }

    public static ContainerGrid parse(Collection<Slot> ... slotsList) {
        int lineStart = 0;
        ContainerGrid grid = new ContainerGrid();
        HashSet<Cell> result = new HashSet<Cell>();
        for (Collection<Slot> slots : slotsList) {
            if (slots.isEmpty()) continue;
            int yOffset = lineStart;
            for (Cell cell : ContainerGrid.parse(slots).getCells()) {
                lineStart = Math.max(lineStart, cell.y);
                result.add(new Cell(cell.y + yOffset, cell.x, cell.slot));
            }
            ++lineStart;
        }
        grid.cells.addAll(result);
        return grid;
    }

    public static ContainerGrid parse(Collection<Slot> slots) {
        int i;
        ContainerGrid grid = new ContainerGrid();
        if (slots == null || slots.isEmpty()) {
            return grid;
        }
        TreeSet<Integer> xCoords = new TreeSet<Integer>();
        TreeSet<Integer> yCoords = new TreeSet<Integer>();
        for (Slot slot : slots) {
            xCoords.add(slot.f_40220_);
            yCoords.add(slot.f_40221_);
        }
        ArrayList sortedX = new ArrayList(xCoords);
        ArrayList sortedY = new ArrayList(yCoords);
        HashMap<Integer, Integer> xToColumn = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> yToRow = new HashMap<Integer, Integer>();
        for (i = 0; i < sortedX.size(); ++i) {
            xToColumn.put((Integer)sortedX.get(i), i);
        }
        for (i = 0; i < sortedY.size(); ++i) {
            yToRow.put((Integer)sortedY.get(i), i);
        }
        for (Slot slot : slots) {
            Integer column = (Integer)xToColumn.get(slot.f_40220_);
            Integer row = (Integer)yToRow.get(slot.f_40221_);
            if (column == null || row == null) continue;
            grid.cells.add(new Cell(row, column, slot));
        }
        return grid;
    }

    public int getWidth() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (Cell cell : this.cells) {
            set.add(cell.x);
        }
        return set.size();
    }

    public int getHeight() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (Cell cell : this.cells) {
            set.add(cell.y);
        }
        return set.size();
    }

    public Set<Cell> getCells() {
        return this.cells;
    }

    public Set<Cell> getCells(Predicate<Cell> predicate) {
        HashSet<Cell> result = new HashSet<Cell>();
        for (Cell cell : this.cells) {
            if (!predicate.test(cell)) continue;
            result.add(cell);
        }
        return result;
    }

    public Set<Cell> getCells(Cell cell, Area area) {
        int[] xRange = new int[]{cell.x, cell.x + area.width() - 1};
        int[] yRange = new int[]{cell.y, cell.y + area.height() - 1};
        return this.getCells(c -> c.inRangeX(xRange) && c.inRangeY(yRange));
    }

    public Cell getCell(int x, int y) {
        for (Cell cell : this.cells) {
            if (cell.x != x || cell.y != y) continue;
            return cell;
        }
        return null;
    }

    public Cell getCell(Slot slot) {
        for (Cell cell : this.cells) {
            if (!cell.slot.equals(slot)) continue;
            return cell;
        }
        return null;
    }

    public boolean isEmpty(Cell cell, Area area) {
        boolean result = true;
        for (Cell c : this.getCells(cell, area)) {
            if (c.isEmpty()) continue;
            result = false;
        }
        return result;
    }

    public boolean isEmpty(int x, int y) {
        Cell cell = this.getCell(x, y);
        return cell != null && cell.isEmpty();
    }

    public boolean isEmpty(int[] p1, int[] p2) {
        int[] rangeX = new int[]{Math.min(p1[0], p2[0]), Math.max(p1[0], p2[0])};
        int[] rangeY = new int[]{Math.min(p1[1], p2[1]), Math.max(p1[1], p2[1])};
        boolean result = true;
        block0: for (int x = rangeX[0]; x <= rangeX[1]; ++x) {
            for (int y = rangeY[0]; y <= rangeY[1]; ++y) {
                if (this.isEmpty(x, y)) continue;
                result = false;
                continue block0;
            }
        }
        return result;
    }

    public Map<Cell, Cell> getCellMap() {
        HashMap<Cell, Cell> result = new HashMap<Cell, Cell>();
        for (Cell cell : this.cells) {
            if (cell.isEmpty()) continue;
            Area area = Area.of(cell.slot.m_7993_());
            for (int x = 0; x < area.width(); ++x) {
                for (int y = 0; y < area.height(); ++y) {
                    result.put(this.getCell(cell.x + x, cell.y + y), cell);
                }
            }
        }
        return result;
    }

    public Cell findArea(Area area) {
        ArrayList<Cell> sortedCells = new ArrayList<Cell>(this.cells);
        sortedCells.sort(Comparator.comparingInt(cell -> cell.slot.f_40219_));
        int size = area.width() * area.height();
        Map<Cell, Cell> cellMap = this.getCellMap();
        for (Cell cell2 : sortedCells) {
            Set<Cell> cells = this.getCells(cell2, area);
            if (size > cells.size()) continue;
            boolean valid = true;
            for (Cell c : cells) {
                if (c.isEmpty() && !cellMap.containsKey(c) && c.slot.f_40218_.equals(cell2.slot.f_40218_)) continue;
                valid = false;
            }
            if (!valid) continue;
            return cell2;
        }
        return null;
    }

    public void removeRow(int row) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (Cell cell : this.cells) {
            if (cell.y == row) continue;
            slots.add(cell.slot);
        }
        this.cells = ContainerGrid.parse(slots).cells;
    }

    public void removeColumn(int column) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (Cell cell : this.cells) {
            if (cell.x == column) continue;
            slots.add(cell.slot);
        }
        this.cells = ContainerGrid.parse(slots).cells;
    }

    public record Cell(int y, int x, Slot slot) {
        public boolean isEmpty() {
            return !this.slot().m_6657_();
        }

        private boolean inRangeX(int[] range) {
            if (range.length != 2) {
                return false;
            }
            return this.x >= range[0] && this.x <= range[1];
        }

        private boolean inRangeY(int[] range) {
            if (range.length != 2) {
                return false;
            }
            return this.y >= range[0] && this.y <= range[1];
        }

        @Override
        public String toString() {
            return "(" + this.x + "," + this.y + ")[" + this.slot.m_7993_() + "]";
        }

        @Override
        public boolean equals(Object object) {
            return this.toString().equals(object.toString());
        }
    }
}

