/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.petiteinventory.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sighs.petiteinventory.init.Area;
import com.sighs.petiteinventory.init.ContainerGrid;
import com.sighs.petiteinventory.utils.ClientUtils;
import com.sighs.petiteinventory.utils.GuiUtils;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin
extends Screen {
    @Shadow
    @Nullable
    public Slot f_97734_;
    @Shadow
    private ItemStack f_97711_;
    @Shadow
    protected int f_97735_;
    @Shadow
    protected int f_97736_;
    @Unique
    private Slot needReplaceSlot = null;
    @Unique
    private boolean firstClicked = true;

    @Shadow
    public abstract boolean m_6375_(double var1, double var3, int var5);

    @Shadow
    @Nullable
    protected abstract Slot m_97744_(double var1, double var3);

    @Shadow
    public abstract boolean m_6348_(double var1, double var3, int var5);

    protected AbstractContainerScreenMixin(Component p_96550_) {
        super(p_96550_);
    }

    @Inject(method={"renderSlot"}, at={@At(value="HEAD")})
    private void onRender(GuiGraphics guiGraphics, Slot slot, CallbackInfo ci) {
        if (!ClientUtils.isClientGridSlot(slot)) {
            return;
        }
        if (!slot.m_6657_()) {
            return;
        }
        Area area = Area.of(slot.m_7993_());
        int x = slot.f_40220_;
        int y = slot.f_40221_;
        int w = 18 * area.width();
        int h = 18 * area.height();
        GuiUtils.drawNinePatch(guiGraphics, GuiUtils.AREA, x - 1, y - 1, w, h, 18, 1);
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void highlight(GuiGraphics guiGraphics, int p_283661_, int p_281248_, float p_281886_, CallbackInfo ci) {
        ItemStack cursorItem = this.getCursorItem();
        if (ClientUtils.isClientGridSlot(this.f_97734_) && !cursorItem.m_41619_()) {
            Area area = Area.of(cursorItem);
            ContainerGrid grid = ClientUtils.getContainerGrid();
            ContainerGrid.Cell hoverCell = grid.getCell(this.f_97734_);
            for (ContainerGrid.Cell cell : grid.getCells(hoverCell, area)) {
                if (!cell.slot().f_40218_.equals(hoverCell.slot().f_40218_)) continue;
                AbstractContainerScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(cell.slot().f_40220_ + this.f_97735_), (int)(cell.slot().f_40221_ + this.f_97736_), (int)0, (int)-2130706433);
            }
        }
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderSlotHighlight(Lnet/minecraft/client/gui/GuiGraphics;IIII)V"), remap=false)
    private void ond(GuiGraphics guiGraphics, int x, int y, int p_283504_, int color) {
        int w = 16;
        int h = 16;
        ItemStack cursorItem = this.getCursorItem();
        if (!ClientUtils.isClientGridSlot(this.f_97734_) || cursorItem.m_41619_()) {
            ItemStack hoverItem;
            if (!(this instanceof CreativeModeInventoryScreen)) {
                this.f_97734_ = ClientUtils.getMappedSlot(this.f_97734_);
            }
            if (!(hoverItem = this.f_97734_.m_7993_()).m_41619_() && ClientUtils.isClientGridSlot(this.f_97734_)) {
                Area area = Area.of(hoverItem);
                w += 18 * (area.width() - 1);
                h += 18 * (area.height() - 1);
            }
            x = this.f_97734_.f_40220_;
            y = this.f_97734_.f_40221_;
            guiGraphics.m_285978_(RenderType.m_286086_(), x, y, x + w, y + h, color, color, p_283504_);
        }
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")}, cancellable=true)
    private void onReleased(double mouseX, double mouseY, int p_97750_, CallbackInfoReturnable<Boolean> cir) {
        if (this.firstClicked) {
            cir.cancel();
            this.firstClicked = false;
        }
        ItemStack cursorItem = this.getCursorItem();
        Slot slot = this.m_97744_(mouseX, mouseY);
        if (cursorItem != null && ClientUtils.isClientGridSlot(slot) && this.needReplaceSlot == null) {
            ContainerGrid grid = ClientUtils.getContainerGrid();
            if (grid.getCell(slot) == null) {
                return;
            }
            Map<ContainerGrid.Cell, ContainerGrid.Cell> cellMap = grid.getCellMap();
            ContainerGrid.Cell clickedCell = grid.getCell(slot);
            Area targetArea = Area.of(this.getCursorItem());
            HashSet<ContainerGrid.Cell> targetAreaCells = new HashSet<ContainerGrid.Cell>();
            for (ContainerGrid.Cell cell : grid.getCells(clickedCell, targetArea)) {
                if (!cell.slot().f_40218_.equals(clickedCell.slot().f_40218_)) continue;
                targetAreaCells.add(cell);
            }
            if (targetAreaCells.size() == targetArea.width() * targetArea.height()) {
                HashSet<ContainerGrid.Cell> AreaCells = new HashSet<ContainerGrid.Cell>();
                for (ContainerGrid.Cell c : targetAreaCells) {
                    ContainerGrid.Cell mapped = cellMap.get(c);
                    if (mapped == null) continue;
                    AreaCells.add(mapped);
                }
                if (AreaCells.isEmpty()) {
                    return;
                }
                if (AreaCells.size() == 1) {
                    this.needReplaceSlot = AreaCells.toArray(new ContainerGrid.Cell[0])[0].slot();
                } else {
                    cir.setReturnValue((Object)true);
                }
            } else {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"mouseReleased"}, at={@At(value="RETURN")})
    private void qq(double mouseX, double mouseY, int p_97814_, CallbackInfoReturnable<Boolean> cir) {
        Slot slot = this.m_97744_(mouseX, mouseY);
        if (this.needReplaceSlot != null && ClientUtils.isClientGridSlot(slot)) {
            int offsetX = this.needReplaceSlot.f_40220_ - slot.f_40220_;
            int offsetY = this.needReplaceSlot.f_40221_ - slot.f_40221_;
            this.needReplaceSlot = null;
            this.m_6375_(mouseX + (double)offsetX, mouseY + (double)offsetY, p_97814_);
        }
    }

    @Inject(method={"mouseDragged"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancel(double p_97752_, double p_97753_, int p_97754_, double p_97755_, double p_97756_, CallbackInfoReturnable<Boolean> cir) {
        Slot slot = this.m_97744_(p_97752_, p_97753_);
        if (ClientUtils.isClientGridSlot(slot)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"renderSlot"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V")})
    private void scale(GuiGraphics guiGraphics, Slot slot, CallbackInfo ci) {
        if (!ClientUtils.isClientGridSlot(slot)) {
            return;
        }
        this.scale(guiGraphics, Area.of(slot.m_7993_()), slot.f_40220_, slot.f_40221_);
    }

    @Inject(method={"renderFloatingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;renderItem(Lnet/minecraft/world/item/ItemStack;II)V")})
    private void scale(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y, String p_282568_, CallbackInfo ci) {
        if (!ClientUtils.isClientGridSlot(this.f_97734_)) {
            return;
        }
        this.scale(guiGraphics, Area.of(itemStack), x, y);
    }

    private void scale(GuiGraphics guiGraphics, Area area, int x, int y) {
        int w = area.width();
        int h = area.height();
        float minSize = area.minSize();
        float offsetX = 9.0f * ((float)w - minSize);
        float offsetY = 9.0f * ((float)h - minSize);
        float scale = minSize > 1.0f ? minSize * 0.8f : minSize;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_252880_((float)x, (float)y, 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        poseStack.m_252880_((float)(-x), (float)(-y), 0.0f);
        if (minSize > 1.0f) {
            poseStack.m_85837_((double)offsetX * 0.8, (double)offsetY * 0.8, 0.0);
            float offset = 1.6f * minSize;
            poseStack.m_85837_((double)offset * 0.8, (double)offset * 0.8, 0.0);
        } else {
            poseStack.m_252880_(offsetX, offsetY, 0.0f);
        }
    }

    private ItemStack getCursorItem() {
        AbstractContainerMenu menu = Minecraft.m_91087_().f_91074_.f_36096_;
        return this.f_97711_.m_41619_() ? menu.m_142621_() : this.f_97711_;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void doTick(CallbackInfo ci) {
        ItemStack cursorItem = this.getCursorItem();
        long windowHandle = Minecraft.m_91087_().m_91268_().m_85439_();
        if (!cursorItem.m_41619_() && Area.of(cursorItem).maxSize() > 1 && ClientUtils.isClientGridSlot(this.f_97734_)) {
            GLFW.glfwSetInputMode((long)windowHandle, (int)208897, (int)212994);
        } else {
            GLFW.glfwSetInputMode((long)windowHandle, (int)208897, (int)212993);
        }
    }

    @Inject(method={"checkHotbarKeyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancel(int p_97806_, int p_97807_, CallbackInfoReturnable<Boolean> cir) {
        cir.cancel();
    }
}

