/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.petiteinventory.utils;

import com.sighs.petiteinventory.compat.KubeJSCompat;
import com.sighs.petiteinventory.init.Area;
import com.sighs.petiteinventory.init.AreaEvent;
import com.sighs.petiteinventory.loader.EntryCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class ItemUtils {
    private static final TagKey<Item> TOOLS_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools"));
    private static final TagKey<Item> SWORDS_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "swords"));

    public static boolean isToolOrWeapon(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_204117_(ItemTags.f_271540_)) {
            return true;
        }
        if (stack.m_204117_(ItemTags.f_271388_)) {
            return true;
        }
        if (stack.m_204117_(TOOLS_TAG)) {
            return true;
        }
        return stack.m_204117_(SWORDS_TAG);
    }

    public static String getItemRegistryName(Item item) {
        if (item == null) {
            return null;
        }
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)item);
        if (registryName == null) {
            return null;
        }
        return registryName.toString();
    }

    public static Item getItemById(String registryName) {
        if (registryName == null || registryName.isEmpty()) {
            return null;
        }
        try {
            ResourceLocation resourceLocation = new ResourceLocation(registryName);
            if (!ForgeRegistries.ITEMS.containsKey(resourceLocation)) {
                return null;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            return item;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Collection<Item> getItemsOfTag(ResourceLocation tagId) {
        TagKey tagKey = ForgeRegistries.ITEMS.tags().createTagKey(tagId);
        ITagManager tagManager = ForgeRegistries.ITEMS.tags();
        HashSet<Item> result = new HashSet<Item>();
        if (tagManager != null && tagManager.isKnownTagName(tagKey)) {
            tagManager.getTag(tagKey).forEach(result::add);
        }
        return result;
    }

    public static boolean isTagExists(ResourceLocation tagId) {
        TagKey tagKey = ForgeRegistries.ITEMS.tags().createTagKey(tagId);
        ITagManager tagManager = ForgeRegistries.ITEMS.tags();
        return tagManager != null && tagManager.isKnownTagName(tagKey);
    }

    public static List<Item> resolveItemList(List<String> identifiers) {
        ArrayList<Item> result = new ArrayList<Item>();
        for (String id : identifiers) {
            if (id == null || id.isEmpty()) continue;
            if (id.startsWith("#")) {
                String tagIdString = id.substring(1);
                try {
                    ResourceLocation tagId = new ResourceLocation(tagIdString);
                    Collection<Item> tagItems = ItemUtils.getItemsOfTag(tagId);
                    if (tagItems.isEmpty()) continue;
                    result.addAll(tagItems);
                }
                catch (Exception exception) {}
                continue;
            }
            Item item = ItemUtils.getItemById(id);
            if (item == null) continue;
            result.add(item);
        }
        return result;
    }

    public static List<ResourceLocation> getItemTags(Item item) {
        ITagManager tagManager = ForgeRegistries.ITEMS.tags();
        if (tagManager == null) {
            return Collections.emptyList();
        }
        return tagManager.getReverseTag((Object)item).map(reverseTag -> reverseTag.getTagKeys().map(TagKey::f_203868_).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public static boolean isItemIdEmpty(String id) {
        return id == null || id.equals("minecraft:air");
    }

    public static Area getArea(ItemStack itemStack) {
        int width = 1;
        int height = 1;
        String sizeString = EntryCache.matchItem(ItemUtils.getItemRegistryName(itemStack.m_41720_()));
        if (sizeString != null) {
            String[] size = sizeString.replace(" ", "").split("\\*");
            width = Integer.parseInt(size[0]);
            height = Integer.parseInt(size[1]);
        }
        AreaEvent event = new AreaEvent(width, height, itemStack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        AreaEvent _event = KubeJSCompat.area(event);
        return new Area(_event.width, _event.height, _event.itemStack);
    }
}

