/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.petiteinventory.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.sighs.petiteinventory.loader.Entry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;

public class EntryLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FMLPaths.CONFIGDIR.get().resolve("PetiteInventory");
    private static final String DEFAULT_CONFIG = "[\n  {\n    \"match\": [\"minecraft:bed\"],\n    \"result\": \"3*2\"\n  },\n  {\n    \"match\": [\"#minecraft:tools\"],\n    \"result\": \"1*2\"\n  },\n  {\n    \"match\": [\"#forge:stone\", \"#forge:ores\", \"#minecraft:logs\"],\n    \"result\": \"2*2\"\n  },\n  {\n    \"match\": [\"#minecraft:doors\"],\n    \"result\": \"2*3\"\n  },\n  {\n    \"match\": [\"#minecraft:slabs\"],\n    \"result\": \"2*1\"\n  }\n]";

    public static List<Entry> loadAll() {
        ArrayList<Entry> allRule = new ArrayList<Entry>();
        allRule.addAll(EntryLoader.loadFromDir(CONFIG_DIR));
        return allRule;
    }

    private static List<Entry> loadFromDir(Path path) {
        ArrayList<Entry> allRule = new ArrayList<Entry>();
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                Path defaultFile = path.resolve("default.json");
                if (!Files.exists(defaultFile, new LinkOption[0])) {
                    Files.writeString(defaultFile, (CharSequence)DEFAULT_CONFIG, new OpenOption[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return allRule;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.json");){
            for (Path file : stream) {
                allRule.addAll(EntryLoader.loadRecipesFromFile(file));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return allRule;
    }

    private static Collection<? extends Entry> loadRecipesFromFile(Path file) {
        Collection collection;
        block8: {
            BufferedReader reader = Files.newBufferedReader(file);
            try {
                collection = (Collection)GSON.fromJson((Reader)reader, new TypeToken<List<Entry>>(){}.getType());
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return List.of();
                }
            }
            ((Reader)reader).close();
        }
        return collection;
    }
}

