/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.mc.pwam.common;

import com.turikhay.mc.pwam.common.Invalidatable;
import com.turikhay.mc.pwam.common.PasswordPattern;
import com.turikhay.mc.pwam.common.PatternAwarePasswordGeneratorKt;
import com.turikhay.mc.pwam.common.text.TextProvider;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0001-B'\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J/\u0010\u0015\u001a\u00020\u00142\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0001H\u00c2\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u0004H\u00c2\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u0001H\u00c2\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001aJ\u0010\u0010\u001e\u001a\u00020\u0007H\u00c2\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001fJ8\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00012\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b \u0010!J\u001a\u0010%\u001a\u00020$2\b\u0010#\u001a\u0004\u0018\u00010\"H\u00d6\u0003\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010'\u001a\u00020\u0007H\u00d6\u0001\u00a2\u0006\u0004\b'\u0010\u001fJ\u0010\u0010(\u001a\u00020\fH\u00d6\u0001\u00a2\u0006\u0004\b(\u0010)R\u0014\u0010\u0003\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010*R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010+R\u0014\u0010\u0006\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010*R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010,\u00a8\u0006."}, d2={"Lcom/turikhay/mc/pwam/common/PatternAwarePasswordGenerator;", "Lcom/turikhay/mc/pwam/common/text/TextProvider;", "Lcom/turikhay/mc/pwam/common/Invalidatable;", "delegate", "Lcom/turikhay/mc/pwam/common/PasswordPattern;", "patternFactory", "patternProvider", "", "maxAttempts", "<init>", "(Lcom/turikhay/mc/pwam/common/text/TextProvider;Lcom/turikhay/mc/pwam/common/PasswordPattern;Lcom/turikhay/mc/pwam/common/text/TextProvider;I)V", "Ljava/util/concurrent/CompletableFuture;", "", "get", "()Ljava/util/concurrent/CompletableFuture;", "existingPattern", "generateUntilUnique", "(Ljava/lang/String;)Ljava/util/concurrent/CompletableFuture;", "future", "attempt", "", "tryGenerate", "(Ljava/util/concurrent/CompletableFuture;Ljava/lang/String;I)V", "invalidate", "()V", "component1", "()Lcom/turikhay/mc/pwam/common/text/TextProvider;", "component2", "()Lcom/turikhay/mc/pwam/common/PasswordPattern;", "component3", "component4", "()I", "copy", "(Lcom/turikhay/mc/pwam/common/text/TextProvider;Lcom/turikhay/mc/pwam/common/PasswordPattern;Lcom/turikhay/mc/pwam/common/text/TextProvider;I)Lcom/turikhay/mc/pwam/common/PatternAwarePasswordGenerator;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "()Ljava/lang/String;", "Lcom/turikhay/mc/pwam/common/text/TextProvider;", "Lcom/turikhay/mc/pwam/common/PasswordPattern;", "I", "NonUniquePatternException", "common"})
public final class PatternAwarePasswordGenerator
implements TextProvider,
Invalidatable {
    @NotNull
    private final TextProvider delegate;
    @NotNull
    private final PasswordPattern patternFactory;
    @NotNull
    private final TextProvider patternProvider;
    private final int maxAttempts;

    public PatternAwarePasswordGenerator(@NotNull TextProvider delegate, @NotNull PasswordPattern patternFactory, @NotNull TextProvider patternProvider, int maxAttempts) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)patternFactory, (String)"patternFactory");
        Intrinsics.checkNotNullParameter((Object)patternProvider, (String)"patternProvider");
        this.delegate = delegate;
        this.patternFactory = patternFactory;
        this.patternProvider = patternProvider;
        this.maxAttempts = maxAttempts;
    }

    @Override
    @NotNull
    public CompletableFuture<String> get() {
        CompletionStage completionStage = ((CompletableFuture)this.patternProvider.get()).thenCompose(arg_0 -> PatternAwarePasswordGenerator.get$lambda$1(arg_0 -> PatternAwarePasswordGenerator.get$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
        return completionStage;
    }

    private final CompletableFuture<String> generateUntilUnique(String existingPattern) {
        if (existingPattern == null) {
            Object t = this.delegate.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            return (CompletableFuture)t;
        }
        CompletableFuture<String> future = new CompletableFuture<String>();
        this.tryGenerate(future, existingPattern, 1);
        return future;
    }

    private final void tryGenerate(CompletableFuture<String> future, String existingPattern, int attempt) {
        if (attempt > this.maxAttempts) {
            future.completeExceptionally(new NonUniquePatternException());
            return;
        }
        if (this.delegate instanceof Invalidatable) {
            ((Invalidatable)((Object)this.delegate)).invalidate();
        }
        ((CompletableFuture)this.delegate.get()).whenComplete((arg_0, arg_1) -> PatternAwarePasswordGenerator.tryGenerate$lambda$5((arg_0, arg_1) -> PatternAwarePasswordGenerator.tryGenerate$lambda$4(future, this, existingPattern, attempt, arg_0, arg_1), arg_0, arg_1));
    }

    @Override
    public void invalidate() {
        if (this.delegate instanceof Invalidatable) {
            ((Invalidatable)((Object)this.delegate)).invalidate();
        }
        if (this.patternProvider instanceof Invalidatable) {
            ((Invalidatable)((Object)this.patternProvider)).invalidate();
        }
    }

    private final TextProvider component1() {
        return this.delegate;
    }

    private final PasswordPattern component2() {
        return this.patternFactory;
    }

    private final TextProvider component3() {
        return this.patternProvider;
    }

    private final int component4() {
        return this.maxAttempts;
    }

    @NotNull
    public final PatternAwarePasswordGenerator copy(@NotNull TextProvider delegate, @NotNull PasswordPattern patternFactory, @NotNull TextProvider patternProvider, int maxAttempts) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)patternFactory, (String)"patternFactory");
        Intrinsics.checkNotNullParameter((Object)patternProvider, (String)"patternProvider");
        return new PatternAwarePasswordGenerator(delegate, patternFactory, patternProvider, maxAttempts);
    }

    public static /* synthetic */ PatternAwarePasswordGenerator copy$default(PatternAwarePasswordGenerator patternAwarePasswordGenerator, TextProvider textProvider, PasswordPattern passwordPattern, TextProvider textProvider2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            textProvider = patternAwarePasswordGenerator.delegate;
        }
        if ((n2 & 2) != 0) {
            passwordPattern = patternAwarePasswordGenerator.patternFactory;
        }
        if ((n2 & 4) != 0) {
            textProvider2 = patternAwarePasswordGenerator.patternProvider;
        }
        if ((n2 & 8) != 0) {
            n = patternAwarePasswordGenerator.maxAttempts;
        }
        return patternAwarePasswordGenerator.copy(textProvider, passwordPattern, textProvider2, n);
    }

    @NotNull
    public String toString() {
        return "PatternAwarePasswordGenerator(delegate=" + this.delegate + ", patternFactory=" + this.patternFactory + ", patternProvider=" + this.patternProvider + ", maxAttempts=" + this.maxAttempts + ")";
    }

    public int hashCode() {
        int result = this.delegate.hashCode();
        result = result * 31 + this.patternFactory.hashCode();
        result = result * 31 + this.patternProvider.hashCode();
        result = result * 31 + Integer.hashCode(this.maxAttempts);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PatternAwarePasswordGenerator)) {
            return false;
        }
        PatternAwarePasswordGenerator patternAwarePasswordGenerator = (PatternAwarePasswordGenerator)other;
        if (!Intrinsics.areEqual((Object)this.delegate, (Object)patternAwarePasswordGenerator.delegate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.patternFactory, (Object)patternAwarePasswordGenerator.patternFactory)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.patternProvider, (Object)patternAwarePasswordGenerator.patternProvider)) {
            return false;
        }
        return this.maxAttempts == patternAwarePasswordGenerator.maxAttempts;
    }

    private static final CompletionStage get$lambda$0(PatternAwarePasswordGenerator this$0, String existingPattern) {
        return this$0.generateUntilUnique(existingPattern);
    }

    private static final CompletionStage get$lambda$1(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final Object tryGenerate$lambda$4$lambda$2(String $existingPattern) {
        return "Oh wow! We've generated the password, and its pattern is identical to the existing: " + $existingPattern;
    }

    private static final Object tryGenerate$lambda$4$lambda$3(String $pattern) {
        return "We've generated a unique password now, all good: " + $pattern;
    }

    private static final Unit tryGenerate$lambda$4(CompletableFuture $future, PatternAwarePasswordGenerator this$0, String $existingPattern, int $attempt, String pwd, Throwable t) {
        if (t != null) {
            $future.completeExceptionally(t);
        } else if (pwd == null) {
            $future.complete(null);
        } else {
            String pattern = this$0.patternFactory.patternOf(pwd);
            if (Intrinsics.areEqual((Object)pattern, (Object)$existingPattern)) {
                PatternAwarePasswordGeneratorKt.access$getLogger$p().warn(() -> PatternAwarePasswordGenerator.tryGenerate$lambda$4$lambda$2($existingPattern));
                this$0.tryGenerate($future, $existingPattern, $attempt + 1);
            } else {
                if ($attempt > 1) {
                    PatternAwarePasswordGeneratorKt.access$getLogger$p().warn(() -> PatternAwarePasswordGenerator.tryGenerate$lambda$4$lambda$3(pattern));
                }
                $future.complete(pwd);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void tryGenerate$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/turikhay/mc/pwam/common/PatternAwarePasswordGenerator$NonUniquePatternException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "<init>", "()V", "common"})
    public static final class NonUniquePatternException
    extends Exception {
        public NonUniquePatternException() {
            super("Failed to create a unique password", null, false, false);
        }
    }
}

