/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.mc.pwam.common;

import com.turikhay.mc.pwam.common.PasswordPatternDetector;
import com.turikhay.mc.pwam.common.PatternCommandRewriterKt;
import com.turikhay.mc.pwam.common.text.PasswordPair;
import com.turikhay.mc.pwam.common.text.PasswordPairProvider;
import com.turikhay.mc.pwam.mc.Notificator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J)\u0010\u0018\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u000f0\u00170\u0012H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001aR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001bR\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/turikhay/mc/pwam/common/PatternCommandRewriter;", "", "", "Lcom/turikhay/mc/pwam/common/text/PasswordPairProvider;", "providers", "Lcom/turikhay/mc/pwam/mc/Notificator;", "notificator", "Lcom/turikhay/mc/pwam/common/PasswordPatternDetector;", "patternDetector", "<init>", "(Ljava/util/List;Lcom/turikhay/mc/pwam/mc/Notificator;Lcom/turikhay/mc/pwam/common/PasswordPatternDetector;)V", "", "cmd", "rewriteNow", "(Ljava/lang/String;)Ljava/lang/String;", "Ljava/util/concurrent/CompletableFuture;", "rewriteLater", "(Ljava/lang/String;)Ljava/util/concurrent/CompletableFuture;", "Lkotlin/sequences/Sequence;", "Lcom/turikhay/mc/pwam/common/text/PasswordPair;", "pairs", "doRewrite", "(Ljava/lang/String;Lkotlin/sequences/Sequence;)Ljava/lang/String;", "Lkotlin/Pair;", "providersMapSeq", "()Lkotlin/sequences/Sequence;", "Ljava/util/List;", "Lcom/turikhay/mc/pwam/mc/Notificator;", "Lcom/turikhay/mc/pwam/common/PasswordPatternDetector;", "common"})
@SourceDebugExtension(value={"SMAP\nPatternCommandRewriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatternCommandRewriter.kt\ncom/turikhay/mc/pwam/common/PatternCommandRewriter\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n37#2,2:62\n1#3:64\n*S KotlinDebug\n*F\n+ 1 PatternCommandRewriter.kt\ncom/turikhay/mc/pwam/common/PatternCommandRewriter\n*L\n39#1:62,2\n*E\n"})
public final class PatternCommandRewriter {
    @NotNull
    private final List<PasswordPairProvider> providers;
    @NotNull
    private final Notificator notificator;
    @NotNull
    private final PasswordPatternDetector patternDetector;

    public PatternCommandRewriter(@NotNull List<PasswordPairProvider> providers, @NotNull Notificator notificator, @NotNull PasswordPatternDetector patternDetector) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter((Object)notificator, (String)"notificator");
        Intrinsics.checkNotNullParameter((Object)patternDetector, (String)"patternDetector");
        this.providers = providers;
        this.notificator = notificator;
        this.patternDetector = patternDetector;
    }

    @NotNull
    public final String rewriteNow(@NotNull String cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        if (!this.patternDetector.containsPattern(cmd)) {
            PatternCommandRewriterKt.access$getLogger$p().info(PatternCommandRewriter::rewriteNow$lambda$0);
            return cmd;
        }
        PatternCommandRewriterKt.access$getLogger$p().info(PatternCommandRewriter::rewriteNow$lambda$1);
        String dispatch = null;
        try {
            dispatch = this.doRewrite(cmd, (Sequence<PasswordPair>)SequencesKt.map(this.providersMapSeq(), PatternCommandRewriter::rewriteNow$lambda$3));
        }
        catch (Exception e) {
            PatternCommandRewriterKt.access$getLogger$p().error((Throwable)e, () -> PatternCommandRewriter.rewriteNow$lambda$4(cmd));
            dispatch = "";
        }
        return dispatch;
    }

    @NotNull
    public final CompletableFuture<String> rewriteLater(@NotNull String cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.map(this.providersMapSeq(), PatternCommandRewriter::rewriteLater$lambda$5));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] futures = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletionStage completionStage = CompletableFuture.allOf(Arrays.copyOf(futures, futures.length)).thenApply(arg_0 -> PatternCommandRewriter.rewriteLater$lambda$8(arg_0 -> PatternCommandRewriter.rewriteLater$lambda$7(this, cmd, futures, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private final String doRewrite(String cmd, Sequence<PasswordPair> pairs) {
        String r = cmd;
        for (PasswordPair pair : SequencesKt.filterNotNull(pairs)) {
            r = StringsKt.replace$default((String)r, (String)pair.getPattern(), (String)pair.getPassword(), (boolean)false, (int)4, null);
        }
        if (!Intrinsics.areEqual((Object)r, (Object)cmd)) {
            this.notificator.passwordUseNotification();
        }
        return r;
    }

    private final Sequence<Pair<PasswordPairProvider, CompletableFuture<PasswordPair>>> providersMapSeq() {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.providers), PatternCommandRewriter::providersMapSeq$lambda$9);
    }

    private static final Object rewriteNow$lambda$0() {
        return "Command doesn't contain a pattern";
    }

    private static final Object rewriteNow$lambda$1() {
        return "Command contains a pattern";
    }

    private static final PasswordPair rewriteNow$lambda$3(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!((CompletableFuture)it.getSecond()).isDone()) {
            boolean bl = false;
            String string = "Pair has not resolved yet: " + it.getFirst();
            throw new IllegalArgumentException(string.toString());
        }
        return (PasswordPair)((CompletableFuture)it.getSecond()).get();
    }

    private static final Object rewriteNow$lambda$4(String $cmd) {
        return "Error processing the command: " + $cmd;
    }

    private static final CompletableFuture rewriteLater$lambda$5(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (CompletableFuture)it.getSecond();
    }

    private static final PasswordPair rewriteLater$lambda$7$lambda$6(CompletableFuture it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (PasswordPair)it.get();
    }

    private static final String rewriteLater$lambda$7(PatternCommandRewriter this$0, String $cmd, CompletableFuture[] $futures, Void it) {
        return this$0.doRewrite($cmd, (Sequence<PasswordPair>)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])$futures), PatternCommandRewriter::rewriteLater$lambda$7$lambda$6));
    }

    private static final String rewriteLater$lambda$8(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Pair providersMapSeq$lambda$9(PasswordPairProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        return TuplesKt.to((Object)provider, provider.queryBoth());
    }
}

