/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.mc.pwam.mc;

import com.turikhay.mc.pwam.common.Disposable;
import com.turikhay.mc.pwam.common.Invalidatable;
import com.turikhay.mc.pwam.common.InvalidatableKt;
import com.turikhay.mc.pwam.common.PasswordChangeCallback;
import com.turikhay.mc.pwam.common.PasswordGeneratorKt;
import com.turikhay.mc.pwam.common.PasswordPattern;
import com.turikhay.mc.pwam.common.PasswordsKt;
import com.turikhay.mc.pwam.common.PatternAwarePasswordGenerator;
import com.turikhay.mc.pwam.common.PatternCommandRewriter;
import com.turikhay.mc.pwam.common.text.CacheableTextProvider;
import com.turikhay.mc.pwam.common.text.Pairs;
import com.turikhay.mc.pwam.common.text.PasswordPairProvider;
import com.turikhay.mc.pwam.common.text.TextProviderKt;
import com.turikhay.mc.pwam.common.text.TextProvidersCache;
import com.turikhay.mc.pwam.mc.CommandDispatcherHandler;
import com.turikhay.mc.pwam.mc.IAskServerSuggestion;
import com.turikhay.mc.pwam.mc.IClient;
import com.turikhay.mc.pwam.mc.ICommandNodeAccessor;
import com.turikhay.mc.pwam.mc.ICommandSource;
import com.turikhay.mc.pwam.mc.KnownCommandHandler;
import com.turikhay.mc.pwam.mc.ManagementCmd;
import com.turikhay.mc.pwam.mc.Notificator;
import com.turikhay.mc.pwam.mc.PlatformAudience;
import com.turikhay.mc.pwam.mc.SessionInfo;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 :2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001:BE\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001bR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001dR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001eR\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010!R\u0014\u0010#\u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010!R\u0014\u0010$\u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010!R\u0017\u0010&\u001a\u00020%8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0014\u0010.\u001a\u00020-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0017\u00101\u001a\u0002008\u0006\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b3\u00104R\u0017\u00106\u001a\u0002058\u0006\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109\u00a8\u0006;"}, d2={"Lcom/turikhay/mc/pwam/mc/Session;", "Lcom/turikhay/mc/pwam/common/PasswordChangeCallback;", "Lcom/turikhay/mc/pwam/common/Invalidatable;", "Lcom/turikhay/mc/pwam/common/Disposable;", "Lcom/turikhay/mc/pwam/mc/IClient;", "client", "Lcom/turikhay/mc/pwam/mc/SessionInfo;", "info", "Lorg/jetbrains/exposed/sql/Database;", "db", "Ljava/util/concurrent/Executor;", "executor", "Lcom/turikhay/mc/pwam/mc/ICommandNodeAccessor;", "Lcom/turikhay/mc/pwam/mc/ICommandSource;", "commandNodeAccessor", "Lcom/turikhay/mc/pwam/mc/IAskServerSuggestion;", "askServerSuggestion", "Lcom/turikhay/mc/pwam/common/PasswordPattern;", "pattern", "<init>", "(Lcom/turikhay/mc/pwam/mc/IClient;Lcom/turikhay/mc/pwam/mc/SessionInfo;Lorg/jetbrains/exposed/sql/Database;Ljava/util/concurrent/Executor;Lcom/turikhay/mc/pwam/mc/ICommandNodeAccessor;Lcom/turikhay/mc/pwam/mc/IAskServerSuggestion;Lcom/turikhay/mc/pwam/common/PasswordPattern;)V", "", "newPassword", "", "changePassword", "(Ljava/lang/String;)V", "invalidate", "()V", "cleanUp", "Lcom/turikhay/mc/pwam/mc/SessionInfo;", "Lorg/jetbrains/exposed/sql/Database;", "Lcom/turikhay/mc/pwam/common/text/CacheableTextProvider;", "registerPwdProvider", "Lcom/turikhay/mc/pwam/common/text/CacheableTextProvider;", "registerPwdPatternProvider", "loginPwdProvider", "loginPwdPatternProvider", "Lcom/turikhay/mc/pwam/common/text/TextProvidersCache;", "pwdPatternCache", "Lcom/turikhay/mc/pwam/common/text/TextProvidersCache;", "getPwdPatternCache", "()Lcom/turikhay/mc/pwam/common/text/TextProvidersCache;", "Lcom/turikhay/mc/pwam/common/text/Pairs;", "pairs", "Lcom/turikhay/mc/pwam/common/text/Pairs;", "Lcom/turikhay/mc/pwam/mc/Notificator;", "notificator", "Lcom/turikhay/mc/pwam/mc/Notificator;", "Lcom/turikhay/mc/pwam/common/PatternCommandRewriter;", "commandRewriter", "Lcom/turikhay/mc/pwam/common/PatternCommandRewriter;", "getCommandRewriter", "()Lcom/turikhay/mc/pwam/common/PatternCommandRewriter;", "Lcom/turikhay/mc/pwam/mc/CommandDispatcherHandler;", "commandDispatcherHandler", "Lcom/turikhay/mc/pwam/mc/CommandDispatcherHandler;", "getCommandDispatcherHandler", "()Lcom/turikhay/mc/pwam/mc/CommandDispatcherHandler;", "Companion", "common"})
public final class Session
implements PasswordChangeCallback,
Invalidatable,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SessionInfo info;
    @NotNull
    private final Database db;
    @NotNull
    private final CacheableTextProvider registerPwdProvider;
    @NotNull
    private final CacheableTextProvider registerPwdPatternProvider;
    @NotNull
    private final CacheableTextProvider loginPwdProvider;
    @NotNull
    private final CacheableTextProvider loginPwdPatternProvider;
    @NotNull
    private final TextProvidersCache pwdPatternCache;
    @NotNull
    private final Pairs pairs;
    @NotNull
    private final Notificator notificator;
    @NotNull
    private final PatternCommandRewriter commandRewriter;
    @NotNull
    private final CommandDispatcherHandler commandDispatcherHandler;
    @Nullable
    private static Session session;

    public Session(@NotNull IClient client, @NotNull SessionInfo info, @NotNull Database db, @NotNull Executor executor, @NotNull ICommandNodeAccessor<ICommandSource> commandNodeAccessor, @NotNull IAskServerSuggestion askServerSuggestion, @NotNull PasswordPattern pattern) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(commandNodeAccessor, (String)"commandNodeAccessor");
        Intrinsics.checkNotNullParameter((Object)askServerSuggestion, (String)"askServerSuggestion");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.info = info;
        this.db = db;
        this.registerPwdProvider = new CacheableTextProvider(TextProviderKt.provideText("register", executor, (Function0<String>)((Function0)Session::registerPwdProvider$lambda$0)));
        this.registerPwdPatternProvider = new CacheableTextProvider(pattern.providePwdPattern(this.registerPwdProvider));
        this.loginPwdProvider = new CacheableTextProvider(new PatternAwarePasswordGenerator(TextProviderKt.provideText("login", executor, (Function0<String>)((Function0)() -> Session.loginPwdProvider$lambda$2(this))), pattern, this.registerPwdPatternProvider, 2));
        this.loginPwdPatternProvider = new CacheableTextProvider(pattern.providePwdPattern(this.loginPwdProvider));
        Object[] objectArray = new CacheableTextProvider[]{this.loginPwdPatternProvider, this.registerPwdPatternProvider};
        this.pwdPatternCache = new TextProvidersCache(CollectionsKt.listOf((Object[])objectArray));
        this.pairs = new Pairs(new PasswordPairProvider(this.loginPwdProvider, this.loginPwdPatternProvider), new PasswordPairProvider(this.registerPwdProvider, this.registerPwdPatternProvider));
        this.notificator = new Notificator(client, pattern);
        this.commandRewriter = new PatternCommandRewriter(this.pairs.asList(), this.notificator, pattern);
        KnownCommandHandler knownCommandHandler = new KnownCommandHandler(client, this.commandRewriter, this.pairs, this, this.notificator, pattern);
        PlatformAudience platformAudience = client;
        PasswordChangeCallback passwordChangeCallback = this;
        String string = client.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
        this.commandDispatcherHandler = new CommandDispatcherHandler(knownCommandHandler, this.pairs, commandNodeAccessor, askServerSuggestion, new ManagementCmd<ICommandSource>(this.db, pattern, this.info, platformAudience, passwordChangeCallback, string), client, executor);
    }

    @NotNull
    public final TextProvidersCache getPwdPatternCache() {
        return this.pwdPatternCache;
    }

    @NotNull
    public final PatternCommandRewriter getCommandRewriter() {
        return this.commandRewriter;
    }

    @NotNull
    public final CommandDispatcherHandler getCommandDispatcherHandler() {
        return this.commandDispatcherHandler;
    }

    @Override
    public void changePassword(@NotNull String newPassword) {
        Intrinsics.checkNotNullParameter((Object)newPassword, (String)"newPassword");
        ThreadLocalTransactionManagerKt.transaction((Database)this.db, arg_0 -> Session.changePassword$lambda$3(this, newPassword, arg_0));
        this.invalidate();
        this.notificator.passwordChangeNotification(newPassword);
    }

    @Override
    public void invalidate() {
        Invalidatable[] invalidatableArray = new Invalidatable[]{this.loginPwdProvider, this.loginPwdPatternProvider, this.registerPwdProvider, this.registerPwdPatternProvider, this.pwdPatternCache};
        InvalidatableKt.invalidateAll(invalidatableArray);
    }

    @Override
    public void cleanUp() {
        this.invalidate();
    }

    private static final String registerPwdProvider$lambda$0() {
        return PasswordGeneratorKt.generatePassword(12);
    }

    private static final String loginPwdProvider$lambda$2$lambda$1(Session this$0, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        return PasswordsKt.getPassword(this$0.info.getUsername(), this$0.info.getServer());
    }

    private static final String loginPwdProvider$lambda$2(Session this$0) {
        return (String)ThreadLocalTransactionManagerKt.transaction((Database)this$0.db, arg_0 -> Session.loginPwdProvider$lambda$2$lambda$1(this$0, arg_0));
    }

    private static final Unit changePassword$lambda$3(Session this$0, String $newPassword, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        PasswordsKt.setPassword(this$0.info.getUsername(), this$0.info.getServer(), $newPassword);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/turikhay/mc/pwam/mc/Session$Companion;", "", "<init>", "()V", "Lcom/turikhay/mc/pwam/mc/Session;", "session", "Lcom/turikhay/mc/pwam/mc/Session;", "getSession", "()Lcom/turikhay/mc/pwam/mc/Session;", "setSession", "(Lcom/turikhay/mc/pwam/mc/Session;)V", "common"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Session getSession() {
            return session;
        }

        public final void setSession(@Nullable Session session) {
            Session.session = session;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

