/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.foundation.blockEntity.behaviour;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class DynamicCycleBehavior
extends BlockEntityBehaviour {
    private int cycleTime;
    public static final BehaviourType<DynamicCycleBehavior> TYPE = new BehaviourType();
    public DynamicCycleBehaviorSpecifics specifics;
    private int prevRunningTicks;
    private int runningTicks;
    private boolean running;
    private boolean finished;

    public <T extends SmartBlockEntity> DynamicCycleBehavior(T te) {
        super(te);
        this.specifics = (DynamicCycleBehaviorSpecifics)te;
    }

    public void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.running = compound.getBoolean("Running");
        this.finished = compound.getBoolean("Finished");
        this.prevRunningTicks = this.runningTicks = compound.getInt("Ticks");
        this.cycleTime = compound.getInt("CycleTime");
        super.read(compound, registries, clientPacket);
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putBoolean("Running", this.running);
        compound.putBoolean("Finished", this.finished);
        compound.putInt("Ticks", this.runningTicks);
        compound.putInt("CycleTime", this.cycleTime);
        super.write(compound, registries, clientPacket);
    }

    public void start() {
        this.running = true;
        this.prevRunningTicks = 0;
        this.runningTicks = 0;
        this.cycleTime = this.specifics.getProcessingTime();
        this.specifics.cycleStart();
        this.blockEntity.sendData();
    }

    public void stop() {
        this.running = false;
        this.prevRunningTicks = 0;
        this.runningTicks = 0;
        this.cycleTime = 1;
        this.specifics.cycleStop();
        this.blockEntity.sendData();
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void tick() {
        super.tick();
        Level level = this.getWorld();
        if (!this.running || level == null) {
            if (level != null && !level.isClientSide) {
                if (this.specifics.getKineticSpeed() == 0.0f) {
                    return;
                }
                if (this.specifics.tryProcess(true)) {
                    this.start();
                }
            }
            return;
        }
        if (level.isClientSide && this.runningTicks == -this.cycleTime) {
            this.prevRunningTicks = this.cycleTime;
            return;
        }
        if (this.runningTicks >= this.cycleTime && this.specifics.getKineticSpeed() != 0.0f) {
            this.apply();
            this.specifics.playCompletionSound();
            if (!level.isClientSide) {
                this.blockEntity.sendData();
            }
        }
        if (!level.isClientSide && this.runningTicks >= this.cycleTime) {
            this.finished = true;
            this.running = false;
            this.specifics.onOperationCompleted();
            this.blockEntity.sendData();
            return;
        }
        this.prevRunningTicks = this.runningTicks;
        this.runningTicks += this.getRunningTickSpeed();
        if (level.isClientSide) {
            this.specifics.playRunningSound();
            this.specifics.showParticles();
        }
        if (this.prevRunningTicks < this.cycleTime && this.runningTicks >= this.cycleTime) {
            this.runningTicks = this.cycleTime;
            if (level.isClientSide && !this.blockEntity.isVirtual()) {
                this.runningTicks = -this.cycleTime;
            }
        }
    }

    public float getProgress(float partialTicks) {
        if (!this.running) {
            return 0.0f;
        }
        if (this.getCycleTime() == 0) {
            return 0.0f;
        }
        int runningTicks = Math.abs(this.runningTicks);
        float ticks = Mth.lerp((float)partialTicks, (float)this.prevRunningTicks, (float)runningTicks);
        return ticks / (float)this.cycleTime * 100.0f;
    }

    protected void apply() {
        Level level = this.getWorld();
        if (level.isClientSide) {
            return;
        }
        if (this.specifics.tryProcess(false)) {
            this.blockEntity.sendData();
        }
    }

    public int getRunningTickSpeed() {
        float speed = this.specifics.getKineticSpeed();
        if (speed == 0.0f) {
            return 0;
        }
        return (int)Mth.lerp((float)Mth.clamp((float)(Math.abs(speed) / 512.0f), (float)0.0f, (float)1.0f), (float)1.0f, (float)60.0f);
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getTotalProgressPercent() {
        return Mth.clamp((int)(this.runningTicks * 100 / this.cycleTime), (int)0, (int)100);
    }

    public int getCycleTime() {
        return this.cycleTime;
    }

    public int getPrevRunningTicks() {
        return this.prevRunningTicks;
    }

    public int getRunningTicks() {
        return this.runningTicks;
    }

    public int getProgressPercent() {
        if (!this.running) {
            return 0;
        }
        if (this.getCycleTime() == 0) {
            return 0;
        }
        return Mth.clamp((int)(this.prevRunningTicks * 100 / this.getCycleTime()), (int)0, (int)100);
    }

    public float getProgressPercentFloat() {
        if (!this.running) {
            return 0.0f;
        }
        if (this.getCycleTime() == 0) {
            return 0.0f;
        }
        return (float)this.prevRunningTicks / (float)this.getCycleTime();
    }

    public float getProcessingRemainingPercentFloat() {
        if (!this.running) {
            return 1.0f;
        }
        if (this.getCycleTime() == 0) {
            return 1.0f;
        }
        return 1.0f - (float)(this.getCycleTime() - this.prevRunningTicks) / (float)this.getCycleTime();
    }

    public static interface DynamicCycleBehaviorSpecifics {
        default public void cycleStart() {
        }

        default public void cycleStop() {
        }

        default public void onOperationCompleted() {
        }

        default public void playRunningSound() {
        }

        default public void showParticles() {
        }

        default public void playCompletionSound() {
        }

        public float getKineticSpeed();

        public boolean tryProcess(boolean var1);

        public int getProcessingTime();
    }
}

