/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.foundation.recipe;

import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.oierbravo.mechanicals.foundation.recipe.RecipeRequirementType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.data.Pair;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface IRecipeWithRequirements {
    public ArrayList<IRecipeRequirement> getRecipeRequirements();

    default public ArrayList<IRecipeRequirement> getRecipeRequirementsToCheck() {
        return this.getRecipeRequirements();
    }

    default public List<IRecipeRequirement> getJeiRecipeRequirements() {
        return this.getRecipeRequirements();
    }

    default public Optional<IRecipeRequirement> getRequirement(RecipeRequirementType<?> type) {
        return this.getRecipeRequirements().stream().filter(iRecipeRequirement -> iRecipeRequirement.getType() == type).findFirst();
    }

    default public boolean meetsRequirements(BlockEntity pBlockEntity) {
        for (IRecipeRequirement requirement : this.getRecipeRequirementsToCheck()) {
            if (requirement.test(pBlockEntity.getLevel(), pBlockEntity)) continue;
            return false;
        }
        return true;
    }

    default public List<String> getMissingRequirements(BlockEntity pBlockEntity) {
        ArrayList<String> missingRequirements = new ArrayList<String>();
        for (IRecipeRequirement requirement : this.getRecipeRequirementsToCheck()) {
            if (requirement.test(pBlockEntity.getLevel(), pBlockEntity)) continue;
            missingRequirements.add(requirement.getIdString());
        }
        return missingRequirements;
    }

    default public List<Pair<Component, Component>> getRequirementsTooltips() {
        if (this.getRecipeRequirements().isEmpty()) {
            return List.of();
        }
        return this.getRecipeRequirements().stream().map(IRecipeRequirement::toTooltipComponent).toList();
    }

    default public List<Pair<Component, Component>> getJeiRequirementsTooltips() {
        if (this.getJeiRecipeRequirements().isEmpty()) {
            return List.of();
        }
        return this.getJeiRecipeRequirements().stream().map(IRecipeRequirement::toTooltipComponent).toList();
    }
}

