/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.foundation.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class FluidRenderer {
    public static void renderFluidInTank(BlockAndTintGetter world, BlockPos pos, float x, float y, FluidStack fluidStack, PoseStack matrix, MultiBufferSource buffer, float width, float height, int pPackedLight, int pPackedOverlay) {
        matrix.pushPose();
        matrix.translate(0.5, 0.565, 0.5);
        Matrix4f matrix4f = matrix.last().pose();
        Matrix3f matrix3f = matrix.last().normal();
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite fluidTexture = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(clientFluid.getStillTexture(fluidStack));
        int color = clientFluid.getTintColor(fluidStack);
        VertexConsumer builder = buffer.getBuffer(RenderType.translucent());
        FluidRenderer.renderTopFluidFace(fluidTexture, matrix4f, matrix3f, builder, color, width, height, x, y, pPackedLight, pPackedOverlay);
        matrix.popPose();
    }

    private static void renderTopFluidFace(TextureAtlasSprite sprite, Matrix4f matrix4f, Matrix3f normalMatrix, VertexConsumer builder, int color, float width, float height, float x, float y, int pPackedLight, int pPackedOverlay) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float minU = sprite.getU(0.25f);
        float maxU = sprite.getU(1.0f);
        float minV = sprite.getV(0.25f);
        float maxV = sprite.getV(1.0f);
        float pY = -height / 2.0f + y * height;
        builder.addVertex(matrix4f, -width / 2.0f, pY, -width / 2.0f).setColor(r, g, b, a).setUv(minU, minV).setLight(pPackedLight).setOverlay(pPackedOverlay).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, -width / 2.0f, pY, width / 2.0f).setColor(r, g, b, a).setUv(minU, maxV).setLight(pPackedLight).setOverlay(pPackedOverlay).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, width / 2.0f, pY, width / 2.0f).setColor(r, g, b, a).setUv(maxU, maxV).setLight(pPackedLight).setOverlay(pPackedOverlay).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(matrix4f, width / 2.0f, pY, -width / 2.0f).setColor(r, g, b, a).setUv(maxU, minV).setLight(pPackedLight).setOverlay(pPackedOverlay).setNormal(0.0f, 1.0f, 0.0f);
    }
}

