/*
 * Decompiled with CFR 0.152.
 */
package org.Portality.createteas;

import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import org.Portality.createteas.items.TeaActions;
import org.Portality.createteas.items.TeaDrinkingActions;
import org.Portality.createteas.items.TeaInfo;

public enum AllTeas {
    ABSOLUTE_TEANIMA("absolute_teanima", AllTeas.teaEffectS(MobEffects.f_19610_, 5), TeaActions.absoluteTea(), false, AllTeas.duo(AllTeas.minecraft("gray_dye"), AllTeas.create("builders_tea"))),
    ACTUAL_BUILDER_S_TEA("actual_builder_s_tea", AllTeas.teaEffectM(MobEffects.f_19598_, 2, 1), AllTeas.duo(AllTeas.tea("absolute_teanima"), AllTeas.minecraft("bricks"))),
    AET("aet", AllTeas.teaEffectM(MobEffects.f_19599_, 3), TeaActions.aet(), false, AllTeas.minecraft("warped_wart_block")),
    ANDESITE_TEA("andesite_tea", AllTeas.teaEffectS(MobEffects.f_19597_, 10), TeaActions.andesiteAlloy(), false, AllTeas.create("andesite_alloy")),
    ANONYMOUS_TEA("anonymous_tea", AllTeas.teaEffectS(MobEffects.f_19609_, 10), AllTeas.minecraft("clay_ball")),
    ANTIFREEZE("antifreeze", AllTeas.teaEffectS(MobEffects.f_19607_, 40), TeaActions.antiFreeze(), false, AllTeas.minecraft("magma_block")),
    BEE_SWARM_TEAMULATOR("bee_swarm_teamulator", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaActions.beeTea(), false, AllTeas.minecraft("honeycomb")),
    BEER_IN_A_CUP("beer_in_a_cup", new MobEffectInstance[]{AllTeas.teaEffectS(MobEffects.f_19604_, 40), AllTeas.teaEffectS(MobEffects.f_19597_, 30)}, TeaActions.drivingInMyBeer(), false, AllTeas.minecraft("brown_mushroom")),
    BLACK_TEA("black_tea", AllTeas.teaEffectM(MobEffects.f_19596_, 3), AllTeas.minecraft("ink_sac")),
    BLAZE_TEA("blaze_tea", AllTeas.teaEffectS(MobEffects.f_19607_, 40), TeaActions.blazeTea(), false, AllTeas.minecraft("blaze_rod")),
    BLOOD("blood", AllTeas.teaEffectM(MobEffects.f_19605_, 1, 2), TeaActions.boneTea(), false, AllTeas.minecraft("redstone")),
    BREAZING_TEA("breazing_tea", AllTeas.teaEffectS(MobEffects.f_19620_, 10), TeaActions.spawnParticleTypeTea((ParticleOptions)ParticleTypes.f_123815_), false, AllTeas.minecraft("snowball")),
    BUBLE_GUM_TEA("buble_gum_tea", AllTeas.teaEffectS(MobEffects.f_19603_, 10, 1), AllTeas.duo(AllTeas.minecraft("pink_dye"), AllTeas.minecraft("light_blue_dye"))),
    CARDBOARD_TEA("cardboard_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaActions.cardboardTea(), false, AllTeas.create("cardboard")),
    CARROT_TEA("carrot_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 2), TeaActions.spawnParticleTypeTea((ParticleOptions)ParticleTypes.f_123750_), false, "carrot"),
    CAT_S_NOT_SIMI_TEA("cat_s_not_simi_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 2), AllTeas.duo(AllTeas.minecraft("cooked_cod"), AllTeas.minecraft("pink_dye"))),
    CHOCOLATE_TEA("chocolate_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 2), TeaActions.spawnParticleTypeTea((ParticleOptions)ParticleTypes.f_123750_), false, AllTeas.create("bar_of_chocolate")),
    COCOA("cocoa", AllTeas.teaEffectM(MobEffects.f_19618_, 2), TeaActions.spawnParticleTypeTea((ParticleOptions)ParticleTypes.f_123750_), false, AllTeas.minecraft("cocoa_beans")),
    COMMUNIST_TEA("communist_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaActions.communistTea(), false, AllTeas.duo(AllTeas.minecraft("red_dye"), AllTeas.minecraft("yellow_dye"))),
    CRYSTAL_SLIME_IN_A_CUP("crystal_slime_in_a_cup", TeaActions.slimeTea(20), false, AllTeas.duo(AllTeas.minecraft("slime_ball"), AllTeas.minecraft("diamond"))),
    CYBER_TEA("cyber_tea", TeaActions.cyberTea(30), false, AllTeas.duo(AllTeas.minecraft("redstone"), AllTeas.minecraft("sticky_piston"))),
    DOOMED_TEA("doomed_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaDrinkingActions.limitedType(TeaActions.lavaTea(), 8), TeaActions.lavaTea(), AllTeas.minecraft("lava_bucket")),
    DUMPLING_TEA("dumpling_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 4), TeaActions.spawnParticleTypeTea((ParticleOptions)ParticleTypes.f_123750_), false, AllTeas.duo(AllTeas.create("dough"), AllTeas.minecraft("cooked_porkchop"))),
    ELECTRONIC_TEODE("electronic_teode", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaActions.cyberTea(60), false, AllTeas.create("electron_tube")),
    EXPERIENCED_TEA("experienced_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaDrinkingActions.spreadXPType(10), true, AllTeas.create("experience_nugget")),
    GAMBLER_S_TEA("gambler_s_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 1), AllTeas.minecraft("moss_block")),
    GREEN_TEA("green_tea", AllTeas.teaEffectM(MobEffects.f_19605_, 3), AllTeas.minecraft("oak_leaves")),
    HONEY_SLIME_IN_A_CUP("honey_slime_in_a_cup", TeaActions.slimeTea(20), false, AllTeas.duo(AllTeas.minecraft("slime_ball"), AllTeas.minecraft("honey_bottle"))),
    LAVENDER_TEA("lavender_tea", AllTeas.teaEffectM(MobEffects.f_19616_, 3), AllTeas.minecraft("allium")),
    LITERALLY_FISH("literally_fish", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaActions.fishTea(), false, AllTeas.minecraft("salmon")),
    MAGMA_IN_A_CUP("magma_in_a_cup", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaActions.lavaTea(), false, AllTeas.minecraft("magma_cream")),
    MELON_TEA("melon_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaDrinkingActions.kotarbuzTea(), true, AllTeas.minecraft("melon")),
    MILKY_MINT_TEA("milky_mint_tea", AllTeas.teaEffectM(MobEffects.f_19600_, 1, 1), AllTeas.duo(AllTeas.tea("mint_tea"), AllTeas.minecraft("milk_bucket"))),
    MINT_TEA("mint_tea", AllTeas.teaEffectM(MobEffects.f_19600_, 3), AllTeas.minecraft("grass")),
    MOLTEN_BRASS("molten_brass", new MobEffectInstance[]{AllTeas.teaEffectS(MobEffects.f_19597_, 10), AllTeas.teaEffectS(MobEffects.f_19605_, 5, 2), AllTeas.teaEffectS(MobEffects.f_19616_, 10, 2), AllTeas.teaEffectS(MobEffects.f_19607_, 5)}, TeaDrinkingActions.spreadItemType("brass_nugget", 4), true, AllTeas.create("brass_ingot")),
    MOLTEN_COPPER("molten_copper", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaActions.copperTea(), false, AllTeas.minecraft("copper_block")),
    MOLTEN_FISH("molten_fish", AllTeas.teaEffectS(MobEffects.f_19614_, 30), TeaActions.moltenFishTea(), false, AllTeas.minecraft("pufferfish")),
    MOLTEN_IRON("molten_iron", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaActions.ironTea(), false, AllTeas.minecraft("iron_block")),
    MOLTEN_NETHER_PORTAL("molten_nether_portal", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaActions.netherness(30), false, AllTeas.minecraft("crying_obsidian")),
    MOLTEN_NETHERITE("molten_netherite", new MobEffectInstance[]{AllTeas.teaEffectS(MobEffects.f_19597_, 5), AllTeas.teaEffectS(MobEffects.f_19605_, 50, 2), AllTeas.teaEffectS(MobEffects.f_19616_, 50, 2), AllTeas.teaEffectS(MobEffects.f_19611_, 25), AllTeas.teaEffectS(MobEffects.f_19607_, 25)}, AllTeas.duo(AllTeas.tea("molten_brass"), AllTeas.minecraft("netherite_scrap"))),
    MOLTEN_OBSIDIAN("molten_obsidian", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaActions.netherness(30), false, AllTeas.create("powdered_obsidian")),
    MOLTEN_SPRING_ALLOY("molten_spring_alloy", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaActions.slimeTea(120), false, AllTeas.duo(AllTeas.create("brass_ingot"), AllTeas.minecraft("slime_ball"))),
    NUCLEAR_TEA("nuclear_tea", new MobEffectInstance[]{AllTeas.teaEffectM(MobEffects.f_19619_, 5), AllTeas.teaEffectM(MobEffects.f_19597_, 10), AllTeas.teaEffectM(MobEffects.f_19613_, 15), AllTeas.teaEffectM(MobEffects.f_19614_, 5)}, AllTeas.duo(AllTeas.minecraft("deepslate_iron_ore"), AllTeas.minecraft("deepslate_copper_ore"))),
    ORANGE_TEA("orange_tea", AllTeas.teaEffectM(MobEffects.f_19593_, 1), AllTeas.minecraft("orange_dye")),
    OXIDIZED_TEA("oxidized_tea", AllTeas.teaEffectS(MobEffects.f_19614_, 45), TeaActions.copperTea(), false, AllTeas.minecraft("oxidized_copper")),
    PEACH_TEA("peach_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 3), TeaActions.spawnParticleTypeTea((ParticleOptions)ParticleTypes.f_123750_), false, AllTeas.duo(AllTeas.minecraft("glow_berries"), AllTeas.minecraft("blaze_powder"))),
    PINEAPLE_TEA("pineaple_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 3), TeaActions.spawnParticleTypeTea((ParticleOptions)ParticleTypes.f_123750_), false, AllTeas.duo(AllTeas.minecraft("glow_berries"), AllTeas.minecraft("honeycomb"))),
    PINK_SLIME_IN_A_CUP("pink_slime_in_a_cup", TeaActions.slimeTea(25), false, AllTeas.duo(AllTeas.minecraft("slime_ball"), AllTeas.minecraft("pink_dye"))),
    PISTACHIO_TEA("pistachio_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 3), TeaActions.pfTea(), false, AllTeas.duo(AllTeas.minecraft("lime_dye"), AllTeas.minecraft("scute"))),
    PORTAL_S_TEA("portal_s_tea", AllTeas.teaEffectM(MobEffects.f_19611_, 1), TeaDrinkingActions.portalTea(), TeaActions.portalTea(), AllTeas.minecraft("popped_chorus_fruit")),
    PUDDLE_SLIME_IN_A_CUP("puddle_slime_in_a_cup", TeaActions.slimeTea(30), false, AllTeas.duo(AllTeas.minecraft("slime_ball"), AllTeas.minecraft("cyan_dye"))),
    QUANTUM_SLIME_IN_A_CUP("quantum_slime_in_a_cup", TeaActions.slimeTea(200), false, AllTeas.tea("quantum_slime_in_a_cup")),
    RICH_TEA("rich_tea", AllTeas.teaEffectM(MobEffects.f_19597_, 1), AllTeas.minecraft("gold_ingot")),
    ROSE_QUARTZ_TEA("rose_quartz_tea", TeaActions.cyberTea(50), false, AllTeas.create("rose_quartz")),
    ROTEATOR("roteator", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaActions.rotateTea(), true, AllTeas.create("mechanical_bearing")),
    SCHEMATIC_OF_CUP("schematic_of_cup", AllTeas.teaEffectM(MobEffects.f_19596_, 1), TeaActions.schematicTea(), false, AllTeas.create("schematic ")),
    SMART_TEA_WITH_GOGGLES_SCHEMATICS_DOWNLOAD("smart_tea_with_goggles_schematics_download", AllTeas.teaEffectS(MobEffects.f_19596_, 30, 1), TeaActions.schematicTea(), false, AllTeas.create("goggles")),
    SMART_TEA_WITH_MONOCLE_SCHEMATICS_DOWNLOAD("smart_tea_with_monocle_schematics_download", AllTeas.teaEffectM(MobEffects.f_19596_, 40, 1), TeaActions.schematicTea(), false, AllTeas.minecraft("glass_pane")),
    SMART_TEA_WITHOUT_GOGGLES_SCHEMATICS_DOWNLOAD("smart_tea_without_goggles_schematics_download", AllTeas.teaEffectM(MobEffects.f_19596_, 1), TeaActions.schematicTea(), false, AllTeas.create("content_observer")),
    SPACE_TEAVELER("space_teaveler", AllTeas.teaEffectS(MobEffects.f_19603_, 5, 5), AllTeas.duo(AllTeas.minecraft("black_dye"), AllTeas.minecraft("magenta_dye"))),
    STICER_S_TEA("sticer_s_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaActions.sticerTea(), false, AllTeas.minecraft("paper")),
    STRONG_TEA("strong_tea", AllTeas.teaEffectM(MobEffects.f_19600_, 1), AllTeas.minecraft("blaze_rod")),
    SUSPICIOUS_TEA("suspicious_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaActions.susTea(), false, AllTeas.minecraft("red_dye")),
    SWEET_BERRIES_TEA("sweet_berries_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 3), TeaActions.spawnParticleTypeTea((ParticleOptions)ParticleTypes.f_123748_), false, AllTeas.minecraft("glow_berries")),
    TARRAGON_LEMONADE("tarragon_lemonade", AllTeas.teaEffectM(MobEffects.f_19618_, 3), TeaActions.spawnParticleTypeTea((ParticleOptions)ParticleTypes.f_123748_), false, AllTeas.minecraft("cactus")),
    TASTY_AIR("tasty_air", ""),
    TEA_NOT_FOUND("tea_not_found", AllTeas.teaEffectM(MobEffects.f_19618_, 1), AllTeas.tea("quantum_slime_in_a_cup")),
    TEA_RICHARD("tea_richard", AllTeas.teaEffectM(MobEffects.f_19591_, 1), AllTeas.minecraft("golden_carrot")),
    TEADH("teadh", AllTeas.teaEffectM(MobEffects.f_19607_, 1), TeaActions.defestoTea(5), false, AllTeas.minecraft("orange_banner")),
    TEAMAN("teaman", AllTeas.teaEffectM(MobEffects.f_19618_, 1), AllTeas.tea("tea_not_found")),
    THREE_LAYER_TEA_LATTE("three_layer_tea_latte", new MobEffectInstance[]{AllTeas.teaEffectS(MobEffects.f_19596_, 1), AllTeas.teaEffectS(MobEffects.f_19598_, 1)}, AllTeas.duo(AllTeas.minecraft("cocoa_beans"), AllTeas.minecraft("cocoa_beans"))),
    TIME_IN_A_TEA("time_in_a_tea", AllTeas.teaEffectM(MobEffects.f_19591_, 1), AllTeas.tea("time_in_a_tea")),
    TIRAMISU("tiramisu", AllTeas.teaEffectM(MobEffects.f_19618_, 3), TeaActions.spawnParticleTypeTea((ParticleOptions)ParticleTypes.f_123750_), false, AllTeas.duo(AllTeas.create("cocoa_beans"), AllTeas.minecraft("dough"))),
    TOMATO_TEA("tomato_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 3), TeaActions.spawnParticleTypeTea((ParticleOptions)ParticleTypes.f_123750_), false, AllTeas.duo(AllTeas.minecraft("red_dye"), AllTeas.minecraft("potato"))),
    WARPED_TEA("warped_tea", AllTeas.teaEffectM(MobEffects.f_19618_, 1), TeaActions.portalTea(), false, AllTeas.minecraft("end_stone")),
    WATER_REFERENCE("water_reference", AllTeas.minecraft("water_bucket")),
    WINTER_WIND_TEA("winter_wind_tea", AllTeas.teaEffectM(MobEffects.f_19607_, 1), TeaActions.coldTea(), false, AllTeas.duo(AllTeas.tea("breazing_tea"), AllTeas.create("propeller")));

    public final MobEffectInstance[] mobEffectInstances;
    public final String TeaName;
    public final String craftItem;

    private AllTeas(String teaName, MobEffectInstance[] mobEffectInstances, String craftItem) {
        this.mobEffectInstances = mobEffectInstances;
        this.TeaName = teaName;
        this.craftItem = craftItem;
    }

    private AllTeas(String teaName, MobEffectInstance mobEffectInstance, String craftItem) {
        this.mobEffectInstances = new MobEffectInstance[]{mobEffectInstance};
        this.TeaName = teaName;
        this.craftItem = craftItem;
    }

    private AllTeas(String teaName, String craftItem) {
        this.mobEffectInstances = new MobEffectInstance[0];
        this.TeaName = teaName;
        this.craftItem = craftItem;
    }

    private AllTeas(String teaName, MobEffectInstance[] mobEffectInstances, Function<TeaInfo, Void> action, boolean drinking, String craftItem) {
        this.mobEffectInstances = mobEffectInstances;
        this.TeaName = teaName;
        this.manageAction(action, drinking);
        this.craftItem = craftItem;
    }

    private AllTeas(String teaName, MobEffectInstance mobEffectInstance, Function<TeaInfo, Void> action, boolean drinking, String craftItem) {
        this.mobEffectInstances = new MobEffectInstance[]{mobEffectInstance};
        this.TeaName = teaName;
        this.manageAction(action, drinking);
        this.craftItem = craftItem;
    }

    private AllTeas(String teaName, Function<TeaInfo, Void> action, boolean drinking, String craftItem) {
        this.mobEffectInstances = new MobEffectInstance[0];
        this.TeaName = teaName;
        this.manageAction(action, drinking);
        this.craftItem = craftItem;
    }

    private AllTeas(String teaName, MobEffectInstance[] mobEffectInstances, Function<TeaInfo, Void> drinkingAction, Function<TeaInfo, Void> action, String craftItem) {
        this.mobEffectInstances = mobEffectInstances;
        this.TeaName = teaName;
        TeaDrinkingActions.putDrinkingAction(this.TeaName, drinkingAction);
        TeaActions.putAction(this.TeaName, action);
        this.craftItem = craftItem;
    }

    private AllTeas(String teaName, MobEffectInstance mobEffectInstance, Function<TeaInfo, Void> drinkingAction, Function<TeaInfo, Void> action, String craftItem) {
        this.mobEffectInstances = new MobEffectInstance[]{mobEffectInstance};
        this.TeaName = teaName;
        TeaDrinkingActions.putDrinkingAction(this.TeaName, drinkingAction);
        TeaActions.putAction(this.TeaName, action);
        this.craftItem = craftItem;
    }

    private AllTeas(String teaName, Function<TeaInfo, Void> drinkingAction, Function<TeaInfo, Void> action, String craftItem) {
        this.mobEffectInstances = new MobEffectInstance[0];
        this.TeaName = teaName;
        TeaDrinkingActions.putDrinkingAction(this.TeaName, drinkingAction);
        TeaActions.putAction(this.TeaName, action);
        this.craftItem = craftItem;
    }

    private void manageAction(Function<TeaInfo, Void> action, boolean drinking) {
        if (drinking) {
            TeaDrinkingActions.putDrinkingAction(this.TeaName, action);
        } else {
            TeaActions.putAction(this.TeaName, action);
        }
    }

    private static MobEffectInstance teaEffectM(MobEffect effect, int timeMin) {
        return AllTeas.teaEffectM(effect, timeMin, 0);
    }

    public static MobEffectInstance teaEffectS(MobEffect effect, int timeSec) {
        return AllTeas.teaEffectS(effect, timeSec, 0);
    }

    private static MobEffectInstance teaEffectT(MobEffect effect, int timeTicks) {
        return AllTeas.teaEffectT(effect, timeTicks, 0);
    }

    private static MobEffectInstance teaEffectM(MobEffect effect, int timeMin, int level) {
        return AllTeas.teaEffectS(effect, timeMin * 60, level);
    }

    private static MobEffectInstance teaEffectS(MobEffect effect, int timeSec, int level) {
        return AllTeas.teaEffectT(effect, timeSec * 20, level);
    }

    private static MobEffectInstance teaEffectT(MobEffect effect, int timeTicks, int level) {
        return new MobEffectInstance(effect, timeTicks, level, false, false, false);
    }

    private static String minecraft(String craftItem) {
        return "minecraft:" + craftItem;
    }

    public static String create(String craftItem) {
        return "create:" + craftItem;
    }

    public static String tea(String craftItem) {
        return "createteas:" + craftItem;
    }

    public static String duo(String craftItem1, String craftItem2) {
        return craftItem1 + " " + craftItem2;
    }
}

