/*
 * Decompiled with CFR 0.152.
 */
package org.Portality.createteas.items;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.Portality.createteas.AllTeas;
import org.Portality.createteas.effects.TeaEffects;
import org.Portality.createteas.items.TeaInfo;
import org.Portality.createteas.items.additionalTeaFunctions;

public class TeaActions {
    public static HashMap<String, Function<TeaInfo, Void>> allTeaActions = new HashMap();

    public static Function<TeaInfo, Void> portalTea() {
        return info -> {
            Level level = info.level;
            LivingEntity entity = info.entity;
            if (level == null) {
                return null;
            }
            if (entity == null) {
                return null;
            }
            if (!level.f_46443_) {
                double d0 = entity.m_20185_();
                double d1 = entity.m_20186_();
                double d2 = entity.m_20189_();
                for (int i = 0; i < 16; ++i) {
                    double d3 = entity.m_20185_() + (entity.m_217043_().m_188500_() - 0.5) * 16.0;
                    double d4 = Mth.m_14008_((double)(entity.m_20186_() + (double)(entity.m_217043_().m_188503_(16) - 8)), (double)level.m_141937_(), (double)(level.m_141937_() + ((ServerLevel)level).m_143344_() - 1));
                    double d5 = entity.m_20189_() + (entity.m_217043_().m_188500_() - 0.5) * 16.0;
                    if (entity.m_20159_()) {
                        entity.m_8127_();
                    }
                    Vec3 vec3 = entity.m_20182_();
                    level.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)entity));
                    EntityTeleportEvent.ChorusFruit event = ForgeEventFactory.onChorusFruitTeleport((LivingEntity)entity, (double)d3, (double)d4, (double)d5);
                    if (event.isCanceled()) {
                        return null;
                    }
                    if (!entity.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
                    SoundEvent soundevent = entity instanceof Fox ? SoundEvents.f_11953_ : SoundEvents.f_11757_;
                    level.m_6263_((Player)null, d0, d1, d2, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                    entity.m_5496_(soundevent, 1.0f, 1.0f);
                    break;
                }
            }
            return null;
        };
    }

    public static Function<TeaInfo, Void> cardboardTea() {
        return info -> {
            LivingEntity entity = info.entity;
            Level world = info.level;
            if (!(entity instanceof Player)) {
                return null;
            }
            Player player = (Player)entity;
            float f = PackageItem.getPackageVelocity((int)10);
            if (world.f_46443_) {
                return null;
            }
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.5f);
            ItemStack copy = new ItemStack((ItemLike)PackageStyles.STANDARD_BOXES.get(world.f_46441_.m_216339_(0, PackageStyles.STANDARD_BOXES.size() - 1))).m_41777_();
            Vec3 vec = new Vec3(entity.m_20185_(), entity.m_20186_() + entity.m_20191_().m_82376_() / 2.0, entity.m_20189_());
            Vec3 motion = entity.m_20154_().m_82490_((double)(f * 2.0f));
            vec = vec.m_82549_(motion);
            PackageEntity packageEntity = new PackageEntity(world, vec.f_82479_, vec.f_82480_, vec.f_82481_);
            packageEntity.setBox(copy);
            packageEntity.m_20256_(motion);
            packageEntity.tossedBy = new WeakReference<Player>(player);
            world.m_7967_((Entity)packageEntity);
            return null;
        };
    }

    public static Function<TeaInfo, Void> copperTea() {
        return info -> {
            BlockPos lightningRoadPos;
            if (info.stack.m_41784_().m_128471_("drinked")) {
                return null;
            }
            Level level = info.level;
            LivingEntity entity = info.entity;
            Vec3 pos = entity.m_20182_();
            RandomSource source = level.f_46441_;
            int xShift = source.m_216339_(-4, 4);
            int zShift = source.m_216339_(-4, 4);
            Vec3 lightningPos = new Vec3(pos.f_82479_ + (double)xShift, pos.f_82480_, pos.f_82481_ + (double)zShift);
            LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(level);
            if (lightning != null) {
                lightning.m_20219_(lightningPos);
                lightning.m_20874_(true);
                level.m_7967_((Entity)lightning);
            }
            if ((lightningRoadPos = additionalTeaFunctions.findSafeY(level, BlockPos.m_274446_((Position)lightningPos), 3)) == null) {
                return null;
            }
            BlockState state = level.m_8055_(BlockPos.m_274446_((Position)lightningPos));
            if (state.m_60795_()) {
                level.m_7731_(BlockPos.m_274446_((Position)lightningPos), Blocks.f_152587_.m_49966_(), 3);
            }
            info.stack.m_41784_().m_128379_("drinked", true);
            return null;
        };
    }

    public static Function<TeaInfo, Void> ironTea() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            IronGolem golem = (IronGolem)EntityType.f_20460_.m_20615_(level);
            golem.m_146884_(new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()));
            level.m_7967_((Entity)golem);
            return null;
        };
    }

    public static Function<TeaInfo, Void> lavaTea() {
        return info -> {
            LivingEntity entity = info.entity;
            entity.m_20254_(10);
            DamageSources damageSources = info.level.m_269111_();
            entity.m_6469_(damageSources.m_269233_(), 4.0f);
            return null;
        };
    }

    public static Function<TeaInfo, Void> boneTea() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            Skeleton skeleton = (Skeleton)EntityType.f_20524_.m_20615_(level);
            skeleton.m_146884_(new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()));
            level.m_7967_((Entity)skeleton);
            return null;
        };
    }

    public static Function<TeaInfo, Void> spawnParticleTypeTea(ParticleOptions particleT) {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            RandomSource random = level.m_213780_();
            Vec3 center = entity.m_20182_();
            double radius = 3.0;
            for (int i = 0; i < 10; ++i) {
                double theta = random.m_188500_() * 2.0 * Math.PI;
                double phi = random.m_188500_() * Math.PI;
                double r = radius * random.m_188500_();
                double x = r * Math.sin(phi) * Math.cos(theta);
                double y = r * Math.cos(phi);
                double z = r * Math.sin(phi) * Math.sin(theta);
                Vec3 pos = center.m_82520_(x, y, z);
                if (particleT == ParticleTypes.f_123750_) {
                    level.m_7106_(particleT, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1.0, 0.0, 0.0);
                    continue;
                }
                level.m_7106_(particleT, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
            return null;
        };
    }

    public static Function<TeaInfo, Void> coldTea() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            BlockPos center = entity.m_20183_();
            additionalTeaFunctions.setStateSafe(center.m_7495_(), Blocks.f_50126_, level);
            additionalTeaFunctions.setRingSafe(center, Blocks.f_50126_, level);
            additionalTeaFunctions.setRingSafe(center.m_7494_(), Blocks.f_50126_, level);
            additionalTeaFunctions.setStateSafe(center.m_6630_(2), Blocks.f_50126_, level);
            return null;
        };
    }

    public static Function<TeaInfo, Void> aet() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            if (!(entity instanceof Player)) {
                return null;
            }
            Player player = (Player)entity;
            if (level.f_46443_) {
                return null;
            }
            FoodData foodData = player.m_36324_();
            foodData.m_38705_(Math.max(0, foodData.m_38702_() - 1));
            ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundSetHealthPacket(player.m_21223_(), foodData.m_38702_(), foodData.m_38722_()));
            return null;
        };
    }

    public static Function<TeaInfo, Void> andesiteAlloy() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_36356_(AllItems.ANDESITE_ALLOY.asStack());
            }
            return null;
        };
    }

    public static Function<TeaInfo, Void> absoluteTea() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)"Absolute")));
                player.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.m_237113_((String)"Teanima")));
                player.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(20, 60, 20));
            }
            return null;
        };
    }

    public static Function<TeaInfo, Void> antiFreeze() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            entity.m_20095_();
            return null;
        };
    }

    public static Function<TeaInfo, Void> beeTea() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            additionalTeaFunctions.spawnInARandomAround(level, entity, EntityType.f_20550_, 3, 1);
            return null;
        };
    }

    public static Function<TeaInfo, Void> drivingInMyBeer() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_7292_(AllTeas.teaEffectS((MobEffect)TeaEffects.CRAWL.get(), 20));
            }
            return null;
        };
    }

    public static Function<TeaInfo, Void> blazeTea() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            entity.m_20254_(10);
            return null;
        };
    }

    public static Function<TeaInfo, Void> communistTea() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)"\u262d").m_130940_(ChatFormatting.RED)));
                player.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(20, 60, 20));
            }
            return null;
        };
    }

    public static Function<TeaInfo, Void> slimeTea(int sec) {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_7292_(AllTeas.teaEffectS((MobEffect)TeaEffects.SLIMENESS.get(), sec));
            }
            return null;
        };
    }

    public static Function<TeaInfo, Void> cyberTea(int sec) {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_7292_(AllTeas.teaEffectS((MobEffect)TeaEffects.REDSTONES.get(), sec));
            }
            return null;
        };
    }

    public static Function<TeaInfo, Void> fishTea() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            additionalTeaFunctions.spawnInARandomAround(level, entity, EntityType.f_20519_, 3, 1);
            return null;
        };
    }

    public static Function<TeaInfo, Void> moltenFishTea() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            additionalTeaFunctions.spawnInARandomAround(level, entity, EntityType.f_20516_, 3, 1);
            return null;
        };
    }

    public static Function<TeaInfo, Void> netherness(int sec) {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_7292_(AllTeas.teaEffectS((MobEffect)TeaEffects.NETHERNESS.get(), sec));
            }
            return null;
        };
    }

    public static Function<TeaInfo, Void> pfTea() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                Item boneMeal = Items.f_42499_;
                boneMeal.m_6225_(new UseOnContext(level, player, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)boneMeal), new BlockHitResult(player.m_20183_().m_7495_().m_252807_().m_82549_(new Vec3(0.0, 0.5, 0.0)), Direction.UP, player.m_20183_().m_7495_(), false)));
                boneMeal.m_6225_(new UseOnContext(level, player, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)boneMeal), new BlockHitResult(player.m_20183_().m_252807_().m_82549_(new Vec3(0.0, 0.5, 0.0)), Direction.UP, player.m_20183_(), false)));
            }
            return null;
        };
    }

    public static Function<TeaInfo, Void> rotateTea() {
        return info -> {
            LivingEntity entity = info.entity;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == info.stack.m_41720_()) {
                    if (player.m_6144_()) {
                        player.m_146922_(player.m_146908_() - 10.0f);
                    } else {
                        player.m_146922_(player.m_146908_() + 10.0f);
                    }
                } else if (player.m_6144_()) {
                    player.m_146926_(player.m_146909_() - 10.0f);
                } else {
                    player.m_146926_(player.m_146909_() + 10.0f);
                }
            }
            return null;
        };
    }

    public static Function<TeaInfo, Void> schematicTea() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)"DOWNLOAD SCHEMATIC").m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.UNDERLINE)));
                player.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.m_237113_((String)"Click here to download")));
                player.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(20, 60, 20));
            }
            return null;
        };
    }

    public static Function<TeaInfo, Void> sticerTea() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_36356_(new ItemStack((ItemLike)Items.f_42516_).m_41714_((Component)Component.m_237113_((String)"sticer")));
            }
            return null;
        };
    }

    public static Function<TeaInfo, Void> susTea() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)"SUS").m_130940_(ChatFormatting.RED)));
                player.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(20, 60, 20));
            }
            return null;
        };
    }

    public static Function<TeaInfo, Void> defestoTea(int s) {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            entity.m_7292_(AllTeas.teaEffectS((MobEffect)TeaEffects.DEFFESTO.get(), s));
            return null;
        };
    }

    public static Function<TeaInfo, Void> exampleTea() {
        return info -> {
            LivingEntity entity = info.entity;
            Level level = info.level;
            ItemStack stack = info.stack;
            return null;
        };
    }

    public static void putAction(String name, Function<TeaInfo, Void> function) {
        allTeaActions.put("createteas:" + name, function);
    }

    public static void register() {
    }
}

