/*
 * Decompiled with CFR 0.152.
 */
package org.Portality.createteas.items;

import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.Portality.createteas.AllTeas;
import org.Portality.createteas.Createteas;
import org.Portality.createteas.items.TeaActions;
import org.Portality.createteas.items.TeaInfo;
import org.Portality.createteas.items.additionalTeaFunctions;

public class TeaDrinkingActions {
    public static HashMap<String, Function<TeaInfo, Void>> allDrinkingTeaActions = new HashMap();

    public static Function<TeaInfo, Void> portalTea() {
        return TeaDrinkingActions.limitedType(info -> {
            Level level = info.level;
            LivingEntity livingEntity = info.entity;
            ItemStack stack = info.stack;
            Function<TeaInfo, Void> action = TeaDrinkingActions.getTeaAction(AllTeas.PORTAL_S_TEA);
            if (action == null) {
                return null;
            }
            action.apply(new TeaInfo(level, stack, livingEntity, 0));
            return null;
        }, 10);
    }

    public static Function<TeaInfo, Void> kotarbuzTea() {
        return TeaDrinkingActions.limitedType(info -> {
            Level level = info.level;
            LivingEntity entity = info.entity;
            additionalTeaFunctions.growWatterMelon(level, entity);
            entity.m_146926_(100.0f);
            return null;
        }, 10);
    }

    public static Function<TeaInfo, Void> spreadXPType(int limit) {
        return TeaDrinkingActions.limitedType(info -> {
            Level level = info.level;
            LivingEntity livingEntity = info.entity;
            additionalTeaFunctions.spawnEntity(level, livingEntity);
            return null;
        }, limit);
    }

    public static Function<TeaInfo, Void> spreadItemType(String item, int limit) {
        return TeaDrinkingActions.limitedType(info -> {
            Level level = info.level;
            LivingEntity entity = info.entity;
            additionalTeaFunctions.spawnItems(level, entity, Createteas.getCreateItemFromName(item));
            return null;
        }, limit);
    }

    public static Function<TeaInfo, Void> limitedType(Function<TeaInfo, Void> function, int limit) {
        return info -> {
            int time_remaining = info.time_remaining;
            ItemStack stack = info.stack;
            if (time_remaining % (32 / limit) == 0 && stack.m_41784_().m_128451_("drinked") <= limit) {
                function.apply((TeaInfo)info);
                stack.m_41784_().m_128405_("drinked", stack.m_41784_().m_128451_("drinked") + 1);
            }
            return null;
        };
    }

    public static Function<TeaInfo, Void> getTeaAction(AllTeas tea) {
        return TeaActions.allTeaActions.get("createteas:" + tea.TeaName);
    }

    public static void putDrinkingAction(String name, Function<TeaInfo, Void> function) {
        allDrinkingTeaActions.put("createteas:" + name, function);
    }

    public static void register() {
    }
}

