/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.client.entities.crawfish;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.client.entities.crawfish.CrawfishAnimation;
import uwu.juni.wetland_whimsy.content.entities.CrawfishEntity;

@ParametersAreNonnullByDefault
public class CrawfishModel
extends HierarchicalModel<CrawfishEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WetlandWhimsy.rLoc("crawfish"), "main");
    private final ModelPart base;
    private final ModelPart clawRight;
    private final ModelPart clawLeft;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart antennaRight;
    private final ModelPart antennaLeft;

    public CrawfishModel(ModelPart root) {
        this.base = root.getChild("base");
        this.clawRight = this.base.getChild("clawRight");
        this.clawLeft = this.base.getChild("clawLeft");
        this.body = this.base.getChild("body");
        this.tail = this.body.getChild("tail");
        this.antennaRight = this.base.getChild("antennaRight");
        this.antennaLeft = this.base.getChild("antennaLeft");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition base = partdefinition.addOrReplaceChild("base", CubeListBuilder.create(), PartPose.offset((float)5.0f, (float)24.0f, (float)-4.0f));
        PartDefinition clawRight = base.addOrReplaceChild("clawRight", CubeListBuilder.create().texOffs(0, 14).addBox(-3.0f, -2.0f, -4.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)-8.0f, (float)-2.0f, (float)3.0f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition clawLeft = base.addOrReplaceChild("clawLeft", CubeListBuilder.create().texOffs(0, 14).mirror().addBox(-1.0f, -2.0f, -4.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(-0.25f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)-2.0f, (float)3.0f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition body = base.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-7.5f, -4.0f, 0.0f, 5.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(-6, 23).addBox(-9.0f, -1.0f, 3.0f, 8.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(11, 23).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)-2.0f, (float)10.0f));
        PartDefinition antennaRight = base.addOrReplaceChild("antennaRight", CubeListBuilder.create().texOffs(-5, 0).addBox(-1.0f, 0.0f, -5.0f, 1.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-2.0f, (float)0.0f, (float)-0.0873f, (float)0.1745f, (float)0.0f));
        PartDefinition antennaLeft = base.addOrReplaceChild("antennaLeft", CubeListBuilder.create().texOffs(-5, 0).addBox(0.0f, 0.0f, -5.0f, 1.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-2.0f, (float)0.0f, (float)-0.0873f, (float)-0.1745f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(CrawfishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animateWalk(CrawfishAnimation.MOVE, limbSwing, limbSwingAmount, 3.0f, 2.5f);
        this.animate(entity.idleAnimationState, CrawfishAnimation.IDLE, ageInTicks, 1.0f);
    }

    public ModelPart root() {
        return this.base;
    }
}

