/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.blocks.entities;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.codecs.Incense;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlockEntities;
import uwu.juni.wetland_whimsy.content.blocks.entities.AncientBrazierSpawner;
import uwu.juni.wetland_whimsy.events.WetlandWhimsyRegisters;
import uwu.juni.wetland_whimsy.tags.WetlandWhimsyTags;

@ParametersAreNonnullByDefault
public class AncientBrazierBlockEntity
extends BlockEntity
implements Spawner {
    AncientBrazierSpawner spawner = new AncientBrazierSpawner(){

        public Either<BlockEntity, Entity> getOwner() {
            return Either.left((Object)((Object)AncientBrazierBlockEntity.this));
        }
    };
    protected Optional<Item> incense = Optional.empty();
    protected List<Item> usedIncenses = new ArrayList<Item>();

    public AncientBrazierBlockEntity(BlockPos pos, BlockState state) {
        super(WetlandWhimsyBlockEntities.ANCIENT_BRAZIER.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.spawner.load(this.level, this.worldPosition, tag);
        tag.getList("used_incenses", 8).stream().map(Tag::getAsString).map(ResourceLocation::parse).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).forEach(this.usedIncenses::add);
        String str = tag.getString("incense");
        if (str == "" || str == null) {
            return;
        }
        ResourceKey incenseKey = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)str));
        this.incense = Optional.of((Item)BuiltInRegistries.ITEM.get(incenseKey));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.spawner.save(tag);
        ListTag list = new ListTag();
        for (Item item : this.usedIncenses) {
            list.add((Object)StringTag.valueOf((String)item.toString()));
        }
        if (!list.isEmpty()) {
            tag.put("used_incenses", (Tag)list);
        }
        if (this.incense.isPresent()) {
            tag.putString("incense", this.incense.get().toString());
        }
    }

    public void setEntityId(EntityType<?> type, RandomSource random) {
        this.spawner.setEntityId(type, this.level, random, this.worldPosition);
        this.setChanged();
    }

    public boolean triggerEvent(int id, int type) {
        return this.level == null ? false : (this.spawner.onEventTriggered(this.level, id) ? true : super.triggerEvent(id, type));
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, AncientBrazierBlockEntity blockEntity) {
        blockEntity.spawner.clientTick(level, pos);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AncientBrazierBlockEntity blockEntity) {
        blockEntity.spawner.serverTick((ServerLevel)level, pos);
    }

    public boolean trySetIncense(ItemLike itemlike) {
        Item item = itemlike.asItem();
        if (this.incense.isPresent() || this.usedIncenses.contains(item) || !new ItemStack((ItemLike)item).is(WetlandWhimsyTags.Items.INCENSE)) {
            return false;
        }
        this.incense = Optional.of(item.asItem());
        this.usedIncenses.add(item);
        this.setChanged();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            this.spawner.setRandomEntity(sLevel, this.worldPosition);
        }
        return true;
    }

    public boolean hasIncense() {
        return this.incense.isPresent();
    }

    public Optional<Incense> getIncense(ServerLevel level) {
        return this.incense.flatMap(item -> {
            Set entries = level.registryAccess().registryOrThrow(WetlandWhimsyRegisters.INCENSE).entrySet();
            for (Map.Entry entry : entries) {
                if (((Incense)entry.getValue()).item() != item) continue;
                return Optional.of((Incense)entry.getValue());
            }
            WetlandWhimsy.LOGGER.error("Incense " + String.valueOf(item) + " at " + String.valueOf(this.getBlockPos()) + " lacks an incense file");
            return Optional.empty();
        });
    }

    public void killIncense() {
        this.incense = Optional.empty();
    }
}

