/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.blocks.entities;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.codecs.ScalableReward;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlockEntities;
import uwu.juni.wetland_whimsy.events.WetlandWhimsyRegisters;

@ParametersAreNonnullByDefault
public class AncientPotBlockEntity
extends BlockEntity {
    public static final ResourceKey<ScalableReward> LOOT_KEY = ResourceKey.create(WetlandWhimsyRegisters.SCALABLE_REWARD, (ResourceLocation)WetlandWhimsy.rLoc("ancient_pot"));
    private int lootQuality = 1;

    public AncientPotBlockEntity(BlockPos pos, BlockState state) {
        super(WetlandWhimsyBlockEntities.ANCIENT_POT.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("loot_quality", this.lootQuality);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.lootQuality = tag.getInt("loot_quality");
    }

    public void increaseLootQuality() {
        ++this.lootQuality;
    }

    public int lootQuality() {
        return this.lootQuality;
    }

    public void dropLoot(ServerLevel level, BlockPos pos) {
        ScalableReward.Manager.getLoot(level, LOOT_KEY, this.lootQuality).forEach(item -> Block.popResource((Level)level, (BlockPos)pos, (ItemStack)item));
    }
}

