/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.items;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import uwu.juni.wetland_whimsy.content.WetlandWhimsySounds;

@ParametersAreNonnullByDefault
public class DaggerItem
extends Item {
    public static final int TICKS_WITH_INCREASED_DAMAGE = 20;
    public static final int INCREASED_DAMAGE_BONUS = 12;

    public DaggerItem(Item.Properties properties) {
        super(properties.component(DataComponents.TOOL, (Object)DaggerItem.createToolProperties()));
    }

    public static Tool createToolProperties() {
        return new Tool((List)ImmutableList.of((Object)Tool.Rule.minesAndDrops((List)ImmutableList.of((Object)Blocks.COBWEB), (float)15.0f), (Object)Tool.Rule.overrideSpeed((TagKey)BlockTags.SWORD_EFFICIENT, (float)1.5f)), 1.0f, 2);
    }

    public static ItemAttributeModifiers createAttributes(float damage, float speed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)damage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)speed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.shouldDoIncreasedDamage(target, attacker)) {
            attacker.level().playSound(null, attacker.blockPosition(), (SoundEvent)WetlandWhimsySounds.DAGGER_PARRY.get(), SoundSource.PLAYERS, 4.0f, 1.0f);
            Minecraft.getInstance().particleEngine.createTrackingEmitter((Entity)attacker, (ParticleOptions)ParticleTypes.CRIT);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public float getAttackDamageBonus(Entity target, float damage, DamageSource damageSource) {
        if (target instanceof LivingEntity) {
            LivingEntity attacker;
            LivingEntity livingTarget = (LivingEntity)target;
            Entity entity = damageSource.getDirectEntity();
            if (entity instanceof LivingEntity && this.shouldDoIncreasedDamage(livingTarget, attacker = (LivingEntity)entity)) {
                return 12.0f;
            }
        }
        return super.getAttackDamageBonus(target, damage, damageSource);
    }

    public boolean shouldDoIncreasedDamage(LivingEntity target, LivingEntity attacker) {
        int lastHurtByMob = attacker.tickCount - attacker.getLastHurtByMobTimestamp();
        return attacker.getLastAttacker() == target && lastHurtByMob <= 20;
    }
}

