/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.datagen.loot;

import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlocks;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyLoot;
import uwu.juni.wetland_whimsy.datagen.loot.WetlandWhimsyEntityLoot;

@ParametersAreNonnullByDefault
public class WetlandWhimsyMiscLoot
implements LootTableSubProvider {
    public static final ResourceKey<LootTable> SUSSY_MUD_COMMON = WetlandWhimsyMiscLoot.createKey("suspicious_mud_common");
    public static final ResourceKey<LootTable> SUSSY_MUD_UNCOMMON = WetlandWhimsyMiscLoot.createKey("suspicious_mud_uncommon");
    public static final ResourceKey<LootTable> DECORATED_POT_LOOT = WetlandWhimsyMiscLoot.createKey("decorated_pot_loot");
    public static final ResourceKey<LootTable> ANCIENT_BRAZIER_LOOT = WetlandWhimsyMiscLoot.createKey("brazier_loot");
    public static final ResourceKey<LootTable> BOILING_INCENSE = WetlandWhimsyMiscLoot.createKey("incense/boiling");
    public static final ResourceKey<LootTable> BRINE_INCENSE = WetlandWhimsyMiscLoot.createKey("incense/brine");
    public static final ResourceKey<LootTable> ROT_INCENSE = WetlandWhimsyMiscLoot.createKey("incense/rot");
    public static final ResourceKey<LootTable> WEBBED_INCENSE = WetlandWhimsyMiscLoot.createKey("incense/webbed");
    public static final ResourceKey<LootTable> INFECTED_SPIDER_SHEARED = WetlandWhimsyMiscLoot.createKey("entities/infected_spider_sheared");
    public static final ResourceKey<LootTable> INFECTED_SPIDER_SHEARING = WetlandWhimsyMiscLoot.createKey("entities/infected_spider_shearing");

    static ResourceKey<LootTable> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)WetlandWhimsy.rLoc(name));
    }

    public WetlandWhimsyMiscLoot(HolderLookup.Provider lookupProvider) {
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
        output.accept(SUSSY_MUD_COMMON, WetlandWhimsyLoot.createCommonMudLoot());
        output.accept(SUSSY_MUD_UNCOMMON, WetlandWhimsyLoot.createUncommonMudLoot());
        output.accept(DECORATED_POT_LOOT, WetlandWhimsyLoot.createDecoratedPotLoot());
        output.accept(ANCIENT_BRAZIER_LOOT, WetlandWhimsyLoot.createAncientBrazierLoot());
        output.accept(BOILING_INCENSE, WetlandWhimsyLoot.createBoilingLoot());
        output.accept(BRINE_INCENSE, WetlandWhimsyLoot.createBrineLoot());
        output.accept(ROT_INCENSE, WetlandWhimsyLoot.createRotLoot());
        output.accept(WEBBED_INCENSE, WetlandWhimsyLoot.createWebbedLoot());
        output.accept(INFECTED_SPIDER_SHEARED, WetlandWhimsyEntityLoot.INFECTED_SPIDER_TABLE);
        output.accept(INFECTED_SPIDER_SHEARING, WetlandWhimsyMiscLoot.table(WetlandWhimsyMiscLoot.item(WetlandWhimsyBlocks.FELLCAP_MUSHROOM, 1.0, 3.0)));
    }

    static LootTable.Builder table(LootPoolSingletonContainer.Builder<?> item) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add(item));
    }

    static LootPoolSingletonContainer.Builder<?> item(ItemLike item, double min, double max) {
        return LootItem.lootTableItem((ItemLike)item).apply(WetlandWhimsyLoot.lootCount((float)min, (float)max));
    }
}

