/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.datagen.registries;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TrunkVineDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlocks;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyFeatures;
import uwu.juni.wetland_whimsy.content.blocks.PennywortBlock;
import uwu.juni.wetland_whimsy.content.features.BlobPatchConfig;
import uwu.juni.wetland_whimsy.worldgen.aria_mushroom.AriaMushroomFoliagePlacer;
import uwu.juni.wetland_whimsy.worldgen.aria_mushroom.AriaMushroomTreeDecorator;
import uwu.juni.wetland_whimsy.worldgen.bald_cypress.BaldCypressFoliagePlacer;
import uwu.juni.wetland_whimsy.worldgen.bald_cypress.BaldCypressTrunkPlacer;
import uwu.juni.wetland_whimsy.worldgen.fellcap_mushroom.FellcapMushroomFoliagePlacer;

public class WetlandWhimsyConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> BALD_CYPRESS_TREE = WetlandWhimsyConfiguredFeatures.createKey("bald_cypress_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_FELLCAP_MUSHROOM = WetlandWhimsyConfiguredFeatures.createKey("huge_fellcap_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_ARIA_MUSHROOM = WetlandWhimsyConfiguredFeatures.createKey("huge_aria_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FELLCAP_PATCH = WetlandWhimsyConfiguredFeatures.createKey("fellcap_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CORDGRASS_PATCH = WetlandWhimsyConfiguredFeatures.createKey("cordgrass_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PENNYWORT_PATCH = WetlandWhimsyConfiguredFeatures.createKey("pennywort_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PENNYWORT_PATCH_SMALL = WetlandWhimsyConfiguredFeatures.createKey("pennywort_single");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LEMONSTONE_BLOB = WetlandWhimsyConfiguredFeatures.createKey("lemonstone_blob");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MUD_BLOB = WetlandWhimsyConfiguredFeatures.createKey("mud_blob");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MUD_PATCH = WetlandWhimsyConfiguredFeatures.createKey("mud_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MUD_POOL = WetlandWhimsyConfiguredFeatures.createKey("mud_pool");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_BOG = WetlandWhimsyConfiguredFeatures.createKey("trees_bog");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_MARSH = WetlandWhimsyConfiguredFeatures.createKey("trees_marsh");

    public static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)WetlandWhimsy.rLoc(name));
    }

    public static void bootstap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        SimpleWeightedRandomList.Builder pennywortRandomState = new SimpleWeightedRandomList.Builder();
        for (int i = 1; i <= 4; ++i) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                pennywortRandomState.add((Object)((BlockState)((BlockState)((PennywortBlock)((Object)WetlandWhimsyBlocks.PENNYWORT.get())).defaultBlockState().setValue(PennywortBlock.FACING, (Comparable)dir)).setValue((Property)PennywortBlock.PENNYWORT_COUNT, (Comparable)Integer.valueOf(i))));
            }
        }
        context.register(BALD_CYPRESS_TREE, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_LOG.get())), (TrunkPlacer)new BaldCypressTrunkPlacer(6, 2, 2), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_LEAVES.get())), (FoliagePlacer)new BaldCypressFoliagePlacer((IntProvider)ConstantInt.of((int)4), (IntProvider)ConstantInt.of((int)6)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).decorators(List.of(new LeaveVineDecorator(0.2f), new TrunkVineDecorator(), new AriaMushroomTreeDecorator(0.15f))).ignoreVines().build()));
        BlockState MUSHROOM_STEM = (BlockState)((BlockState)Blocks.MUSHROOM_STEM.defaultBlockState().setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false));
        context.register(HUGE_FELLCAP_MUSHROOM, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)MUSHROOM_STEM), (TrunkPlacer)new StraightTrunkPlacer(3, 0, 1), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)WetlandWhimsyBlocks.FELLCAP_MUSHROOM_BLOCK.get())), (FoliagePlacer)new FellcapMushroomFoliagePlacer((IntProvider)ConstantInt.of((int)4), (IntProvider)ConstantInt.of((int)6)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).ignoreVines().build()));
        context.register(HUGE_ARIA_MUSHROOM, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)MUSHROOM_STEM), (TrunkPlacer)new StraightTrunkPlacer(4, 1, 2), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)WetlandWhimsyBlocks.ARIA_MUSHROOM_BLOCK.get())), (FoliagePlacer)new AriaMushroomFoliagePlacer((IntProvider)ConstantInt.of((int)4), (IntProvider)ConstantInt.of((int)6)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).decorators(List.of(new AriaMushroomTreeDecorator(1.0f))).ignoreVines().build()));
        context.register(FELLCAP_PATCH, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)new RandomPatchConfiguration(8, 4, 3, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)WetlandWhimsyBlocks.FELLCAP_MUSHROOM.get())))))));
        context.register(CORDGRASS_PATCH, (Object)new ConfiguredFeature(Feature.FLOWER, (FeatureConfiguration)new RandomPatchConfiguration(64, 4, 3, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)WetlandWhimsyBlocks.CORDGRASS.get())))))));
        context.register(PENNYWORT_PATCH, (Object)new ConfiguredFeature(Feature.FLOWER, (FeatureConfiguration)new RandomPatchConfiguration(64, 10, 4, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(pennywortRandomState))))));
        context.register(PENNYWORT_PATCH_SMALL, (Object)new ConfiguredFeature(Feature.FLOWER, (FeatureConfiguration)new RandomPatchConfiguration(4, 3, 4, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(pennywortRandomState))))));
        context.register(LEMONSTONE_BLOB, (Object)new ConfiguredFeature(WetlandWhimsyFeatures.BLOB_PATCH.get(), (FeatureConfiguration)new BlobPatchConfig(RuleBasedBlockStateProvider.simple((Block)((Block)WetlandWhimsyBlocks.LEMONSTONE.get())), BlockPredicate.matchesBlocks(List.of(Blocks.DIRT, Blocks.STONE, Blocks.DIORITE, Blocks.GRANITE, Blocks.ANDESITE)), (IntProvider)UniformInt.of((int)6, (int)8))));
        context.register(MUD_BLOB, (Object)new ConfiguredFeature(WetlandWhimsyFeatures.BLOB_PATCH.get(), (FeatureConfiguration)new BlobPatchConfig(RuleBasedBlockStateProvider.simple((Block)Blocks.MUD), BlockPredicate.matchesBlocks(List.of(Blocks.DIRT, Blocks.GRASS_BLOCK, Blocks.SAND)), (IntProvider)UniformInt.of((int)4, (int)7))));
        context.register(MUD_PATCH, (Object)new ConfiguredFeature(Feature.VEGETATION_PATCH, (FeatureConfiguration)WetlandWhimsyConfiguredFeatures.vegetation(configuredFeatures, 2, 5)));
        context.register(MUD_POOL, (Object)new ConfiguredFeature(Feature.WATERLOGGED_VEGETATION_PATCH, (FeatureConfiguration)WetlandWhimsyConfiguredFeatures.vegetation(configuredFeatures, 5, 8)));
        Holder.Reference HUGE_BROWN_MUSHROOM = configuredFeatures.getOrThrow(TreeFeatures.HUGE_BROWN_MUSHROOM);
        Holder.Reference BIRCH = configuredFeatures.getOrThrow(TreeFeatures.BIRCH);
        Holder.Reference SPRUCE = configuredFeatures.getOrThrow(TreeFeatures.SPRUCE);
        BlockPredicateFilter SAPLING_PREDICATE = PlacementUtils.filteredByBlockSurvival((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get()));
        context.register(TREES_BOG, (Object)new ConfiguredFeature(Feature.RANDOM_SELECTOR, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(BALD_CYPRESS_TREE), (PlacementModifier[])new PlacementModifier[]{SAPLING_PREDICATE}), 0.4f), new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(HUGE_ARIA_MUSHROOM), (PlacementModifier[])new PlacementModifier[]{SAPLING_PREDICATE}), 0.03f), new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)HUGE_BROWN_MUSHROOM, (PlacementModifier[])new PlacementModifier[]{SAPLING_PREDICATE}), 0.15f)), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(BALD_CYPRESS_TREE), (PlacementModifier[])new PlacementModifier[]{SAPLING_PREDICATE}))));
        context.register(TREES_MARSH, (Object)new ConfiguredFeature(Feature.RANDOM_SELECTOR, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(BALD_CYPRESS_TREE), (PlacementModifier[])new PlacementModifier[]{SAPLING_PREDICATE}), 0.3f), new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)BIRCH, (PlacementModifier[])new PlacementModifier[]{SAPLING_PREDICATE}), 0.5f), new WeightedPlacedFeature(PlacementUtils.inlinePlaced((Holder)SPRUCE, (PlacementModifier[])new PlacementModifier[]{SAPLING_PREDICATE}), 0.5f)), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(BALD_CYPRESS_TREE), (PlacementModifier[])new PlacementModifier[]{SAPLING_PREDICATE}))));
    }

    static VegetationPatchConfiguration vegetation(HolderGetter<ConfiguredFeature<?, ?>> configuredFeatures, int minSize, int maxSize) {
        return new VegetationPatchConfiguration(BlockTags.LUSH_GROUND_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.MUD), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(PENNYWORT_PATCH_SMALL), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.of((int)3), 0.8f, 5, 0.1f, (IntProvider)UniformInt.of((int)5, (int)8), 0.7f);
    }
}

