/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.datagen.tags;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import uwu.juni.wetland_whimsy.datagen.registries.WetlandWhimsyBiomes;
import uwu.juni.wetland_whimsy.tags.WetlandWhimsyTags;

public class WetlandWhimsyBiomeTags
extends BiomeTagsProvider {
    public WetlandWhimsyBiomeTags(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper helper) {
        super(output, registries, "wetland_whimsy", helper);
    }

    public void addTags(@Nonnull HolderLookup.Provider provider) {
        this.addTagsToBiome(WetlandWhimsyBiomes.MARSH, Tags.Biomes.IS_SWAMP, BiomeTags.IS_OVERWORLD, BiomeTags.HAS_MINESHAFT, BiomeTags.ALLOWS_SURFACE_SLIME_SPAWNS, BiomeTags.HAS_RUINED_PORTAL_SWAMP, BiomeTags.HAS_SWAMP_HUT, BiomeTags.HAS_SHIPWRECK_BEACHED, BiomeTags.IS_BEACH);
        this.addOptionalTagToList((TagKey<Biome>)BiomeTags.HAS_TRAIL_RUINS, Biomes.SWAMP, WetlandWhimsyBiomes.MARSH);
        this.addOptionalTagToList(WetlandWhimsyTags.Biomes.FELLCAP_SURFACE, WetlandWhimsyBiomes.MARSH, Biomes.DARK_FOREST, Biomes.MUSHROOM_FIELDS, Biomes.SWAMP);
        this.tag(WetlandWhimsyTags.Biomes.SPAWNS_CRAWFISH).addTag(Tags.Biomes.IS_RIVER);
        this.tag(WetlandWhimsyTags.Biomes.SPAWNS_CRAWFISH).addTag(Tags.Biomes.IS_SWAMP);
    }

    @SafeVarargs
    private void addOptionalTagToList(TagKey<Biome> tag, ResourceKey<Biome> ... biomes) {
        for (ResourceKey<Biome> biome : biomes) {
            this.tag(tag).addOptional(biome.location());
        }
    }

    @SafeVarargs
    private void addTagsToBiome(ResourceKey<Biome> biome, TagKey<Biome> ... tags) {
        ResourceLocation loc = biome.location();
        for (TagKey<Biome> tag : tags) {
            this.tag(tag).addOptional(loc);
        }
    }
}

