/*
 * Decompiled with CFR 0.152.
 */
package capsule.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;

public class RendererUtils {
    public static void doPositionPrologue(Camera camera, PoseStack poseStack) {
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(camera.m_90589_()));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(camera.m_90590_() + 180.0f));
        poseStack.m_85837_(-camera.m_90583_().f_82479_, -camera.m_90583_().f_82480_, -camera.m_90583_().f_82481_);
    }

    public static void doPositionEpilogue(PoseStack poseStack) {
        poseStack.m_85849_();
    }

    public static void doOverlayPrologue() {
        RenderSystem.m_69472_();
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
    }

    public static void doOverlayEpilogue() {
        RenderSystem.m_69493_();
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
    }

    public static void doWirePrologue() {
        RenderSystem.m_69464_();
        RenderSystem.m_69472_();
        RenderSystem.m_69832_((float)3.0f);
    }

    public static void doWireEpilogue() {
        RenderSystem.m_69832_((float)1.0f);
        RenderSystem.m_69493_();
        RenderSystem.m_69481_();
    }

    public static void drawCube(BlockPos pos, float sizeOffset, VertexConsumer buffer) {
        RendererUtils.drawCube((float)pos.m_123341_() - sizeOffset, (float)pos.m_123342_() - sizeOffset, (float)pos.m_123343_() - sizeOffset, (float)(pos.m_123341_() + 1) + sizeOffset, (float)(pos.m_123342_() + 1) + sizeOffset, (float)(pos.m_123343_() + 1) + sizeOffset, buffer);
    }

    public static void drawCube(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, VertexConsumer buffer) {
        RendererUtils.drawPlaneNegX(minX, minY, maxY, minZ, maxZ, buffer);
        RendererUtils.drawPlanePosX(maxX, minY, maxY, minZ, maxZ, buffer);
        RendererUtils.drawPlaneNegY(minY, minX, maxX, minZ, maxZ, buffer);
        RendererUtils.drawPlanePosY(maxY, minX, maxX, minZ, maxZ, buffer);
        RendererUtils.drawPlaneNegZ(minZ, minX, maxX, minY, maxY, buffer);
        RendererUtils.drawPlanePosZ(maxZ, minX, maxX, minY, maxY, buffer);
    }

    public static void drawPlaneNegX(double x, double minY, double maxY, double minZ, double maxZ, VertexConsumer buffer) {
        buffer.m_5483_(x, minY, minZ).m_5752_();
        buffer.m_5483_(x, minY, maxZ).m_5752_();
        buffer.m_5483_(x, maxY, maxZ).m_5752_();
        buffer.m_5483_(x, maxY, minZ).m_5752_();
    }

    public static void drawPlanePosX(double x, double minY, double maxY, double minZ, double maxZ, VertexConsumer buffer) {
        buffer.m_5483_(x, minY, minZ).m_5752_();
        buffer.m_5483_(x, maxY, minZ).m_5752_();
        buffer.m_5483_(x, maxY, maxZ).m_5752_();
        buffer.m_5483_(x, minY, maxZ).m_5752_();
    }

    public static void drawPlaneNegY(double y, double minX, double maxX, double minZ, double maxZ, VertexConsumer buffer) {
        buffer.m_5483_(minX, y, minZ).m_5752_();
        buffer.m_5483_(maxX, y, minZ).m_5752_();
        buffer.m_5483_(maxX, y, maxZ).m_5752_();
        buffer.m_5483_(minX, y, maxZ).m_5752_();
    }

    public static void drawPlanePosY(double y, double minX, double maxX, double minZ, double maxZ, VertexConsumer buffer) {
        buffer.m_5483_(minX, y, minZ).m_5752_();
        buffer.m_5483_(minX, y, maxZ).m_5752_();
        buffer.m_5483_(maxX, y, maxZ).m_5752_();
        buffer.m_5483_(maxX, y, minZ).m_5752_();
    }

    public static void drawPlaneNegZ(double z, double minX, double maxX, double minY, double maxY, VertexConsumer buffer) {
        buffer.m_5483_(minX, minY, z).m_5752_();
        buffer.m_5483_(minX, maxY, z).m_5752_();
        buffer.m_5483_(maxX, maxY, z).m_5752_();
        buffer.m_5483_(maxX, minY, z).m_5752_();
    }

    public static void drawPlanePosZ(double z, double minX, double maxX, double minY, double maxY, VertexConsumer buffer) {
        buffer.m_5483_(minX, minY, z).m_5752_();
        buffer.m_5483_(maxX, minY, z).m_5752_();
        buffer.m_5483_(maxX, maxY, z).m_5752_();
        buffer.m_5483_(minX, maxY, z).m_5752_();
    }

    public static void drawCapsuleCube(AABB boundingBox, BufferBuilder bufferBuilder) {
        RendererUtils.drawPlaneNegX(boundingBox.f_82288_, boundingBox.f_82289_, boundingBox.f_82292_, boundingBox.f_82290_, boundingBox.f_82293_, (VertexConsumer)bufferBuilder);
        RendererUtils.drawPlanePosX(boundingBox.f_82291_, boundingBox.f_82289_, boundingBox.f_82292_, boundingBox.f_82290_, boundingBox.f_82293_, (VertexConsumer)bufferBuilder);
        RendererUtils.drawPlaneNegY(boundingBox.f_82289_, boundingBox.f_82288_, boundingBox.f_82291_, boundingBox.f_82290_, boundingBox.f_82293_, (VertexConsumer)bufferBuilder);
        RendererUtils.drawPlanePosY(boundingBox.f_82292_, boundingBox.f_82288_, boundingBox.f_82291_, boundingBox.f_82290_, boundingBox.f_82293_, (VertexConsumer)bufferBuilder);
        RendererUtils.drawPlaneNegZ(boundingBox.f_82290_, boundingBox.f_82288_, boundingBox.f_82291_, boundingBox.f_82289_, boundingBox.f_82292_, (VertexConsumer)bufferBuilder);
        RendererUtils.drawPlanePosZ(boundingBox.f_82293_, boundingBox.f_82288_, boundingBox.f_82291_, boundingBox.f_82289_, boundingBox.f_82292_, (VertexConsumer)bufferBuilder);
    }

    public static void setColor(int rgb, int alpha) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        float af = (float)alpha / 255.0f;
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        RenderSystem.m_157429_((float)rf, (float)gf, (float)bf, (float)af);
    }
}

