/*
 * Decompiled with CFR 0.152.
 */
package capsule.enchantments;

import capsule.enchantments.CapsuleEnchantments;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItem;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="capsule", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RecallEnchant
extends Enchantment {
    protected RecallEnchant(Enchantment.Rarity rarity, EnchantmentCategory enchType) {
        super(rarity, enchType, EquipmentSlot.values());
    }

    public boolean m_6081_(ItemStack stack) {
        return this.canApplyAtEnchantingTable(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return stack.m_41720_() instanceof CapsuleItem && !CapsuleItem.isBlueprint(stack) && !CapsuleItem.isOneUse(stack) || this.f_44672_ != null && super.canApplyAtEnchantingTable(stack);
    }

    public int m_6183_(int enchantmentLevel) {
        return 1;
    }

    public int m_6175_(int enchantmentLevel) {
        return this.m_6183_(enchantmentLevel) + 40;
    }

    public int m_6586_() {
        return 1;
    }

    public static void pickupItemBack(ItemEntity entity, Player player) {
        if (player != null) {
            entity.m_32061_();
            entity.m_6123_(player);
        }
    }

    @SubscribeEvent
    public static void onWorldTickEvent(TickEvent.WorldTickEvent wte) {
        if (wte.side == LogicalSide.CLIENT || wte.phase != TickEvent.Phase.END) {
            return;
        }
        ServerLevel world = (ServerLevel)wte.world;
        List recallEntities = world.m_143280_((EntityTypeTest)EntityType.f_20461_, CapsuleEnchantments.hasRecallEnchant);
        List recallItemEntities = recallEntities.stream().filter(Objects::nonNull).map(entity -> entity).collect(Collectors.toList());
        for (ItemEntity entity2 : recallItemEntities) {
            if (entity2.m_32057_() == null || !entity2.f_19862_ && !entity2.f_19863_ && !Spacial.ItemEntityShouldAndCollideLiquid(entity2)) continue;
            if (!entity2.m_20077_()) {
                entity2.m_8119_();
            }
            if (!entity2.m_6084_()) continue;
            RecallEnchant.pickupItemBack(entity2, world.m_46003_(entity2.m_32057_()));
        }
    }
}

